/*
 * Decompiled with CFR 0.152.
 */
package net.thanatosx.previewer;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.FloatEvaluator;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.animation.AccelerateInterpolator;
import android.widget.ImageView;

public class ImagePreviewView
extends ImageView {
    private ScaleGestureDetector mScaleDetector = new ScaleGestureDetector(this.getContext(), (ScaleGestureDetector.OnScaleGestureListener)new ScaleListener());
    private GestureDetector mFlatDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new FlatGestureListener());
    private float scale = 1.0f;
    private static final float mMaxScale = 4.0f;
    private static final float mMinScale = 0.4f;
    private float translateLeft = 0.0f;
    private float translateTop = 0.0f;
    private int mBoundWidth = 0;
    private int mBoundHeight = 0;
    private boolean isTranslating = false;
    private boolean isScaling = false;
    private boolean isAutoScale = false;
    private ValueAnimator resetScaleAnimator;
    private ValueAnimator resetXAnimator;
    private ValueAnimator resetYAnimator;
    private ValueAnimator.AnimatorUpdateListener onScaleAnimationUpdate;
    private ValueAnimator.AnimatorUpdateListener onTranslateXAnimationUpdate;
    private ValueAnimator.AnimatorUpdateListener onTranslateYAnimationUpdate;

    public ImagePreviewView(Context context) {
        super(context);
    }

    public ImagePreviewView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ImagePreviewView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public ValueAnimator.AnimatorUpdateListener getOnScaleAnimationUpdate() {
        if (this.onScaleAnimationUpdate != null) {
            return this.onScaleAnimationUpdate;
        }
        this.onScaleAnimationUpdate = new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                ImagePreviewView.this.scale = ((Float)animation.getAnimatedValue()).floatValue();
                ImagePreviewView.this.invalidate();
            }
        };
        return this.onScaleAnimationUpdate;
    }

    public ValueAnimator.AnimatorUpdateListener getOnTranslateXAnimationUpdate() {
        if (this.onTranslateXAnimationUpdate != null) {
            return this.onTranslateXAnimationUpdate;
        }
        this.onTranslateXAnimationUpdate = new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                ImagePreviewView.this.translateLeft = ((Float)animation.getAnimatedValue()).floatValue();
                ImagePreviewView.this.invalidate();
            }
        };
        return this.onTranslateXAnimationUpdate;
    }

    public ValueAnimator.AnimatorUpdateListener getOnTranslateYAnimationUpdate() {
        if (this.onTranslateYAnimationUpdate != null) {
            return this.onTranslateYAnimationUpdate;
        }
        this.onTranslateYAnimationUpdate = new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                ImagePreviewView.this.translateTop = ((Float)animation.getAnimatedValue()).floatValue();
                ImagePreviewView.this.invalidate();
            }
        };
        return this.onTranslateYAnimationUpdate;
    }

    private ValueAnimator getResetScaleAnimator() {
        if (this.resetScaleAnimator != null) {
            this.resetScaleAnimator.removeAllUpdateListeners();
            return this.resetScaleAnimator;
        }
        this.resetScaleAnimator = ValueAnimator.ofFloat((float[])new float[0]);
        this.resetScaleAnimator.setDuration(150L);
        this.resetScaleAnimator.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        this.resetScaleAnimator.setEvaluator((TypeEvaluator)new FloatEvaluator());
        this.resetScaleAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
            }
        });
        return this.resetScaleAnimator;
    }

    private void cancelResetScaleAnimation() {
        if (this.resetScaleAnimator == null || !this.resetScaleAnimator.isRunning()) {
            return;
        }
        this.resetScaleAnimator.cancel();
    }

    private ValueAnimator getResetXAnimator() {
        if (this.resetXAnimator != null) {
            this.resetXAnimator.removeAllUpdateListeners();
            return this.resetXAnimator;
        }
        this.resetXAnimator = ValueAnimator.ofFloat((float[])new float[0]);
        this.resetXAnimator.setDuration(150L);
        this.resetXAnimator.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        this.resetXAnimator.setEvaluator((TypeEvaluator)new FloatEvaluator());
        return this.resetXAnimator;
    }

    private void cancelResetFlatXAnimation() {
        if (this.resetXAnimator == null || !this.resetXAnimator.isRunning()) {
            return;
        }
        this.resetXAnimator.cancel();
    }

    private ValueAnimator getResetYAnimator() {
        if (this.resetYAnimator != null) {
            this.resetYAnimator.removeAllUpdateListeners();
            return this.resetYAnimator;
        }
        this.resetYAnimator = ValueAnimator.ofFloat((float[])new float[0]);
        this.resetYAnimator.setDuration(150L);
        this.resetYAnimator.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        this.resetYAnimator.setEvaluator((TypeEvaluator)new FloatEvaluator());
        return this.resetYAnimator;
    }

    private void cancelResetFlatYAnimation() {
        if (this.resetYAnimator == null || !this.resetYAnimator.isRunning()) {
            return;
        }
        this.resetYAnimator.cancel();
    }

    private float getDiffX() {
        float mScaledWidth = (float)this.mBoundWidth * this.scale;
        return this.translateLeft >= 0.0f ? this.translateLeft : ((float)this.getWidth() - this.translateLeft - mScaledWidth > 0.0f ? -((float)this.getWidth() - this.translateLeft - mScaledWidth) : 0.0f);
    }

    private float getDiffY() {
        float mScaledHeight = (float)this.mBoundHeight * this.scale;
        return this.translateTop >= 0.0f ? this.translateTop : ((float)this.getHeight() - this.translateTop - mScaledHeight > 0.0f ? -((float)this.getHeight() - this.translateTop - mScaledHeight) : 0.0f);
    }

    public boolean onTouchEvent(MotionEvent event) {
        int action = event.getAction();
        if (action == 0) {
            if (this.getResetScaleAnimator().isRunning()) {
                this.cancelResetScaleAnimation();
            }
            if (this.getResetXAnimator().isRunning()) {
                this.cancelResetFlatXAnimation();
            }
            if (this.getResetYAnimator().isRunning()) {
                this.cancelResetFlatYAnimation();
            }
        }
        boolean translated = this.mFlatDetector.onTouchEvent(event);
        boolean scaled = this.mScaleDetector.onTouchEvent(event);
        if (action == 1 || action == 3) {
            if (this.isAutoScale) {
                this.isAutoScale = false;
            } else {
                ValueAnimator animator;
                if (this.isTranslating) {
                    this.isTranslating = false;
                }
                if (this.scale < 1.0f) {
                    ValueAnimator animator2 = this.getResetScaleAnimator();
                    animator2.setFloatValues(new float[]{this.scale, 1.0f});
                    animator2.addUpdateListener(this.getOnScaleAnimationUpdate());
                    animator2.start();
                }
                float mScaledWidth = (float)this.mBoundWidth * this.scale;
                float mScaledHeight = (float)this.mBoundHeight * this.scale;
                float mDiffX = this.getDiffX();
                float mDiffY = this.getDiffY();
                if (mScaledWidth >= (float)this.getWidth() && mDiffX != 0.0f) {
                    animator = this.getResetXAnimator();
                    animator.setFloatValues(new float[]{this.translateLeft, this.translateLeft - mDiffX});
                    animator.addUpdateListener(this.getOnTranslateXAnimationUpdate());
                    animator.start();
                }
                if (mScaledHeight >= (float)this.getHeight() && mDiffY != 0.0f) {
                    animator = this.getResetYAnimator();
                    animator.setFloatValues(new float[]{this.translateTop, this.translateTop - mDiffY});
                    animator.addUpdateListener(this.getOnTranslateYAnimationUpdate());
                    animator.start();
                }
                if (mScaledWidth < (float)this.getWidth() && mScaledHeight >= (float)this.getHeight() && mDiffX != 0.0f) {
                    animator = this.getResetXAnimator();
                    animator.setFloatValues(new float[]{this.translateLeft, ((float)this.getWidth() - mScaledWidth) / 2.0f});
                    animator.addUpdateListener(this.getOnTranslateXAnimationUpdate());
                    animator.start();
                }
                if (mScaledHeight < (float)this.getHeight() && mScaledWidth >= (float)this.getWidth() && mDiffY != 0.0f) {
                    animator = this.getResetYAnimator();
                    animator.setFloatValues(new float[]{this.translateTop, ((float)this.getHeight() - mScaledHeight) / 2.0f});
                    animator.addUpdateListener(this.getOnTranslateYAnimationUpdate());
                    animator.start();
                }
                if (mScaledWidth < (float)this.getWidth() && mScaledHeight < (float)this.getHeight()) {
                    this.resetDefaultState();
                }
            }
        }
        return action == 0 || scaled || translated;
    }

    private void resetDefaultState() {
        float midWidth = (this.getWidth() - this.mBoundWidth) / 2;
        float midHeight = (this.getHeight() - this.mBoundHeight) / 2;
        if (midWidth != this.translateLeft) {
            ValueAnimator mTranslateXAnimator = this.getResetXAnimator();
            mTranslateXAnimator.setFloatValues(new float[]{this.translateLeft, midWidth});
            mTranslateXAnimator.addUpdateListener(this.getOnTranslateXAnimationUpdate());
            mTranslateXAnimator.start();
        }
        if (midHeight != this.translateTop) {
            ValueAnimator mTranslateYAnimator = this.getResetYAnimator();
            mTranslateYAnimator.setFloatValues(new float[]{this.translateTop, midHeight});
            mTranslateYAnimator.addUpdateListener(this.getOnTranslateYAnimationUpdate());
            mTranslateYAnimator.start();
        }
    }

    protected boolean setFrame(int l, int t, int r, int b) {
        boolean change = super.setFrame(l, t, r, b);
        Drawable drawable = this.getDrawable();
        if (drawable == null) {
            return false;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        this.mBoundWidth = drawable.getBounds().width();
        this.mBoundHeight = drawable.getBounds().height();
        float scale = Math.max((float)this.mBoundWidth / (float)width, (float)this.mBoundHeight / (float)height);
        this.mBoundHeight = (int)((float)this.mBoundHeight / scale);
        this.mBoundWidth = (int)((float)this.mBoundWidth / scale);
        drawable.setBounds(0, 0, this.mBoundWidth, this.mBoundHeight);
        this.translateLeft = (width - this.mBoundWidth) / 2;
        this.translateTop = (height - this.mBoundHeight) / 2;
        return change;
    }

    protected void onDraw(Canvas canvas) {
        Drawable mDrawable = this.getDrawable();
        if (mDrawable == null) {
            return;
        }
        int mDrawableWidth = mDrawable.getIntrinsicWidth();
        int mDrawableHeight = mDrawable.getIntrinsicHeight();
        if (mDrawableWidth == 0 || mDrawableHeight == 0) {
            return;
        }
        int saveCount = canvas.getSaveCount();
        canvas.save();
        canvas.translate(this.translateLeft, this.translateTop);
        canvas.scale(this.scale, this.scale);
        mDrawable.draw(canvas);
        canvas.restoreToCount(saveCount);
    }

    private class FlatGestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private FlatGestureListener() {
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            if (ImagePreviewView.this.isScaling) {
                return false;
            }
            ImagePreviewView.this.isTranslating = true;
            float mScaledWidth = (float)ImagePreviewView.this.mBoundWidth * ImagePreviewView.this.scale;
            float mScaledHeight = (float)ImagePreviewView.this.mBoundHeight * ImagePreviewView.this.scale;
            boolean change = false;
            if (mScaledHeight > (float)ImagePreviewView.this.getHeight()) {
                if (ImagePreviewView.this.getDiffY() != 0.0f) {
                    float disY = (float)(Math.acos(Math.abs(ImagePreviewView.this.getDiffY()) / (float)ImagePreviewView.this.getHeight() * 6.0f) * (double)distanceY);
                    if (disY == disY) {
                        ImagePreviewView.this.translateTop = ImagePreviewView.this.translateTop - disY;
                    }
                } else {
                    ImagePreviewView.this.translateTop = (float)((double)ImagePreviewView.this.translateTop - (double)distanceY * 1.5);
                }
                change = true;
            }
            if (mScaledWidth > (float)ImagePreviewView.this.getWidth()) {
                if (ImagePreviewView.this.getDiffX() != 0.0f) {
                    float disX = (float)(Math.acos(Math.abs(ImagePreviewView.this.getDiffX()) / (float)ImagePreviewView.this.getWidth() * 4.0f) * (double)distanceX);
                    if (disX == disX) {
                        ImagePreviewView.this.translateLeft = ImagePreviewView.this.translateLeft - disX;
                    }
                } else {
                    ImagePreviewView.this.translateLeft = (float)((double)ImagePreviewView.this.translateLeft - (double)distanceX * 1.5);
                }
                change = true;
            }
            if (change) {
                ImagePreviewView.this.invalidate();
            }
            return change;
        }

        public boolean onDoubleTap(MotionEvent e) {
            ImagePreviewView.this.isAutoScale = true;
            ValueAnimator mResetScaleAnimator = ImagePreviewView.this.getResetScaleAnimator();
            if (ImagePreviewView.this.scale == 1.0f) {
                mResetScaleAnimator.setFloatValues(new float[]{1.0f, 2.0f});
                ValueAnimator mResetXAnimator = ImagePreviewView.this.getResetXAnimator();
                ValueAnimator mResetYAnimator = ImagePreviewView.this.getResetYAnimator();
                mResetXAnimator.setFloatValues(new float[]{ImagePreviewView.this.translateLeft, ((float)ImagePreviewView.this.getWidth() - (float)ImagePreviewView.this.mBoundWidth * 2.0f) / 2.0f});
                mResetYAnimator.setFloatValues(new float[]{ImagePreviewView.this.translateTop, ((float)ImagePreviewView.this.getHeight() - (float)ImagePreviewView.this.mBoundHeight * 2.0f) / 2.0f});
                mResetXAnimator.addUpdateListener(ImagePreviewView.this.getOnTranslateXAnimationUpdate());
                mResetYAnimator.addUpdateListener(ImagePreviewView.this.getOnTranslateYAnimationUpdate());
                mResetXAnimator.start();
                mResetYAnimator.start();
            } else {
                mResetScaleAnimator.setFloatValues(new float[]{ImagePreviewView.this.scale, 1.0f});
                ImagePreviewView.this.resetDefaultState();
            }
            mResetScaleAnimator.addUpdateListener(ImagePreviewView.this.getOnScaleAnimationUpdate());
            mResetScaleAnimator.start();
            return true;
        }
    }

    private class ScaleListener
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        private ScaleListener() {
        }

        public boolean onScale(ScaleGestureDetector detector) {
            float mOldScaledWidth = (float)ImagePreviewView.this.mBoundWidth * ImagePreviewView.this.scale;
            float mOldScaledHeight = (float)ImagePreviewView.this.mBoundHeight * ImagePreviewView.this.scale;
            if (mOldScaledWidth > (float)ImagePreviewView.this.getWidth() && ImagePreviewView.this.getDiffX() != 0.0f || mOldScaledHeight > (float)ImagePreviewView.this.getHeight() && ImagePreviewView.this.getDiffY() != 0.0f) {
                return false;
            }
            ImagePreviewView.this.isScaling = true;
            float factor = detector.getScaleFactor();
            float value = ImagePreviewView.this.scale;
            if ((value += (factor - 1.0f) * 2.0f) == ImagePreviewView.this.scale) {
                return true;
            }
            if (value <= 0.4f) {
                return ImagePreviewView.this.isScaling = false;
            }
            if (value > 4.0f) {
                return ImagePreviewView.this.isScaling = false;
            }
            ImagePreviewView.this.scale = value;
            float mScaledWidth = (float)ImagePreviewView.this.mBoundWidth * ImagePreviewView.this.scale;
            float mScaledHeight = (float)ImagePreviewView.this.mBoundHeight * ImagePreviewView.this.scale;
            ImagePreviewView.this.translateLeft = (float)ImagePreviewView.this.getWidth() / 2.0f - ((float)ImagePreviewView.this.getWidth() / 2.0f - ImagePreviewView.this.translateLeft) * mScaledWidth / mOldScaledWidth;
            ImagePreviewView.this.translateTop = (float)ImagePreviewView.this.getHeight() / 2.0f - ((float)ImagePreviewView.this.getHeight() / 2.0f - ImagePreviewView.this.translateTop) * mScaledHeight / mOldScaledHeight;
            float diffX = ImagePreviewView.this.getDiffX();
            float diffY = ImagePreviewView.this.getDiffY();
            if (diffX > 0.0f && mScaledWidth > (float)ImagePreviewView.this.getWidth()) {
                ImagePreviewView.this.translateLeft = 0.0f;
            }
            if (diffX < 0.0f && mScaledWidth > (float)ImagePreviewView.this.getWidth()) {
                ImagePreviewView.this.translateLeft = (float)ImagePreviewView.this.getWidth() - mScaledWidth;
            }
            if (diffY > 0.0f && mScaledHeight > (float)ImagePreviewView.this.getHeight()) {
                ImagePreviewView.this.translateTop = 0.0f;
            }
            if (diffY < 0.0f && mScaledHeight > (float)ImagePreviewView.this.getHeight()) {
                ImagePreviewView.this.translateTop = (float)ImagePreviewView.this.getHeight() - mScaledHeight;
            }
            ImagePreviewView.this.invalidate();
            return true;
        }

        public void onScaleEnd(ScaleGestureDetector detector) {
            super.onScaleEnd(detector);
            ImagePreviewView.this.isScaling = false;
        }
    }
}

