/*
 * Decompiled with CFR 0.152.
 */
package net.steamcrafted.loadtoast;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.nineoldandroids.animation.ValueAnimator;
import net.steamcrafted.loadtoast.R;

public class LoadToastView
extends View {
    private String mText = "";
    private Paint textPaint = new Paint();
    private Paint backPaint = new Paint();
    private Paint iconBackPaint = new Paint();
    private Paint loaderPaint = new Paint();
    private Paint successPaint = new Paint();
    private Paint errorPaint = new Paint();
    private Rect iconBounds;
    private Rect mTextBounds = new Rect();
    private RectF spinnerRect = new RectF();
    private int MAX_TEXT_WIDTH = 100;
    private int BASE_TEXT_SIZE = 20;
    private int IMAGE_WIDTH = 40;
    private int TOAST_HEIGHT = 48;
    private float WIDTH_SCALE = 0.0f;
    private Drawable completeicon;
    private Drawable failedicon;
    private ValueAnimator va;
    private ValueAnimator cmp;
    private boolean success = true;
    private Path toastPath = new Path();
    private AccelerateDecelerateInterpolator easeinterpol = new AccelerateDecelerateInterpolator();

    public LoadToastView(Context context) {
        super(context);
        this.textPaint.setTextSize(15.0f);
        this.textPaint.setColor(-16777216);
        this.textPaint.setAntiAlias(true);
        this.backPaint.setColor(-1);
        this.backPaint.setAntiAlias(true);
        this.iconBackPaint.setColor(-16776961);
        this.iconBackPaint.setAntiAlias(true);
        this.loaderPaint.setStrokeWidth((float)this.dpToPx(4));
        this.loaderPaint.setAntiAlias(true);
        this.loaderPaint.setColor(this.fetchPrimaryColor());
        this.loaderPaint.setStyle(Paint.Style.STROKE);
        this.successPaint.setColor(this.getResources().getColor(R.color.color_success));
        this.errorPaint.setColor(this.getResources().getColor(R.color.color_error));
        this.successPaint.setAntiAlias(true);
        this.errorPaint.setAntiAlias(true);
        this.MAX_TEXT_WIDTH = this.dpToPx(this.MAX_TEXT_WIDTH);
        this.BASE_TEXT_SIZE = this.dpToPx(this.BASE_TEXT_SIZE);
        this.IMAGE_WIDTH = this.dpToPx(this.IMAGE_WIDTH);
        this.TOAST_HEIGHT = this.dpToPx(this.TOAST_HEIGHT);
        int padding = (this.TOAST_HEIGHT - this.IMAGE_WIDTH) / 2;
        this.iconBounds = new Rect(this.TOAST_HEIGHT + this.MAX_TEXT_WIDTH - padding, padding, this.TOAST_HEIGHT + this.MAX_TEXT_WIDTH - padding + this.IMAGE_WIDTH, this.IMAGE_WIDTH + padding);
        this.completeicon = this.getResources().getDrawable(R.drawable.ic_navigation_check);
        this.completeicon.setBounds(this.iconBounds);
        this.failedicon = this.getResources().getDrawable(R.drawable.ic_error);
        this.failedicon.setBounds(this.iconBounds);
        this.va = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        this.va.setDuration(6000L);
        this.va.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                LoadToastView.this.postInvalidate();
            }
        });
        this.va.setRepeatMode(-1);
        this.va.setRepeatCount(9999999);
        this.va.setInterpolator((Interpolator)new LinearInterpolator());
        this.va.start();
        this.calculateBounds();
    }

    public void setTextColor(int color2) {
        this.textPaint.setColor(color2);
    }

    public void setBackgroundColor(int color2) {
        this.backPaint.setColor(color2);
        this.iconBackPaint.setColor(color2);
    }

    public void setProgressColor(int color2) {
        this.loaderPaint.setColor(color2);
    }

    public void show() {
        this.WIDTH_SCALE = 0.0f;
        if (this.cmp != null) {
            this.cmp.removeAllUpdateListeners();
        }
    }

    public void success() {
        this.success = true;
        this.done();
    }

    public void error() {
        this.success = false;
        this.done();
    }

    private void done() {
        this.cmp = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        this.cmp.setDuration(600L);
        this.cmp.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                LoadToastView.this.WIDTH_SCALE = 2.0f * valueAnimator.getAnimatedFraction();
                LoadToastView.this.postInvalidate();
            }
        });
        this.cmp.setInterpolator((Interpolator)new DecelerateInterpolator());
        this.cmp.start();
    }

    private int fetchPrimaryColor() {
        if (Build.VERSION.SDK_INT >= 21) {
            TypedValue typedValue = new TypedValue();
            TypedArray a = this.getContext().obtainStyledAttributes(typedValue.data, new int[]{16843829});
            int color2 = a.getColor(0, 0);
            a.recycle();
            return color2;
        }
        return Color.rgb((int)155, (int)155, (int)155);
    }

    private int dpToPx(int dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    public void setText(String text) {
        this.mText = text;
        this.calculateBounds();
    }

    private void calculateBounds() {
        this.textPaint.setTextSize((float)this.BASE_TEXT_SIZE);
        this.textPaint.getTextBounds(this.mText, 0, this.mText.length(), this.mTextBounds);
        if (this.mTextBounds.width() > this.MAX_TEXT_WIDTH) {
            int textSize = this.BASE_TEXT_SIZE;
            while (textSize > this.dpToPx(13) && this.mTextBounds.width() > this.MAX_TEXT_WIDTH) {
                this.textPaint.setTextSize((float)(--textSize));
                this.textPaint.getTextBounds(this.mText, 0, this.mText.length(), this.mTextBounds);
            }
            if (this.mTextBounds.width() > this.MAX_TEXT_WIDTH) {
                float keep = (float)this.MAX_TEXT_WIDTH / (float)this.mTextBounds.width();
                int charcount = (int)((float)this.mText.length() * keep);
                this.mText = this.mText.substring(0, charcount);
                this.textPaint.getTextBounds(this.mText, 0, this.mText.length(), this.mTextBounds);
            }
        }
    }

    protected void onDraw(Canvas c) {
        super.onDraw(c);
        float ws = Math.max(1.0f - this.WIDTH_SCALE, 0.0f);
        float translateLoad = (1.0f - ws) * (float)(this.IMAGE_WIDTH + this.MAX_TEXT_WIDTH);
        float leftMargin = translateLoad / 2.0f;
        float textOpactity = Math.max(0.0f, ws * 10.0f - 9.0f);
        this.textPaint.setAlpha((int)(textOpactity * 255.0f));
        this.spinnerRect.set((float)(this.iconBounds.left + this.dpToPx(4)) - translateLoad / 2.0f, (float)(this.iconBounds.top + this.dpToPx(4)), (float)(this.iconBounds.right - this.dpToPx(4)) - translateLoad / 2.0f, (float)(this.iconBounds.bottom - this.dpToPx(4)));
        int circleOffset = (int)((double)(this.TOAST_HEIGHT * 2) * (Math.sqrt(2.0) - 1.0) / 3.0);
        int th = this.TOAST_HEIGHT;
        int pd = (this.TOAST_HEIGHT - this.IMAGE_WIDTH) / 2;
        int iconoffset = (int)((double)(this.IMAGE_WIDTH * 2) * (Math.sqrt(2.0) - 1.0) / 3.0);
        int iw = this.IMAGE_WIDTH;
        this.toastPath.reset();
        this.toastPath.moveTo(leftMargin + (float)(th / 2), 0.0f);
        this.toastPath.rLineTo(ws * (float)(this.IMAGE_WIDTH + this.MAX_TEXT_WIDTH), 0.0f);
        this.toastPath.rCubicTo((float)circleOffset, 0.0f, (float)(th / 2), (float)(th / 2 - circleOffset), (float)(th / 2), (float)(th / 2));
        this.toastPath.rLineTo((float)(-pd), 0.0f);
        this.toastPath.rCubicTo(0.0f, (float)(-iconoffset), (float)(-iw / 2 + iconoffset), (float)(-iw / 2), (float)(-iw / 2), (float)(-iw / 2));
        this.toastPath.rCubicTo((float)(-iconoffset), 0.0f, (float)(-iw / 2), (float)(iw / 2 - iconoffset), (float)(-iw / 2), (float)(iw / 2));
        this.toastPath.rCubicTo(0.0f, (float)iconoffset, (float)(iw / 2 - iconoffset), (float)(iw / 2), (float)(iw / 2), (float)(iw / 2));
        this.toastPath.rCubicTo((float)iconoffset, 0.0f, (float)(iw / 2), (float)(-iw / 2 + iconoffset), (float)(iw / 2), (float)(-iw / 2));
        this.toastPath.rLineTo((float)pd, 0.0f);
        this.toastPath.rCubicTo(0.0f, (float)circleOffset, (float)(circleOffset - th / 2), (float)(th / 2), (float)(-th / 2), (float)(th / 2));
        this.toastPath.rLineTo(ws * (float)(-this.IMAGE_WIDTH - this.MAX_TEXT_WIDTH), 0.0f);
        this.toastPath.rCubicTo((float)(-circleOffset), 0.0f, (float)(-th / 2), (float)(-th / 2 + circleOffset), (float)(-th / 2), (float)(-th / 2));
        this.toastPath.rCubicTo(0.0f, (float)(-circleOffset), (float)(-circleOffset + th / 2), (float)(-th / 2), (float)(th / 2), (float)(-th / 2));
        c.drawCircle(this.spinnerRect.centerX(), this.spinnerRect.centerY(), (float)this.iconBounds.height() / 1.9f, this.backPaint);
        c.drawPath(this.toastPath, this.backPaint);
        int yPos = (int)((float)(th / 2) - (this.textPaint.descent() + this.textPaint.ascent()) / 2.0f);
        c.drawText(this.mText, 0, this.mText.length(), (float)(th / 2 + (this.MAX_TEXT_WIDTH - this.mTextBounds.width()) / 2), (float)yPos, this.textPaint);
        float prog = this.va.getAnimatedFraction() * 6.0f;
        float progrot = prog % 2.0f;
        float proglength = this.easeinterpol.getInterpolation(prog % 3.0f / 3.0f) * 3.0f - 0.75f;
        if (proglength > 0.75f) {
            proglength = 0.75f - (prog % 3.0f - 1.5f);
            progrot += (prog % 3.0f - 1.5f) / 1.5f * 2.0f;
        }
        this.toastPath.reset();
        this.toastPath.arcTo(this.spinnerRect, 180.0f * progrot, Math.min(266.66666f * proglength + 1.0f + 560.0f * (1.0f - ws), 359.9999f));
        this.loaderPaint.setAlpha((int)(255.0f * ws));
        c.drawPath(this.toastPath, this.loaderPaint);
        if (this.WIDTH_SCALE > 1.0f) {
            Drawable icon = this.success ? this.completeicon : this.failedicon;
            float circleProg = this.WIDTH_SCALE - 1.0f;
            this.textPaint.setAlpha((int)(128.0f * circleProg + 127.0f));
            int paddingicon = (int)((1.0f - (0.25f + 0.75f * circleProg)) * (float)this.TOAST_HEIGHT / 2.0f);
            int completeoff = (int)((1.0f - circleProg) * (float)this.TOAST_HEIGHT / 8.0f);
            icon.setBounds((int)this.spinnerRect.left + paddingicon, (int)this.spinnerRect.top + paddingicon + completeoff, (int)this.spinnerRect.right - paddingicon, (int)this.spinnerRect.bottom - paddingicon + completeoff);
            c.drawCircle(leftMargin + (float)(this.TOAST_HEIGHT / 2), (1.0f - circleProg) * (float)this.TOAST_HEIGHT / 8.0f + (float)(this.TOAST_HEIGHT / 2), (0.25f + 0.75f * circleProg) * (float)this.TOAST_HEIGHT / 2.0f, this.success ? this.successPaint : this.errorPaint);
            c.save();
            c.rotate(90.0f * (1.0f - circleProg), leftMargin + (float)(this.TOAST_HEIGHT / 2), (float)(this.TOAST_HEIGHT / 2));
            icon.draw(c);
            c.restore();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(this.measureWidth(widthMeasureSpec), this.measureHeight(heightMeasureSpec));
    }

    private int measureWidth(int measureSpec) {
        int result = 0;
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        if (specMode == 0x40000000) {
            result = specSize;
        } else {
            result = this.IMAGE_WIDTH + this.MAX_TEXT_WIDTH + this.TOAST_HEIGHT;
            if (specMode == Integer.MIN_VALUE) {
                result = Math.min(result, specSize);
            }
        }
        return result;
    }

    private int measureHeight(int measureSpec) {
        int result = 0;
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        if (specMode == 0x40000000) {
            result = specSize;
        } else {
            result = this.TOAST_HEIGHT;
            if (specMode == Integer.MIN_VALUE) {
                result = Math.min(result, specSize);
            }
        }
        return result;
    }
}

