/*
 * Decompiled with CFR 0.152.
 */
package net.steamcrafted.loadtoast;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import com.nineoldandroids.view.ViewHelper;
import com.nineoldandroids.view.ViewPropertyAnimator;
import net.steamcrafted.loadtoast.LoadToastView;

public class LoadToast {
    private String mText = "";
    private LoadToastView mView;
    private int mTranslationY = 0;
    private boolean mShowCalled = false;
    private boolean mInflated = false;

    public LoadToast(Context context) {
        this.mView = new LoadToastView(context);
        final ViewGroup vg = (ViewGroup)((Activity)context).getWindow().getDecorView().findViewById(0x1020002);
        vg.addView((View)this.mView, new ViewGroup.LayoutParams(-2, -2));
        ViewHelper.setAlpha((View)this.mView, (float)0.0f);
        vg.postDelayed(new Runnable(){

            @Override
            public void run() {
                ViewHelper.setTranslationX((View)LoadToast.this.mView, (float)((vg.getWidth() - LoadToast.this.mView.getWidth()) / 2));
                ViewHelper.setTranslationY((View)LoadToast.this.mView, (float)(-LoadToast.this.mView.getHeight() + LoadToast.this.mTranslationY));
                LoadToast.this.mInflated = true;
                if (LoadToast.this.mShowCalled) {
                    LoadToast.this.show();
                }
            }
        }, 1L);
    }

    public LoadToast setTranslationY(int pixels) {
        this.mTranslationY = pixels;
        return this;
    }

    public LoadToast setText(String message) {
        this.mText = message;
        this.mView.setText(this.mText);
        return this;
    }

    public LoadToast setTextColor(int color2) {
        this.mView.setTextColor(color2);
        return this;
    }

    public LoadToast setBackgroundColor(int color2) {
        this.mView.setBackgroundColor(color2);
        return this;
    }

    public LoadToast setProgressColor(int color2) {
        this.mView.setProgressColor(color2);
        return this;
    }

    public LoadToast show() {
        if (!this.mInflated) {
            this.mShowCalled = true;
            return this;
        }
        this.mView.show();
        ViewHelper.setAlpha((View)this.mView, (float)0.0f);
        ViewHelper.setTranslationY((View)this.mView, (float)(-this.mView.getHeight() + this.mTranslationY));
        ViewPropertyAnimator.animate((View)this.mView).alpha(1.0f).translationY((float)(25 + this.mTranslationY)).setInterpolator((Interpolator)new DecelerateInterpolator()).setDuration(300L).setStartDelay(0L).start();
        return this;
    }

    public void success() {
        this.mView.success();
        this.slideUp();
    }

    public void error() {
        this.mView.error();
        this.slideUp();
    }

    private void slideUp() {
        ViewPropertyAnimator.animate((View)this.mView).setStartDelay(1000L).alpha(0.0f).translationY((float)(-this.mView.getHeight() + this.mTranslationY)).setInterpolator((Interpolator)new AccelerateInterpolator()).setDuration(300L).start();
    }
}

