/*
 * Decompiled with CFR 0.152.
 */
package net.steamcrafted.loadtoast;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import com.nineoldandroids.view.ViewHelper;
import com.nineoldandroids.view.ViewPropertyAnimator;
import net.steamcrafted.loadtoast.LoadToastView;

public class LoadToast {
    private String mText = "";
    private LoadToastView mView;
    private ViewGroup mParentView;
    private int mTranslationY = 0;
    private boolean mShowCalled = false;
    private boolean mToastCanceled = false;
    private boolean mInflated = false;
    private boolean mVisible = false;

    public LoadToast(Context context) {
        this.mView = new LoadToastView(context);
        this.mParentView = (ViewGroup)((Activity)context).getWindow().getDecorView().findViewById(0x1020002);
        this.mParentView.addView((View)this.mView, new ViewGroup.LayoutParams(-2, -2));
        ViewHelper.setAlpha((View)this.mView, (float)0.0f);
        this.mParentView.postDelayed(new Runnable(){

            @Override
            public void run() {
                ViewHelper.setTranslationX((View)LoadToast.this.mView, (float)((LoadToast.this.mParentView.getWidth() - LoadToast.this.mView.getWidth()) / 2));
                ViewHelper.setTranslationY((View)LoadToast.this.mView, (float)(-LoadToast.this.mView.getHeight() + LoadToast.this.mTranslationY));
                LoadToast.this.mInflated = true;
                if (!LoadToast.this.mToastCanceled && LoadToast.this.mShowCalled) {
                    LoadToast.this.show();
                }
            }
        }, 1L);
        this.mParentView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                LoadToast.this.checkZPosition();
            }
        });
    }

    public LoadToast setTranslationY(int pixels) {
        this.mTranslationY = pixels;
        return this;
    }

    public LoadToast setText(String message) {
        this.mText = message;
        this.mView.setText(this.mText);
        return this;
    }

    public LoadToast setTextColor(int color2) {
        this.mView.setTextColor(color2);
        return this;
    }

    public LoadToast setBackgroundColor(int color2) {
        this.mView.setBackgroundColor(color2);
        return this;
    }

    public LoadToast setProgressColor(int color2) {
        this.mView.setProgressColor(color2);
        return this;
    }

    public LoadToast show() {
        if (!this.mInflated) {
            this.mShowCalled = true;
            return this;
        }
        this.mView.show();
        ViewHelper.setTranslationX((View)this.mView, (float)((this.mParentView.getWidth() - this.mView.getWidth()) / 2));
        ViewHelper.setAlpha((View)this.mView, (float)0.0f);
        ViewHelper.setTranslationY((View)this.mView, (float)(-this.mView.getHeight() + this.mTranslationY));
        ViewPropertyAnimator.animate((View)this.mView).alpha(1.0f).translationY((float)(25 + this.mTranslationY)).setInterpolator((Interpolator)new DecelerateInterpolator()).setDuration(300L).setStartDelay(0L).start();
        this.mVisible = true;
        this.checkZPosition();
        return this;
    }

    public void success() {
        if (!this.mInflated) {
            this.mToastCanceled = true;
            return;
        }
        this.mView.success();
        this.slideUp();
    }

    public void error() {
        if (!this.mInflated) {
            this.mToastCanceled = true;
            return;
        }
        this.mView.error();
        this.slideUp();
    }

    private void checkZPosition() {
        int count;
        if (!this.mVisible) {
            return;
        }
        int pos = this.mParentView.indexOfChild((View)this.mView);
        if (pos != (count = this.mParentView.getChildCount()) - 1) {
            ((ViewGroup)this.mView.getParent()).removeView((View)this.mView);
            this.mParentView.requestLayout();
            this.mParentView.addView((View)this.mView, new ViewGroup.LayoutParams(-2, -2));
        }
    }

    private void slideUp() {
        ViewPropertyAnimator.animate((View)this.mView).setStartDelay(1000L).alpha(0.0f).translationY((float)(-this.mView.getHeight() + this.mTranslationY)).setInterpolator((Interpolator)new AccelerateInterpolator()).setDuration(300L).start();
        this.mVisible = false;
    }
}

