/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.vbucket.config;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.spy.memcached.vbucket.ConfigurationException;
import net.spy.memcached.vbucket.config.Bucket;

public class Pool {
    private final String name;
    private final URI uri;
    private final URI streamingUri;
    private URI bucketsUri;
    private final AtomicReference<Map<String, Bucket>> currentBuckets = new AtomicReference();

    public Pool(String name, URI uri, URI streamingUri) {
        this.name = name;
        this.uri = uri;
        this.streamingUri = streamingUri;
    }

    public String getName() {
        return this.name;
    }

    public URI getUri() {
        return this.uri;
    }

    public URI getStreamingUri() {
        return this.streamingUri;
    }

    private AtomicReference<Map<String, Bucket>> getCurrentBuckets() {
        if (this.currentBuckets == null) {
            throw new ConfigurationException("Buckets were never populated.");
        }
        return this.currentBuckets;
    }

    public Map<String, Bucket> getROBuckets() {
        return Collections.unmodifiableMap(this.currentBuckets.get());
    }

    public URI getBucketsUri() {
        return this.bucketsUri;
    }

    void setBucketsUri(URI newBucketsUri) {
        this.bucketsUri = newBucketsUri;
    }

    public void replaceBuckets(Map<String, Bucket> replacingMap) {
        HashMap<String, Bucket> swapMap = new HashMap<String, Bucket>(replacingMap);
        this.currentBuckets.set(swapMap);
    }

    public boolean hasBucket(String bucketName) {
        boolean bucketFound = false;
        if (this.getCurrentBuckets().get().containsKey(bucketName)) {
            bucketFound = true;
        }
        return bucketFound;
    }
}

