/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.vbucket.config;

import java.util.List;
import net.spy.memcached.HashAlgorithm;
import net.spy.memcached.vbucket.config.Config;
import net.spy.memcached.vbucket.config.ConfigDifference;
import net.spy.memcached.vbucket.config.ConfigType;
import net.spy.memcached.vbucket.config.VBucket;

public class DefaultConfig
implements Config {
    private final HashAlgorithm hashAlgorithm;
    private final int vbucketsCount;
    private final int mask;
    private final int serversCount;
    private final int replicasCount;
    private final List<String> servers;
    private final List<VBucket> vbuckets;

    public DefaultConfig(HashAlgorithm hashAlgorithm, int serversCount, int replicasCount, int vbucketsCount, List<String> servers, List<VBucket> vbuckets) {
        this.hashAlgorithm = hashAlgorithm;
        this.serversCount = serversCount;
        this.replicasCount = replicasCount;
        this.vbucketsCount = vbucketsCount;
        this.mask = vbucketsCount - 1;
        this.servers = servers;
        this.vbuckets = vbuckets;
    }

    @Override
    public int getReplicasCount() {
        return this.replicasCount;
    }

    @Override
    public int getVbucketsCount() {
        return this.vbucketsCount;
    }

    @Override
    public int getServersCount() {
        return this.serversCount;
    }

    @Override
    public String getServer(int serverIndex) {
        return this.servers.get(serverIndex);
    }

    @Override
    public int getVbucketByKey(String key) {
        int digest = (int)this.hashAlgorithm.hash(key);
        return digest & this.mask;
    }

    @Override
    public int getMaster(int vbucketIndex) {
        return this.vbuckets.get(vbucketIndex).getMaster();
    }

    @Override
    public int getReplica(int vbucketIndex, int replicaIndex) {
        return this.vbuckets.get(vbucketIndex).getReplica(replicaIndex);
    }

    @Override
    public int foundIncorrectMaster(int vbucket, int wrongServer) {
        int mappedServer;
        int rv = mappedServer = this.vbuckets.get(vbucket).getMaster();
        if (mappedServer == wrongServer) {
            rv = (rv + 1) % this.serversCount;
            this.vbuckets.get(vbucket).setMaster(rv);
        }
        return rv;
    }

    @Override
    public List<String> getServers() {
        return this.servers;
    }

    @Override
    public List<VBucket> getVbuckets() {
        return this.vbuckets;
    }

    @Override
    public ConfigDifference compareTo(Config config) {
        ConfigDifference difference = new ConfigDifference();
        if (this.serversCount == config.getServersCount()) {
            difference.setSequenceChanged(false);
            for (int i = 0; i < this.serversCount; ++i) {
                if (this.getServer(i).equals(config.getServer(i))) continue;
                difference.setSequenceChanged(true);
                break;
            }
        } else {
            difference.setSequenceChanged(true);
        }
        if (this.vbucketsCount == config.getVbucketsCount()) {
            int vbucketsChanges = 0;
            for (int i = 0; i < this.vbucketsCount; ++i) {
                vbucketsChanges += this.getMaster(i) == config.getMaster(i) ? 0 : 1;
            }
            difference.setVbucketsChanges(vbucketsChanges);
        } else {
            difference.setVbucketsChanges(-1);
        }
        return difference;
    }

    @Override
    public HashAlgorithm getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    @Override
    public ConfigType getConfigType() {
        return ConfigType.MEMBASE;
    }
}

