/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.vbucket;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.NodeLocator;
import net.spy.memcached.compat.SpyObject;
import net.spy.memcached.vbucket.config.Config;
import net.spy.memcached.vbucket.config.ConfigDifference;

public class VBucketNodeLocator
extends SpyObject
implements NodeLocator {
    private final AtomicReference<TotalConfig> fullConfig = new AtomicReference();

    public VBucketNodeLocator(List<MemcachedNode> nodes, Config jsonConfig) {
        this.fullConfig.set(new TotalConfig(jsonConfig, this.fillNodesEntries(nodes)));
    }

    @Override
    public MemcachedNode getPrimary(String k) {
        int vbucket;
        int serverNumber;
        String server;
        TotalConfig totConfig = this.fullConfig.get();
        Config config = totConfig.getConfig();
        Map<String, MemcachedNode> nodesMap = totConfig.getNodesMap();
        MemcachedNode pNode = nodesMap.get(server = config.getServer(serverNumber = config.getMaster(vbucket = config.getVbucketByKey(k))));
        if (pNode == null) {
            this.getLogger().error("The node locator does not have a primary for key %s.  Wanted vbucket %s which should be on server %s.", k, vbucket, server);
            this.getLogger().error("List of nodes has %s entries:", nodesMap.size());
            Set<String> keySet = nodesMap.keySet();
            for (String anode : keySet) {
                this.getLogger().error("MemcachedNode for %s is %s", anode, nodesMap.get(anode));
            }
            Collection<MemcachedNode> nodes = nodesMap.values();
            for (MemcachedNode node : nodes) {
                this.getLogger().error(node);
            }
        }
        assert (pNode != null);
        return pNode;
    }

    @Override
    public Iterator<MemcachedNode> getSequence(String k) {
        return new NullIterator();
    }

    @Override
    public Collection<MemcachedNode> getAll() {
        Map<String, MemcachedNode> nodesMap = this.fullConfig.get().getNodesMap();
        return nodesMap.values();
    }

    @Override
    public NodeLocator getReadonlyCopy() {
        return this;
    }

    @Override
    public void updateLocator(List<MemcachedNode> nodes, Config newconf) {
        Config current = this.fullConfig.get().getConfig();
        ConfigDifference compareTo = current.compareTo(newconf);
        if (compareTo.isSequenceChanged() || compareTo.getVbucketsChanges() > 0) {
            this.getLogger().debug("Updating configuration, received updated configuration with significant changes.");
            this.fullConfig.set(new TotalConfig(newconf, this.fillNodesEntries(nodes)));
        } else {
            this.getLogger().debug("Received updated configuration with insignificant changes.");
        }
    }

    public int getVBucketIndex(String key) {
        Config config = this.fullConfig.get().getConfig();
        return config.getVbucketByKey(key);
    }

    private Map<String, MemcachedNode> fillNodesEntries(Collection<MemcachedNode> nodes) {
        HashMap<String, MemcachedNode> vbnodesMap = new HashMap<String, MemcachedNode>();
        this.getLogger().debug("Updating nodesMap in VBucketNodeLocator.");
        for (MemcachedNode node : nodes) {
            InetSocketAddress addr = (InetSocketAddress)node.getSocketAddress();
            String address = addr.getAddress().getHostName() + ":" + addr.getPort();
            String hostname = addr.getAddress().getHostAddress() + ":" + addr.getPort();
            this.getLogger().debug("Adding node with hostname %s and address %s.", hostname, address);
            this.getLogger().debug("Node added is %s.", node);
            vbnodesMap.put(address, node);
            vbnodesMap.put(hostname, node);
        }
        return Collections.unmodifiableMap(vbnodesMap);
    }

    public MemcachedNode getAlternative(String k, Collection<MemcachedNode> notMyVbucketNodes) {
        HashMap<String, MemcachedNode> nodesMap = new HashMap<String, MemcachedNode>(this.fullConfig.get().getNodesMap());
        Collection nodes = nodesMap.values();
        nodes.removeAll(notMyVbucketNodes);
        if (nodes.isEmpty()) {
            return null;
        }
        return (MemcachedNode)nodes.iterator().next();
    }

    class NullIterator<E>
    implements Iterator<MemcachedNode> {
        NullIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public MemcachedNode next() {
            throw new NoSuchElementException("VBucketNodeLocators have no alternate nodes.");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("VBucketNodeLocators have no alternate nodes; cannot remove.");
        }
    }

    private class TotalConfig {
        private Config config;
        private Map<String, MemcachedNode> nodesMap;

        public TotalConfig(Config newConfig, Map<String, MemcachedNode> newMap) {
            this.config = newConfig;
            this.nodesMap = Collections.unmodifiableMap(newMap);
        }

        protected Config getConfig() {
            return this.config;
        }

        protected Map<String, MemcachedNode> getNodesMap() {
            return this.nodesMap;
        }
    }
}

