/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.internal;

import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import net.spy.memcached.OperationTimeoutException;
import net.spy.memcached.internal.BulkFuture;
import net.spy.memcached.internal.HttpFuture;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.protocol.couch.ViewResponse;
import net.spy.memcached.protocol.couch.ViewResponseWithDocs;
import net.spy.memcached.protocol.couch.ViewRow;
import net.spy.memcached.protocol.couch.ViewRowWithDocs;

public class ViewFuture
extends HttpFuture<ViewResponse> {
    private final AtomicReference<BulkFuture<Map<String, Object>>> multigetRef = new AtomicReference<Object>(null);

    public ViewFuture(CountDownLatch latch, long timeout) {
        super(latch, timeout);
    }

    @Override
    public ViewResponse get(long duration, TimeUnit units) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.latch.await(duration, units)) {
            if (this.op != null) {
                this.op.timeOut();
            }
            this.status = new OperationStatus(false, "Timed out");
            throw new TimeoutException("Timed out waiting for operation");
        }
        if (this.op != null && this.op.hasErrored()) {
            this.status = new OperationStatus(false, this.op.getException().getMessage());
            throw new ExecutionException(this.op.getException());
        }
        if (this.op.isCancelled()) {
            this.status = new OperationStatus(false, "Operation Cancelled");
            throw new ExecutionException(new RuntimeException("Cancelled"));
        }
        if (this.op != null && this.op.isTimedOut()) {
            this.status = new OperationStatus(false, "Timed out");
            throw new ExecutionException(new OperationTimeoutException("Operation timed out."));
        }
        if (this.multigetRef.get() == null) {
            return null;
        }
        Map docMap = (Map)this.multigetRef.get().get();
        ViewResponseWithDocs view = (ViewResponseWithDocs)this.objRef.get();
        LinkedList<ViewRow> rows = new LinkedList<ViewRow>();
        for (ViewRow r : view) {
            rows.add(new ViewRowWithDocs(r.getId(), r.getKey(), r.getValue(), docMap.get(r.getId())));
        }
        return new ViewResponseWithDocs(rows, view.getErrors());
    }

    public void set(ViewResponse viewResponse, BulkFuture<Map<String, Object>> oper, OperationStatus s) {
        this.objRef.set(viewResponse);
        this.multigetRef.set(oper);
        this.status = s;
    }
}

