/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.compat.SpyObject;
import net.spy.memcached.couch.AsyncConnectionManager;
import net.spy.memcached.couch.AsyncConnectionRequest;
import net.spy.memcached.couch.RequestHandle;
import net.spy.memcached.protocol.couch.HttpOperation;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.entity.BufferingNHttpEntity;
import org.apache.http.nio.entity.ConsumingNHttpEntity;
import org.apache.http.nio.protocol.EventListener;
import org.apache.http.nio.protocol.NHttpRequestExecutionHandler;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.HeapByteBufferAllocator;
import org.apache.http.protocol.HttpContext;

public class CouchbaseNode
extends SpyObject {
    private final InetSocketAddress addr;
    private final AsyncConnectionManager connMgr;
    private final long opQueueMaxBlockTime;
    private final long defaultOpTimeout;
    private final BlockingQueue<HttpOperation> writeQ;

    public CouchbaseNode(InetSocketAddress a, AsyncConnectionManager mgr, LinkedBlockingQueue<HttpOperation> linkedBlockingQueue, long maxBlockTime, long operationTimeout) {
        this.addr = a;
        this.connMgr = mgr;
        this.writeQ = linkedBlockingQueue;
        this.opQueueMaxBlockTime = maxBlockTime;
        this.defaultOpTimeout = operationTimeout;
    }

    public void init() throws IOReactorException {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    CouchbaseNode.this.connMgr.execute();
                }
                catch (InterruptedIOException ex) {
                    CouchbaseNode.this.getLogger().error("I/O reactor Interrupted");
                }
                catch (IOException e) {
                    CouchbaseNode.this.getLogger().error("I/O error: " + e.getMessage());
                    e.printStackTrace();
                }
                CouchbaseNode.this.getLogger().info("Couchbase I/O reactor terminated");
            }
        });
        t.start();
    }

    public void doWrites() {
        HttpOperation op;
        while ((op = (HttpOperation)this.writeQ.poll()) != null) {
            if (op.isTimedOut() || op.isCancelled()) continue;
            AsyncConnectionRequest connRequest = this.connMgr.requestConnection();
            try {
                connRequest.waitFor();
            }
            catch (InterruptedException e) {
                this.getLogger().warn("Interrupted while trying to get a connection. Cancelling op");
                op.cancel();
                return;
            }
            NHttpClientConnection conn = connRequest.getConnection();
            if (conn == null) {
                this.getLogger().error("Failed to obtain connection. Cancelling op");
                op.cancel();
                continue;
            }
            HttpContext context = conn.getContext();
            RequestHandle handle = new RequestHandle(this.connMgr, conn);
            context.setAttribute("request-handle", (Object)handle);
            context.setAttribute("operation", (Object)op);
            conn.requestOutput();
        }
    }

    public Collection<HttpOperation> destroyWriteQueue() {
        ArrayList<HttpOperation> rv = new ArrayList<HttpOperation>();
        this.writeQ.drainTo(rv);
        return rv;
    }

    public boolean hasWriteOps() {
        return !this.writeQ.isEmpty();
    }

    public void addOp(HttpOperation op) {
        try {
            if (!this.writeQ.offer(op, this.opQueueMaxBlockTime, TimeUnit.MILLISECONDS)) {
                throw new IllegalStateException("Timed out waiting to add " + op + "(max wait=" + this.opQueueMaxBlockTime + "ms)");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted while waiting to add " + op);
        }
    }

    public InetSocketAddress getSocketAddress() {
        return this.addr;
    }

    public void shutdown() throws IOException {
        this.shutdown(0L, TimeUnit.MILLISECONDS);
    }

    public void shutdown(long time, TimeUnit unit) throws IOException {
        if (unit != TimeUnit.MILLISECONDS) {
            this.connMgr.shutdown(TimeUnit.MILLISECONDS.convert(time, unit));
        } else {
            this.connMgr.shutdown(time);
        }
    }

    static class EventLogger
    extends SpyObject
    implements EventListener {
        EventLogger() {
        }

        public void connectionOpen(NHttpConnection conn) {
            this.getLogger().debug("Connection open: " + conn);
        }

        public void connectionTimeout(NHttpConnection conn) {
            this.getLogger().error("Connection timed out: " + conn);
        }

        public void connectionClosed(NHttpConnection conn) {
            this.getLogger().debug("Connection closed: " + conn);
        }

        public void fatalIOException(IOException ex, NHttpConnection conn) {
            this.getLogger().error("I/O error: " + ex.getMessage());
        }

        public void fatalProtocolException(HttpException ex, NHttpConnection conn) {
            this.getLogger().error("HTTP error: " + ex.getMessage());
        }
    }

    static class MyHttpRequestExecutionHandler
    implements NHttpRequestExecutionHandler {
        public void initalizeContext(HttpContext context, Object attachment) {
        }

        public void finalizeContext(HttpContext context) {
            RequestHandle handle = (RequestHandle)context.removeAttribute("request-handle");
            if (handle != null) {
                handle.cancel();
            }
        }

        public HttpRequest submitRequest(HttpContext context) {
            HttpOperation op = (HttpOperation)context.getAttribute("operation");
            if (op == null) {
                return null;
            }
            return op.getRequest();
        }

        public void handleResponse(HttpResponse response, HttpContext context) {
            RequestHandle handle = (RequestHandle)context.removeAttribute("request-handle");
            HttpOperation op = (HttpOperation)context.removeAttribute("operation");
            if (handle != null) {
                handle.completed();
                op.handleResponse(response);
            }
        }

        public ConsumingNHttpEntity responseEntity(HttpResponse response, HttpContext context) throws IOException {
            return new BufferingNHttpEntity(response.getEntity(), (ByteBufferAllocator)new HeapByteBufferAllocator());
        }
    }
}

