/*
 * Decompiled with CFR 0.152.
 */
package net.sf.swarmcache;

import java.io.Serializable;
import net.sf.swarmcache.AutoCache;
import net.sf.swarmcache.LRUCache;
import net.sf.swarmcache.LRUCacheListener;
import net.sf.swarmcache.ObjectCache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HybridCache
implements ObjectCache,
LRUCacheListener {
    Log log = LogFactory.getLog(this.getClass());
    private String type;
    private LRUCache lruCache = new LRUCache();
    private AutoCache autoCache = new AutoCache();

    public HybridCache() {
        this.lruCache.setListener(this);
    }

    public void setSize(int newSize) {
        this.lruCache.setSize(newSize);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.log.debug((Object)("Cache type set to '" + type + "'."));
        this.type = type;
        this.lruCache.setType(type);
        this.autoCache.setType(type);
    }

    public void objectRemoved(Serializable key, Object value) {
        this.autoCache.put(key, value);
        this.log.debug((Object)("Moved " + this.type + " #" + key + " to the auto cache."));
    }

    public void put(Serializable key, Object object) {
        this.lruCache.put(key, object);
        this.log.debug((Object)("Put " + this.type + " #" + key + " in to cache."));
    }

    public Object get(Serializable key) {
        Object object = this.lruCache.get(key);
        if (object != null) {
            this.log.debug((Object)("Got " + this.type + " #" + key + " from LRU cache."));
        } else {
            object = this.autoCache.get(key);
            if (object != null) {
                this.log.debug((Object)("Got " + this.type + " #" + key + " from auto cache."));
                this.lruCache.put(key, object);
                this.autoCache.clear(key);
            }
        }
        return object;
    }

    public Object clear(Serializable key) {
        this.log.debug((Object)("Cleared " + this.type + " #" + key + " from cache."));
        Object o = this.lruCache.clear(key);
        if (o != null) {
            return o;
        }
        o = this.autoCache.clear(key);
        return o;
    }

    public void clearAll() {
        this.log.debug((Object)("Cleared entire " + this.type + " cache."));
        this.lruCache.clearAll();
        this.autoCache.clearAll();
    }
}

