/*
 * Decompiled with CFR 0.152.
 */
package java9.util.stream;

import java.util.Collection;
import java9.util.Objects;
import java9.util.Spliterator;
import java9.util.Spliterators;
import java9.util.function.Supplier;
import java9.util.stream.BaseStream;
import java9.util.stream.DoublePipeline;
import java9.util.stream.DoubleStream;
import java9.util.stream.IntPipeline;
import java9.util.stream.IntStream;
import java9.util.stream.LongPipeline;
import java9.util.stream.LongStream;
import java9.util.stream.ReferencePipeline;
import java9.util.stream.Stream;
import java9.util.stream.StreamOpFlag;

public final class StreamSupport {
    private StreamSupport() {
    }

    public static <T> Stream<T> stream(Collection<? extends T> c) {
        return StreamSupport.stream(Spliterators.spliterator(c), false);
    }

    public static <T> Stream<T> parallelStream(Collection<? extends T> c) {
        return StreamSupport.stream(Spliterators.spliterator(c), true);
    }

    public static <T> Stream<T> stream(Collection<? extends T> c, int characteristics) {
        return StreamSupport.stream(c, characteristics, false);
    }

    public static <T> Stream<T> stream(Collection<? extends T> c, int characteristics, boolean parallel) {
        Objects.requireNonNull(c);
        return StreamSupport.stream(Spliterators.spliterator(c, characteristics), parallel);
    }

    public static <T> Stream<T> stream(Spliterator<T> spliterator, boolean parallel) {
        Objects.requireNonNull(spliterator);
        return new ReferencePipeline.Head(spliterator, StreamOpFlag.fromCharacteristics(spliterator), parallel);
    }

    public static <T> Stream<T> stream(Supplier<? extends Spliterator<T>> supplier, int characteristics, boolean parallel) {
        Objects.requireNonNull(supplier);
        return new ReferencePipeline.Head(supplier, StreamOpFlag.fromCharacteristics(characteristics), parallel);
    }

    public static IntStream intStream(Spliterator.OfInt spliterator, boolean parallel) {
        return new IntPipeline.Head(spliterator, StreamOpFlag.fromCharacteristics(spliterator), parallel);
    }

    public static IntStream intStream(Supplier<? extends Spliterator.OfInt> supplier, int characteristics, boolean parallel) {
        return new IntPipeline.Head((Supplier<? extends Spliterator<Integer>>)((Supplier<Spliterator<Integer>>)supplier), StreamOpFlag.fromCharacteristics(characteristics), parallel);
    }

    public static LongStream longStream(Spliterator.OfLong spliterator, boolean parallel) {
        return new LongPipeline.Head(spliterator, StreamOpFlag.fromCharacteristics(spliterator), parallel);
    }

    public static LongStream longStream(Supplier<? extends Spliterator.OfLong> supplier, int characteristics, boolean parallel) {
        return new LongPipeline.Head((Supplier<? extends Spliterator<Long>>)((Supplier<Spliterator<Long>>)supplier), StreamOpFlag.fromCharacteristics(characteristics), parallel);
    }

    public static DoubleStream doubleStream(Spliterator.OfDouble spliterator, boolean parallel) {
        return new DoublePipeline.Head(spliterator, StreamOpFlag.fromCharacteristics(spliterator), parallel);
    }

    public static DoubleStream doubleStream(Supplier<? extends Spliterator.OfDouble> supplier, int characteristics, boolean parallel) {
        return new DoublePipeline.Head((Supplier<? extends Spliterator<Double>>)((Supplier<Spliterator<Double>>)supplier), StreamOpFlag.fromCharacteristics(characteristics), parallel);
    }

    static Runnable closeHandler(BaseStream<?, ?> stream) {
        return stream::close;
    }
}

