/*
 * Decompiled with CFR 0.152.
 */
package java9.util;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java9.lang.Integers;
import java9.lang.Longs;
import java9.util.Objects;
import java9.util.function.Function;
import java9.util.function.ToDoubleFunction;
import java9.util.function.ToIntFunction;
import java9.util.function.ToLongFunction;

public final class Comparators {
    public static <T extends Comparable<? super T>> Comparator<T> reverseOrder() {
        return Collections.reverseOrder();
    }

    public static <T extends Comparable<? super T>> Comparator<T> naturalOrder() {
        return NaturalOrderComparator.INSTANCE;
    }

    public static <T, U> Comparator<T> comparing(Function<? super T, ? extends U> keyExtractor, Comparator<? super U> keyComparator) {
        Objects.requireNonNull(keyExtractor);
        Objects.requireNonNull(keyComparator);
        return (Comparator & Serializable)(c1, c2) -> keyComparator.compare((Object)keyExtractor.apply(c1), (Object)keyExtractor.apply(c2));
    }

    public static <T, U extends Comparable<? super U>> Comparator<T> comparing(Function<? super T, ? extends U> keyExtractor) {
        Objects.requireNonNull(keyExtractor);
        return (Comparator & Serializable)(c1, c2) -> ((Comparable)keyExtractor.apply(c1)).compareTo(keyExtractor.apply(c2));
    }

    public static <T> Comparator<T> comparingInt(ToIntFunction<? super T> keyExtractor) {
        Objects.requireNonNull(keyExtractor);
        return (Comparator & Serializable)(c1, c2) -> Integers.compare(keyExtractor.applyAsInt(c1), keyExtractor.applyAsInt(c2));
    }

    public static <T> Comparator<T> comparingLong(ToLongFunction<? super T> keyExtractor) {
        Objects.requireNonNull(keyExtractor);
        return (Comparator & Serializable)(c1, c2) -> Longs.compare(keyExtractor.applyAsLong(c1), keyExtractor.applyAsLong(c2));
    }

    public static <T> Comparator<T> comparingDouble(ToDoubleFunction<? super T> keyExtractor) {
        Objects.requireNonNull(keyExtractor);
        return (Comparator & Serializable)(c1, c2) -> Double.compare(keyExtractor.applyAsDouble(c1), keyExtractor.applyAsDouble(c2));
    }

    public static <T> Comparator<T> thenComparing(Comparator<? super T> this_, Comparator<? super T> other) {
        Objects.requireNonNull(this_);
        Objects.requireNonNull(other);
        if (this_ instanceof NullComparator) {
            return ((NullComparator)this_).thenComparing(other);
        }
        return (Comparator & Serializable)(c1, c2) -> {
            int res = this_.compare(c1, c2);
            return res != 0 ? res : other.compare(c1, c2);
        };
    }

    public static <T, U> Comparator<T> thenComparing(Comparator<? super T> this_, Function<? super T, ? extends U> keyExtractor, Comparator<? super U> keyComparator) {
        return Comparators.thenComparing(this_, Comparators.comparing(keyExtractor, keyComparator));
    }

    public static <T, U extends Comparable<? super U>> Comparator<T> thenComparing(Comparator<? super T> this_, Function<? super T, ? extends U> keyExtractor) {
        return Comparators.thenComparing(this_, Comparators.comparing(keyExtractor));
    }

    public static <T> Comparator<T> thenComparingInt(Comparator<? super T> this_, ToIntFunction<? super T> keyExtractor) {
        return Comparators.thenComparing(this_, Comparators.comparingInt(keyExtractor));
    }

    public static <T> Comparator<T> thenComparingLong(Comparator<? super T> this_, ToLongFunction<? super T> keyExtractor) {
        return Comparators.thenComparing(this_, Comparators.comparingLong(keyExtractor));
    }

    public static <T> Comparator<T> thenComparingDouble(Comparator<? super T> this_, ToDoubleFunction<? super T> keyExtractor) {
        return Comparators.thenComparing(this_, Comparators.comparingDouble(keyExtractor));
    }

    public static <T> Comparator<T> reversed(Comparator<T> comparator) {
        if (comparator instanceof NullComparator) {
            return ((NullComparator)comparator).reversed();
        }
        return Collections.reverseOrder(comparator);
    }

    public static <T> Comparator<T> nullsFirst(Comparator<? super T> comparator) {
        return new NullComparator<T>(true, comparator);
    }

    public static <T> Comparator<T> nullsLast(Comparator<? super T> comparator) {
        return new NullComparator<T>(false, comparator);
    }

    private Comparators() {
    }

    private static final class NullComparator<T>
    implements Comparator<T>,
    Serializable {
        private static final long serialVersionUID = -7569533591570686392L;
        private final boolean nullFirst;
        private final Comparator<T> real;

        NullComparator(boolean nullFirst, Comparator<? super T> real) {
            this.nullFirst = nullFirst;
            this.real = real;
        }

        @Override
        public int compare(T a, T b) {
            if (a == null) {
                return b == null ? 0 : (this.nullFirst ? -1 : 1);
            }
            if (b == null) {
                return this.nullFirst ? 1 : -1;
            }
            return this.real == null ? 0 : this.real.compare(a, b);
        }

        @Override
        public Comparator<T> thenComparing(Comparator<? super T> other) {
            Objects.requireNonNull(other);
            return new NullComparator<T>(this.nullFirst, this.real == null ? other : Comparators.thenComparing(this.real, other));
        }

        @Override
        public Comparator<T> reversed() {
            return new NullComparator<T>(!this.nullFirst, this.real == null ? null : Collections.reverseOrder(this.real));
        }
    }

    private static enum NaturalOrderComparator implements Comparator<Comparable<Object>>
    {
        INSTANCE;


        @Override
        public int compare(Comparable<Object> c1, Comparable<Object> c2) {
            return c1.compareTo(c2);
        }

        @Override
        public Comparator<Comparable<Object>> reversed() {
            return Comparators.reverseOrder();
        }
    }
}

