/*
 * Decompiled with CFR 0.152.
 */
package java9.util;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java9.util.Objects;
import java9.util.Spliterator;
import java9.util.Spliterators;
import java9.util.UnsafeAccess;
import java9.util.function.Consumer;
import sun.misc.Unsafe;

final class ArrayListSpliterator<E>
implements Spliterator<E> {
    private final ArrayList<E> list;
    private int index;
    private int fence;
    private int expectedModCount;
    private static final Unsafe U = UnsafeAccess.unsafe;
    private static final long SIZE_OFF;
    private static final long MODCOUNT_OFF;
    private static final long DATA_OFF;

    private ArrayListSpliterator(ArrayList<E> list, int origin, int fence, int expectedModCount) {
        this.list = list;
        this.index = origin;
        this.fence = fence;
        this.expectedModCount = expectedModCount;
    }

    static <T> Spliterator<T> spliterator(ArrayList<T> list) {
        return new ArrayListSpliterator<T>(list, 0, -1, 0);
    }

    private int getFence() {
        int hi = this.fence;
        if (hi < 0) {
            ArrayList<E> lst = this.list;
            this.expectedModCount = ArrayListSpliterator.getModCount(lst);
            hi = this.fence = ArrayListSpliterator.getSize(lst);
        }
        return hi;
    }

    @Override
    public ArrayListSpliterator<E> trySplit() {
        ArrayListSpliterator<E> arrayListSpliterator;
        int lo = this.index;
        int hi = this.getFence();
        int mid = lo + hi >>> 1;
        if (lo >= mid) {
            arrayListSpliterator = null;
        } else {
            this.index = mid;
            ArrayListSpliterator<E> arrayListSpliterator2 = new ArrayListSpliterator<E>(this.list, lo, this.index, this.expectedModCount);
            arrayListSpliterator = arrayListSpliterator2;
        }
        return arrayListSpliterator;
    }

    @Override
    public boolean tryAdvance(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        int hi = this.getFence();
        int i = this.index;
        if (i < hi) {
            this.index = i + 1;
            Object e = ArrayListSpliterator.getData(this.list)[i];
            action.accept(e);
            if (this.expectedModCount != ArrayListSpliterator.getModCount(this.list)) {
                throw new ConcurrentModificationException();
            }
            return true;
        }
        return false;
    }

    @Override
    public void forEachRemaining(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        ArrayList<E> lst = this.list;
        Object[] a = ArrayListSpliterator.getData(lst);
        if (a != null) {
            int i;
            int mc;
            int hi = this.fence;
            if (hi < 0) {
                mc = ArrayListSpliterator.getModCount(lst);
                hi = ArrayListSpliterator.getSize(lst);
            } else {
                mc = this.expectedModCount;
            }
            if (i >= 0 && (this.index = hi) <= a.length) {
                for (i = this.index; i < hi; ++i) {
                    Object e = a[i];
                    action.accept(e);
                }
                if (mc == ArrayListSpliterator.getModCount(lst)) {
                    return;
                }
            }
        }
        throw new ConcurrentModificationException();
    }

    @Override
    public long estimateSize() {
        return this.getFence() - this.index;
    }

    @Override
    public int characteristics() {
        return 16464;
    }

    private static <T> int getSize(ArrayList<T> lst) {
        return U.getInt(lst, SIZE_OFF);
    }

    private static <T> int getModCount(ArrayList<T> lst) {
        return U.getInt(lst, MODCOUNT_OFF);
    }

    private static <T> Object[] getData(ArrayList<T> lst) {
        return (Object[])U.getObject(lst, DATA_OFF);
    }

    static {
        try {
            MODCOUNT_OFF = U.objectFieldOffset(AbstractList.class.getDeclaredField("modCount"));
            SIZE_OFF = U.objectFieldOffset(ArrayList.class.getDeclaredField("size"));
            String arrayFieldName = Spliterators.IS_HARMONY_ANDROID ? "array" : "elementData";
            DATA_OFF = U.objectFieldOffset(ArrayList.class.getDeclaredField(arrayFieldName));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }
}

