/*
 * Decompiled with CFR 0.152.
 */
package java9.util.concurrent;

import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java9.util.Objects;
import java9.util.function.BiConsumer;
import java9.util.function.BiFunction;
import java9.util.function.Function;

public final class ConcurrentMaps {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <K, V> V merge(ConcurrentMap<K, V> map, K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        Objects.requireNonNull(map);
        Objects.requireNonNull(remappingFunction);
        Objects.requireNonNull(value);
        block0: while (true) {
            Object oldValue = map.get(key);
            do {
                if (oldValue == null) continue;
                V newValue = remappingFunction.apply(oldValue, value);
                if (newValue != null) {
                    if (!map.replace(key, oldValue, newValue)) continue block0;
                    return newValue;
                }
                if (map.remove(key, oldValue)) return null;
                continue block0;
            } while ((oldValue = map.putIfAbsent(key, value)) != null);
            break;
        }
        return value;
    }

    public static <K, V> V computeIfAbsent(ConcurrentMap<K, V> map, K key, Function<? super K, ? extends V> mappingFunction) {
        V newValue;
        Objects.requireNonNull(map);
        Objects.requireNonNull(mappingFunction);
        Object oldValue = map.get(key);
        return oldValue == null && (newValue = mappingFunction.apply(key)) != null && (oldValue = map.putIfAbsent(key, newValue)) == null ? newValue : oldValue;
    }

    public static <K, V> V computeIfPresent(ConcurrentMap<K, V> map, K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Object oldValue;
        Objects.requireNonNull(map);
        Objects.requireNonNull(remappingFunction);
        while ((oldValue = map.get(key)) != null) {
            V newValue = remappingFunction.apply(key, oldValue);
            if (!(newValue == null ? map.remove(key, oldValue) : map.replace(key, oldValue, newValue))) continue;
            return newValue;
        }
        return null;
    }

    public static <K, V> V compute(ConcurrentMap<K, V> map, K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Objects.requireNonNull(map);
        block0: while (true) {
            V newValue;
            Object oldValue = map.get(key);
            while ((newValue = remappingFunction.apply(key, oldValue)) != null) {
                if (oldValue != null) {
                    if (!map.replace(key, oldValue, newValue)) continue block0;
                    return newValue;
                }
                oldValue = map.putIfAbsent(key, newValue);
                if (oldValue != null) continue;
                return newValue;
            }
            if (oldValue == null || map.remove(key, oldValue)) break;
        }
        return null;
    }

    public static <K, V> void replaceAll(ConcurrentMap<K, V> map, BiFunction<? super K, ? super V, ? extends V> function) {
        Objects.requireNonNull(map);
        Objects.requireNonNull(function);
        ConcurrentMaps.forEach(map, (k, v) -> {
            while (!map.replace(k, v, function.apply((Object)k, (Object)v)) && (v = map.get(k)) != null) {
            }
        });
    }

    public static <K, V> V getOrDefault(ConcurrentMap<K, V> map, Object key, V defaultValue) {
        Objects.requireNonNull(map);
        Object v = map.get(key);
        return v != null ? v : defaultValue;
    }

    public static <K, V> void forEach(ConcurrentMap<K, V> map, BiConsumer<? super K, ? super V> action) {
        Objects.requireNonNull(map);
        Objects.requireNonNull(action);
        for (Map.Entry entry : map.entrySet()) {
            Object v;
            Object k;
            try {
                k = entry.getKey();
                v = entry.getValue();
            }
            catch (IllegalStateException ise) {
                continue;
            }
            action.accept(k, v);
        }
    }

    private ConcurrentMaps() {
    }
}

