/*
 * Decompiled with CFR 0.152.
 */
package java9.util;

import java.util.AbstractList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java9.util.Objects;
import java9.util.Spliterator;
import java9.util.UnsafeAccess;
import java9.util.function.Consumer;
import sun.misc.Unsafe;

final class RASpliterator<E>
implements Spliterator<E> {
    private final List<E> list;
    private int index;
    private int fence;
    private final AbstractList<E> alist;
    private int expectedModCount;
    private static final Unsafe U = UnsafeAccess.unsafe;
    private static final long MODCOUNT_OFF;

    private RASpliterator(List<E> list, int origin, int fence, int expectedModCount) {
        this.list = list;
        this.index = origin;
        this.fence = fence;
        this.alist = list instanceof AbstractList ? (AbstractList)list : null;
        this.expectedModCount = expectedModCount;
    }

    static <T> Spliterator<T> spliterator(List<T> list) {
        return new RASpliterator<T>(list, 0, -1, 0);
    }

    private int getFence() {
        List<E> lst = this.list;
        int hi = this.fence;
        if (hi < 0) {
            if (this.alist != null) {
                this.expectedModCount = RASpliterator.getModCount(this.alist);
            }
            hi = this.fence = lst.size();
        }
        return hi;
    }

    @Override
    public Spliterator<E> trySplit() {
        RASpliterator<E> rASpliterator;
        int lo = this.index;
        int hi = this.getFence();
        int mid = lo + hi >>> 1;
        if (lo >= mid) {
            rASpliterator = null;
        } else {
            this.index = mid;
            RASpliterator<E> rASpliterator2 = new RASpliterator<E>(this.list, lo, this.index, this.expectedModCount);
            rASpliterator = rASpliterator2;
        }
        return rASpliterator;
    }

    @Override
    public boolean tryAdvance(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        int hi = this.getFence();
        int i = this.index;
        if (i < hi) {
            this.index = i + 1;
            action.accept(this.list.get(i));
            RASpliterator.checkAbsListModCount(this.alist, this.expectedModCount);
            return true;
        }
        return false;
    }

    @Override
    public void forEachRemaining(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        List<E> lst = this.list;
        int hi = this.getFence();
        this.index = hi;
        try {
            for (int i = this.index; i < hi; ++i) {
                action.accept(lst.get(i));
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new ConcurrentModificationException();
        }
        RASpliterator.checkAbsListModCount(this.alist, this.expectedModCount);
    }

    @Override
    public long estimateSize() {
        return this.getFence() - this.index;
    }

    @Override
    public int characteristics() {
        return 16464;
    }

    private static void checkAbsListModCount(AbstractList<?> alist, int expectedModCount) {
        if (alist != null && RASpliterator.getModCount(alist) != expectedModCount) {
            throw new ConcurrentModificationException();
        }
    }

    private static <T> int getModCount(List<T> lst) {
        return U.getInt(lst, MODCOUNT_OFF);
    }

    static {
        try {
            MODCOUNT_OFF = U.objectFieldOffset(AbstractList.class.getDeclaredField("modCount"));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }
}

