/*
 * Decompiled with CFR 0.152.
 */
package java9.util;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java9.util.Objects;
import java9.util.function.Consumer;

public final class Iterators {
    public static <E> void forEachRemaining(Iterator<E> it, Consumer<? super E> action) {
        Objects.requireNonNull(it);
        Objects.requireNonNull(action);
        while (it.hasNext()) {
            action.accept(it.next());
        }
    }

    public static <E> Iterator<E> asIterator(final Enumeration<E> en) {
        Objects.requireNonNull(en);
        return new ImmutableIt<E>(){

            @Override
            public boolean hasNext() {
                return en.hasMoreElements();
            }

            @Override
            public E next() {
                return en.nextElement();
            }
        };
    }

    public static <T> Iterator<T> emptyIterator() {
        return EmptyIt.EMPTY_ITERATOR;
    }

    static <E> Iterator<E> singletonIterator(final E e) {
        return new ImmutableIt<E>(){
            private boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public E next() {
                if (this.hasNext) {
                    this.hasNext = false;
                    return e;
                }
                throw new NoSuchElementException();
            }
        };
    }

    private Iterators() {
    }

    static abstract class ImmutableIt<T>
    implements Iterator<T> {
        ImmutableIt() {
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    static final class EmptyIt<E>
    extends ImmutableIt<E> {
        static final EmptyIt<Object> EMPTY_ITERATOR = new EmptyIt();

        EmptyIt() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public E next() {
            throw new NoSuchElementException();
        }
    }
}

