/*
 * Decompiled with CFR 0.152.
 */
package java9.util.stream;

import java.util.Comparator;
import java.util.concurrent.atomic.AtomicBoolean;
import java9.util.Objects;
import java9.util.Spliterator;
import java9.util.concurrent.CountedCompleter;
import java9.util.function.Consumer;
import java9.util.function.DoubleConsumer;
import java9.util.function.DoublePredicate;
import java9.util.function.IntConsumer;
import java9.util.function.IntFunction;
import java9.util.function.IntPredicate;
import java9.util.function.LongConsumer;
import java9.util.function.LongPredicate;
import java9.util.function.Predicate;
import java9.util.stream.AbstractPipeline;
import java9.util.stream.AbstractShortCircuitTask;
import java9.util.stream.AbstractTask;
import java9.util.stream.DoublePipeline;
import java9.util.stream.DoubleStream;
import java9.util.stream.IntPipeline;
import java9.util.stream.IntStream;
import java9.util.stream.LongPipeline;
import java9.util.stream.LongStream;
import java9.util.stream.Node;
import java9.util.stream.Nodes;
import java9.util.stream.PipelineHelper;
import java9.util.stream.ReferencePipeline;
import java9.util.stream.Sink;
import java9.util.stream.Stream;
import java9.util.stream.StreamOpFlag;
import java9.util.stream.StreamShape;

final class WhileOps {
    static final int TAKE_FLAGS = StreamOpFlag.NOT_SIZED | StreamOpFlag.IS_SHORT_CIRCUIT;
    static final int DROP_FLAGS = StreamOpFlag.NOT_SIZED;
    private static final IntFunction<Integer[]> INT_ARR_GEN = Integer[]::new;
    private static final IntFunction<Long[]> LONG_ARR_GEN = Long[]::new;
    private static final IntFunction<Double[]> DOUBLE_ARR_GEN = Double[]::new;

    WhileOps() {
    }

    static <T> Stream<T> makeTakeWhileRef(AbstractPipeline<?, T, ?> upstream, final Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        return new ReferencePipeline.StatefulOp<T, T>(upstream, StreamShape.REFERENCE, TAKE_FLAGS){

            @Override
            <P_IN> Spliterator<T> opEvaluateParallelLazy(PipelineHelper<T> helper, Spliterator<P_IN> spliterator) {
                if (StreamOpFlag.ORDERED.isKnown(helper.getStreamAndOpFlags())) {
                    return this.opEvaluateParallel(helper, spliterator, Nodes.castingArray()).spliterator();
                }
                return new UnorderedWhileSpliterator.OfRef.Taking(helper.wrapSpliterator(spliterator), false, predicate);
            }

            @Override
            <P_IN> Node<T> opEvaluateParallel(PipelineHelper<T> helper, Spliterator<P_IN> spliterator, IntFunction<T[]> generator) {
                return (Node)new TakeWhileTask(this, helper, spliterator, generator).invoke();
            }

            @Override
            Sink<T> opWrapSink(int flags, Sink<T> sink) {
                return new Sink.ChainedReference<T, T>(sink){
                    boolean take;
                    {
                        super(downstream);
                        this.take = true;
                    }

                    @Override
                    public void begin(long size) {
                        this.downstream.begin(-1L);
                    }

                    @Override
                    public void accept(T t) {
                        this.take = predicate.test(t);
                        if (this.take) {
                            this.downstream.accept(t);
                        }
                    }

                    @Override
                    public boolean cancellationRequested() {
                        return !this.take || this.downstream.cancellationRequested();
                    }
                };
            }
        };
    }

    static IntStream makeTakeWhileInt(AbstractPipeline<?, Integer, ?> upstream, final IntPredicate predicate) {
        Objects.requireNonNull(predicate);
        return new IntPipeline.StatefulOp<Integer>(upstream, StreamShape.INT_VALUE, TAKE_FLAGS){

            @Override
            <P_IN> Spliterator<Integer> opEvaluateParallelLazy(PipelineHelper<Integer> helper, Spliterator<P_IN> spliterator) {
                if (StreamOpFlag.ORDERED.isKnown(helper.getStreamAndOpFlags())) {
                    return this.opEvaluateParallel(helper, spliterator, INT_ARR_GEN).spliterator();
                }
                return new UnorderedWhileSpliterator.OfInt.Taking((Spliterator.OfInt)helper.wrapSpliterator(spliterator), false, predicate);
            }

            @Override
            <P_IN> Node<Integer> opEvaluateParallel(PipelineHelper<Integer> helper, Spliterator<P_IN> spliterator, IntFunction<Integer[]> generator) {
                return (Node)new TakeWhileTask<P_IN, Integer>(this, helper, spliterator, generator).invoke();
            }

            @Override
            Sink<Integer> opWrapSink(int flags, Sink<Integer> sink) {
                return new Sink.ChainedInt<Integer>(sink){
                    boolean take;
                    {
                        super(downstream);
                        this.take = true;
                    }

                    @Override
                    public void begin(long size) {
                        this.downstream.begin(-1L);
                    }

                    @Override
                    public void accept(int t) {
                        this.take = predicate.test(t);
                        if (this.take) {
                            this.downstream.accept(t);
                        }
                    }

                    @Override
                    public boolean cancellationRequested() {
                        return !this.take || this.downstream.cancellationRequested();
                    }
                };
            }
        };
    }

    static LongStream makeTakeWhileLong(AbstractPipeline<?, Long, ?> upstream, final LongPredicate predicate) {
        Objects.requireNonNull(predicate);
        return new LongPipeline.StatefulOp<Long>(upstream, StreamShape.LONG_VALUE, TAKE_FLAGS){

            @Override
            <P_IN> Spliterator<Long> opEvaluateParallelLazy(PipelineHelper<Long> helper, Spliterator<P_IN> spliterator) {
                if (StreamOpFlag.ORDERED.isKnown(helper.getStreamAndOpFlags())) {
                    return this.opEvaluateParallel(helper, spliterator, LONG_ARR_GEN).spliterator();
                }
                return new UnorderedWhileSpliterator.OfLong.Taking((Spliterator.OfLong)helper.wrapSpliterator(spliterator), false, predicate);
            }

            @Override
            <P_IN> Node<Long> opEvaluateParallel(PipelineHelper<Long> helper, Spliterator<P_IN> spliterator, IntFunction<Long[]> generator) {
                return (Node)new TakeWhileTask<P_IN, Long>(this, helper, spliterator, generator).invoke();
            }

            @Override
            Sink<Long> opWrapSink(int flags, Sink<Long> sink) {
                return new Sink.ChainedLong<Long>(sink){
                    boolean take;
                    {
                        super(downstream);
                        this.take = true;
                    }

                    @Override
                    public void begin(long size) {
                        this.downstream.begin(-1L);
                    }

                    @Override
                    public void accept(long t) {
                        this.take = predicate.test(t);
                        if (this.take) {
                            this.downstream.accept(t);
                        }
                    }

                    @Override
                    public boolean cancellationRequested() {
                        return !this.take || this.downstream.cancellationRequested();
                    }
                };
            }
        };
    }

    static DoubleStream makeTakeWhileDouble(AbstractPipeline<?, Double, ?> upstream, final DoublePredicate predicate) {
        Objects.requireNonNull(predicate);
        return new DoublePipeline.StatefulOp<Double>(upstream, StreamShape.DOUBLE_VALUE, TAKE_FLAGS){

            @Override
            <P_IN> Spliterator<Double> opEvaluateParallelLazy(PipelineHelper<Double> helper, Spliterator<P_IN> spliterator) {
                if (StreamOpFlag.ORDERED.isKnown(helper.getStreamAndOpFlags())) {
                    return this.opEvaluateParallel(helper, spliterator, DOUBLE_ARR_GEN).spliterator();
                }
                return new UnorderedWhileSpliterator.OfDouble.Taking((Spliterator.OfDouble)helper.wrapSpliterator(spliterator), false, predicate);
            }

            @Override
            <P_IN> Node<Double> opEvaluateParallel(PipelineHelper<Double> helper, Spliterator<P_IN> spliterator, IntFunction<Double[]> generator) {
                return (Node)new TakeWhileTask<P_IN, Double>(this, helper, spliterator, generator).invoke();
            }

            @Override
            Sink<Double> opWrapSink(int flags, Sink<Double> sink) {
                return new Sink.ChainedDouble<Double>(sink){
                    boolean take;
                    {
                        super(downstream);
                        this.take = true;
                    }

                    @Override
                    public void begin(long size) {
                        this.downstream.begin(-1L);
                    }

                    @Override
                    public void accept(double t) {
                        this.take = predicate.test(t);
                        if (this.take) {
                            this.downstream.accept(t);
                        }
                    }

                    @Override
                    public boolean cancellationRequested() {
                        return !this.take || this.downstream.cancellationRequested();
                    }
                };
            }
        };
    }

    static <T> Stream<T> makeDropWhileRef(AbstractPipeline<?, T, ?> upstream, final Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        class Op
        extends ReferencePipeline.StatefulOp<T, T>
        implements DropWhileOp<T> {
            public Op(AbstractPipeline<?, T, ?> upstream, StreamShape inputShape, int opFlags) {
                super(upstream, inputShape, opFlags);
            }

            @Override
            <P_IN> Spliterator<T> opEvaluateParallelLazy(PipelineHelper<T> helper, Spliterator<P_IN> spliterator) {
                if (StreamOpFlag.ORDERED.isKnown(helper.getStreamAndOpFlags())) {
                    return this.opEvaluateParallel(helper, spliterator, Nodes.castingArray()).spliterator();
                }
                return new UnorderedWhileSpliterator.OfRef.Dropping(helper.wrapSpliterator(spliterator), false, predicate);
            }

            @Override
            <P_IN> Node<T> opEvaluateParallel(PipelineHelper<T> helper, Spliterator<P_IN> spliterator, IntFunction<T[]> generator) {
                return (Node)new DropWhileTask(this, helper, spliterator, generator).invoke();
            }

            @Override
            Sink<T> opWrapSink(int flags, Sink<T> sink) {
                return this.opWrapSink(sink, false);
            }

            @Override
            public DropWhileSink<T> opWrapSink(final Sink<T> sink, final boolean retainAndCountDroppedElements) {
                class OpSink
                extends Sink.ChainedReference<T, T>
                implements DropWhileSink<T> {
                    long dropCount;
                    boolean take;

                    OpSink() {
                        super(sink2);
                    }

                    @Override
                    public void accept(T t) {
                        boolean takeElement;
                        boolean bl = this.take || (this.take = !predicate.test(t)) ? true : (takeElement = false);
                        if (retainAndCountDroppedElements && !takeElement) {
                            ++this.dropCount;
                        }
                        if (retainAndCountDroppedElements || takeElement) {
                            this.downstream.accept(t);
                        }
                    }

                    @Override
                    public long getDropCount() {
                        return this.dropCount;
                    }
                }
                return new OpSink();
            }
        }
        return new Op(upstream, StreamShape.REFERENCE, DROP_FLAGS);
    }

    static IntStream makeDropWhileInt(AbstractPipeline<?, Integer, ?> upstream, final IntPredicate predicate) {
        Objects.requireNonNull(predicate);
        class Op
        extends IntPipeline.StatefulOp<Integer>
        implements DropWhileOp<Integer> {
            public Op(AbstractPipeline<?, Integer, ?> upstream, StreamShape inputShape, int opFlags) {
                super(upstream, inputShape, opFlags);
            }

            @Override
            <P_IN> Spliterator<Integer> opEvaluateParallelLazy(PipelineHelper<Integer> helper, Spliterator<P_IN> spliterator) {
                if (StreamOpFlag.ORDERED.isKnown(helper.getStreamAndOpFlags())) {
                    return this.opEvaluateParallel(helper, spliterator, INT_ARR_GEN).spliterator();
                }
                return new UnorderedWhileSpliterator.OfInt.Dropping((Spliterator.OfInt)helper.wrapSpliterator(spliterator), false, predicate);
            }

            @Override
            <P_IN> Node<Integer> opEvaluateParallel(PipelineHelper<Integer> helper, Spliterator<P_IN> spliterator, IntFunction<Integer[]> generator) {
                return (Node)new DropWhileTask<P_IN, Integer>(this, helper, spliterator, generator).invoke();
            }

            @Override
            Sink<Integer> opWrapSink(int flags, Sink<Integer> sink) {
                return this.opWrapSink(sink, false);
            }

            @Override
            public DropWhileSink<Integer> opWrapSink(final Sink<Integer> sink, final boolean retainAndCountDroppedElements) {
                class OpSink
                extends Sink.ChainedInt<Integer>
                implements DropWhileSink<Integer> {
                    long dropCount;
                    boolean take;

                    OpSink() {
                        super(sink2);
                    }

                    @Override
                    public void accept(int t) {
                        boolean takeElement;
                        boolean bl = this.take || (this.take = !predicate.test(t)) ? true : (takeElement = false);
                        if (retainAndCountDroppedElements && !takeElement) {
                            ++this.dropCount;
                        }
                        if (retainAndCountDroppedElements || takeElement) {
                            this.downstream.accept(t);
                        }
                    }

                    @Override
                    public long getDropCount() {
                        return this.dropCount;
                    }
                }
                return new OpSink();
            }
        }
        return new Op(upstream, StreamShape.INT_VALUE, DROP_FLAGS);
    }

    static LongStream makeDropWhileLong(AbstractPipeline<?, Long, ?> upstream, final LongPredicate predicate) {
        Objects.requireNonNull(predicate);
        class Op
        extends LongPipeline.StatefulOp<Long>
        implements DropWhileOp<Long> {
            public Op(AbstractPipeline<?, Long, ?> upstream, StreamShape inputShape, int opFlags) {
                super(upstream, inputShape, opFlags);
            }

            @Override
            <P_IN> Spliterator<Long> opEvaluateParallelLazy(PipelineHelper<Long> helper, Spliterator<P_IN> spliterator) {
                if (StreamOpFlag.ORDERED.isKnown(helper.getStreamAndOpFlags())) {
                    return this.opEvaluateParallel(helper, spliterator, LONG_ARR_GEN).spliterator();
                }
                return new UnorderedWhileSpliterator.OfLong.Dropping((Spliterator.OfLong)helper.wrapSpliterator(spliterator), false, predicate);
            }

            @Override
            <P_IN> Node<Long> opEvaluateParallel(PipelineHelper<Long> helper, Spliterator<P_IN> spliterator, IntFunction<Long[]> generator) {
                return (Node)new DropWhileTask<P_IN, Long>(this, helper, spliterator, generator).invoke();
            }

            @Override
            Sink<Long> opWrapSink(int flags, Sink<Long> sink) {
                return this.opWrapSink(sink, false);
            }

            @Override
            public DropWhileSink<Long> opWrapSink(final Sink<Long> sink, final boolean retainAndCountDroppedElements) {
                class OpSink
                extends Sink.ChainedLong<Long>
                implements DropWhileSink<Long> {
                    long dropCount;
                    boolean take;

                    OpSink() {
                        super(sink2);
                    }

                    @Override
                    public void accept(long t) {
                        boolean takeElement;
                        boolean bl = this.take || (this.take = !predicate.test(t)) ? true : (takeElement = false);
                        if (retainAndCountDroppedElements && !takeElement) {
                            ++this.dropCount;
                        }
                        if (retainAndCountDroppedElements || takeElement) {
                            this.downstream.accept(t);
                        }
                    }

                    @Override
                    public long getDropCount() {
                        return this.dropCount;
                    }
                }
                return new OpSink();
            }
        }
        return new Op(upstream, StreamShape.LONG_VALUE, DROP_FLAGS);
    }

    static DoubleStream makeDropWhileDouble(AbstractPipeline<?, Double, ?> upstream, final DoublePredicate predicate) {
        Objects.requireNonNull(predicate);
        class Op
        extends DoublePipeline.StatefulOp<Double>
        implements DropWhileOp<Double> {
            public Op(AbstractPipeline<?, Double, ?> upstream, StreamShape inputShape, int opFlags) {
                super(upstream, inputShape, opFlags);
            }

            @Override
            <P_IN> Spliterator<Double> opEvaluateParallelLazy(PipelineHelper<Double> helper, Spliterator<P_IN> spliterator) {
                if (StreamOpFlag.ORDERED.isKnown(helper.getStreamAndOpFlags())) {
                    return this.opEvaluateParallel(helper, spliterator, DOUBLE_ARR_GEN).spliterator();
                }
                return new UnorderedWhileSpliterator.OfDouble.Dropping((Spliterator.OfDouble)helper.wrapSpliterator(spliterator), false, predicate);
            }

            @Override
            <P_IN> Node<Double> opEvaluateParallel(PipelineHelper<Double> helper, Spliterator<P_IN> spliterator, IntFunction<Double[]> generator) {
                return (Node)new DropWhileTask<P_IN, Double>(this, helper, spliterator, generator).invoke();
            }

            @Override
            Sink<Double> opWrapSink(int flags, Sink<Double> sink) {
                return this.opWrapSink(sink, false);
            }

            @Override
            public DropWhileSink<Double> opWrapSink(final Sink<Double> sink, final boolean retainAndCountDroppedElements) {
                class OpSink
                extends Sink.ChainedDouble<Double>
                implements DropWhileSink<Double> {
                    long dropCount;
                    boolean take;

                    OpSink() {
                        super(sink2);
                    }

                    @Override
                    public void accept(double t) {
                        boolean takeElement;
                        boolean bl = this.take || (this.take = !predicate.test(t)) ? true : (takeElement = false);
                        if (retainAndCountDroppedElements && !takeElement) {
                            ++this.dropCount;
                        }
                        if (retainAndCountDroppedElements || takeElement) {
                            this.downstream.accept(t);
                        }
                    }

                    @Override
                    public long getDropCount() {
                        return this.dropCount;
                    }
                }
                return new OpSink();
            }
        }
        return new Op(upstream, StreamShape.DOUBLE_VALUE, DROP_FLAGS);
    }

    private static final class DropWhileTask<P_IN, P_OUT>
    extends AbstractTask<P_IN, P_OUT, Node<P_OUT>, DropWhileTask<P_IN, P_OUT>> {
        private final AbstractPipeline<P_OUT, P_OUT, ?> op;
        private final IntFunction<P_OUT[]> generator;
        private final boolean isOrdered;
        private long thisNodeSize;
        private long index;

        DropWhileTask(AbstractPipeline<P_OUT, P_OUT, ?> op, PipelineHelper<P_OUT> helper, Spliterator<P_IN> spliterator, IntFunction<P_OUT[]> generator) {
            super(helper, spliterator);
            this.op = op;
            this.generator = generator;
            this.isOrdered = StreamOpFlag.ORDERED.isKnown(helper.getStreamAndOpFlags());
        }

        DropWhileTask(DropWhileTask<P_IN, P_OUT> parent, Spliterator<P_IN> spliterator) {
            super(parent, spliterator);
            this.op = parent.op;
            this.generator = parent.generator;
            this.isOrdered = parent.isOrdered;
        }

        @Override
        protected DropWhileTask<P_IN, P_OUT> makeChild(Spliterator<P_IN> spliterator) {
            return new DropWhileTask<P_IN, P_OUT>(this, spliterator);
        }

        @Override
        protected final Node<P_OUT> doLeaf() {
            boolean isChild = !this.isRoot();
            long sizeIfKnown = isChild && this.isOrdered && StreamOpFlag.SIZED.isPreserved(this.op.sourceOrOpFlags) ? this.op.exactOutputSizeIfKnown(this.spliterator) : -1L;
            Node.Builder builder = this.helper.makeNodeBuilder(sizeIfKnown, this.generator);
            DropWhileOp dropOp = (DropWhileOp)((Object)this.op);
            DropWhileSink s = dropOp.opWrapSink(builder, this.isOrdered && isChild);
            this.helper.wrapAndCopyInto(s, this.spliterator);
            Node node = builder.build();
            this.thisNodeSize = node.count();
            this.index = s.getDropCount();
            return node;
        }

        @Override
        public final void onCompletion(CountedCompleter<?> caller) {
            if (!this.isLeaf()) {
                if (this.isOrdered) {
                    this.index = ((DropWhileTask)this.leftChild).index;
                    if (this.index == ((DropWhileTask)this.leftChild).thisNodeSize) {
                        this.index += ((DropWhileTask)this.rightChild).index;
                    }
                }
                this.thisNodeSize = ((DropWhileTask)this.leftChild).thisNodeSize + ((DropWhileTask)this.rightChild).thisNodeSize;
                Node<P_OUT> result = this.merge();
                this.setLocalResult(this.isRoot() ? this.doTruncate(result) : result);
            }
            super.onCompletion(caller);
        }

        private Node<P_OUT> merge() {
            if (((DropWhileTask)this.leftChild).thisNodeSize == 0L) {
                return (Node)((DropWhileTask)this.rightChild).getLocalResult();
            }
            if (((DropWhileTask)this.rightChild).thisNodeSize == 0L) {
                return (Node)((DropWhileTask)this.leftChild).getLocalResult();
            }
            return Nodes.conc(this.op.getOutputShape(), (Node)((DropWhileTask)this.leftChild).getLocalResult(), (Node)((DropWhileTask)this.rightChild).getLocalResult());
        }

        private Node<P_OUT> doTruncate(Node<P_OUT> input) {
            return this.isOrdered ? input.truncate(this.index, input.count(), this.generator) : input;
        }
    }

    private static final class TakeWhileTask<P_IN, P_OUT>
    extends AbstractShortCircuitTask<P_IN, P_OUT, Node<P_OUT>, TakeWhileTask<P_IN, P_OUT>> {
        private final AbstractPipeline<P_OUT, P_OUT, ?> op;
        private final IntFunction<P_OUT[]> generator;
        private final boolean isOrdered;
        private long thisNodeSize;
        private boolean shortCircuited;
        private volatile boolean completed;

        TakeWhileTask(AbstractPipeline<P_OUT, P_OUT, ?> op, PipelineHelper<P_OUT> helper, Spliterator<P_IN> spliterator, IntFunction<P_OUT[]> generator) {
            super(helper, spliterator);
            this.op = op;
            this.generator = generator;
            this.isOrdered = StreamOpFlag.ORDERED.isKnown(helper.getStreamAndOpFlags());
        }

        TakeWhileTask(TakeWhileTask<P_IN, P_OUT> parent, Spliterator<P_IN> spliterator) {
            super(parent, spliterator);
            this.op = parent.op;
            this.generator = parent.generator;
            this.isOrdered = parent.isOrdered;
        }

        @Override
        protected TakeWhileTask<P_IN, P_OUT> makeChild(Spliterator<P_IN> spliterator) {
            return new TakeWhileTask<P_IN, P_OUT>(this, spliterator);
        }

        @Override
        protected final Node<P_OUT> getEmptyResult() {
            return Nodes.emptyNode(this.op.getOutputShape());
        }

        @Override
        protected final Node<P_OUT> doLeaf() {
            Node.Builder builder = this.helper.makeNodeBuilder(-1L, this.generator);
            Sink<P_OUT> s = this.op.opWrapSink(this.helper.getStreamAndOpFlags(), builder);
            this.shortCircuited = this.helper.copyIntoWithCancel(this.helper.wrapSink(s), this.spliterator);
            if (this.shortCircuited) {
                this.cancelLaterNodes();
            }
            Node node = builder.build();
            this.thisNodeSize = node.count();
            return node;
        }

        @Override
        public final void onCompletion(CountedCompleter<?> caller) {
            if (!this.isLeaf()) {
                Node result;
                this.shortCircuited = ((TakeWhileTask)this.leftChild).shortCircuited | ((TakeWhileTask)this.rightChild).shortCircuited;
                if (this.isOrdered && this.canceled) {
                    this.thisNodeSize = 0L;
                    result = this.getEmptyResult();
                } else if (this.isOrdered && ((TakeWhileTask)this.leftChild).shortCircuited) {
                    this.thisNodeSize = ((TakeWhileTask)this.leftChild).thisNodeSize;
                    result = (Node)((TakeWhileTask)this.leftChild).getLocalResult();
                } else {
                    this.thisNodeSize = ((TakeWhileTask)this.leftChild).thisNodeSize + ((TakeWhileTask)this.rightChild).thisNodeSize;
                    result = this.merge();
                }
                this.setLocalResult(result);
            }
            this.completed = true;
            super.onCompletion(caller);
        }

        Node<P_OUT> merge() {
            if (((TakeWhileTask)this.leftChild).thisNodeSize == 0L) {
                return (Node)((TakeWhileTask)this.rightChild).getLocalResult();
            }
            if (((TakeWhileTask)this.rightChild).thisNodeSize == 0L) {
                return (Node)((TakeWhileTask)this.leftChild).getLocalResult();
            }
            return Nodes.conc(this.op.getOutputShape(), (Node)((TakeWhileTask)this.leftChild).getLocalResult(), (Node)((TakeWhileTask)this.rightChild).getLocalResult());
        }

        @Override
        protected void cancel() {
            super.cancel();
            if (this.isOrdered && this.completed) {
                this.setLocalResult(this.getEmptyResult());
            }
        }
    }

    static abstract class UnorderedWhileSpliterator<T, T_SPLITR extends Spliterator<T>>
    implements Spliterator<T> {
        static final int CANCEL_CHECK_COUNT = 63;
        final T_SPLITR s;
        final boolean noSplitting;
        final AtomicBoolean cancel;
        boolean takeOrDrop = true;
        int count;

        UnorderedWhileSpliterator(T_SPLITR s, boolean noSplitting) {
            this.s = s;
            this.noSplitting = noSplitting;
            this.cancel = new AtomicBoolean();
        }

        UnorderedWhileSpliterator(T_SPLITR s, UnorderedWhileSpliterator<T, T_SPLITR> parent) {
            this.s = s;
            this.noSplitting = parent.noSplitting;
            this.cancel = parent.cancel;
        }

        @Override
        public long estimateSize() {
            return this.s.estimateSize();
        }

        @Override
        public int characteristics() {
            return this.s.characteristics() & 0xFFFFBFBF;
        }

        @Override
        public long getExactSizeIfKnown() {
            return -1L;
        }

        @Override
        public Comparator<? super T> getComparator() {
            return this.s.getComparator();
        }

        public T_SPLITR trySplit() {
            Spliterator ls = this.noSplitting ? null : this.s.trySplit();
            return (T_SPLITR)(ls != null ? this.makeSpliterator(ls) : null);
        }

        boolean checkCancelOnCount() {
            return this.count != 0 || !this.cancel.get();
        }

        abstract T_SPLITR makeSpliterator(T_SPLITR var1);

        static abstract class OfDouble
        extends UnorderedWhileSpliterator<Double, Spliterator.OfDouble>
        implements DoubleConsumer,
        Spliterator.OfDouble {
            final DoublePredicate p;
            double t;

            OfDouble(Spliterator.OfDouble s, boolean noSplitting, DoublePredicate p) {
                super(s, noSplitting);
                this.p = p;
            }

            OfDouble(Spliterator.OfDouble s, OfDouble parent) {
                super(s, parent);
                this.p = parent.p;
            }

            @Override
            public void accept(double t) {
                this.count = this.count + 1 & 0x3F;
                this.t = t;
            }

            static final class Dropping
            extends OfDouble {
                Dropping(Spliterator.OfDouble s, boolean noSplitting, DoublePredicate p) {
                    super(s, noSplitting, p);
                }

                Dropping(Spliterator.OfDouble s, OfDouble parent) {
                    super(s, parent);
                }

                @Override
                public boolean tryAdvance(DoubleConsumer action) {
                    if (this.takeOrDrop) {
                        boolean adv;
                        this.takeOrDrop = false;
                        boolean dropped = false;
                        while ((adv = ((Spliterator.OfDouble)this.s).tryAdvance(this)) && this.checkCancelOnCount() && this.p.test(this.t)) {
                            dropped = true;
                        }
                        if (adv) {
                            if (dropped) {
                                this.cancel.set(true);
                            }
                            action.accept(this.t);
                        }
                        return adv;
                    }
                    return ((Spliterator.OfDouble)this.s).tryAdvance(action);
                }

                @Override
                Spliterator.OfDouble makeSpliterator(Spliterator.OfDouble s) {
                    return new Dropping(s, this);
                }
            }

            static final class Taking
            extends OfDouble {
                Taking(Spliterator.OfDouble s, boolean noSplitting, DoublePredicate p) {
                    super(s, noSplitting, p);
                }

                Taking(Spliterator.OfDouble s, OfDouble parent) {
                    super(s, parent);
                }

                @Override
                public boolean tryAdvance(DoubleConsumer action) {
                    boolean test = true;
                    if (this.takeOrDrop && this.checkCancelOnCount() && ((Spliterator.OfDouble)this.s).tryAdvance(this) && (test = this.p.test(this.t))) {
                        action.accept(this.t);
                        return true;
                    }
                    this.takeOrDrop = false;
                    if (!test) {
                        this.cancel.set(true);
                    }
                    return false;
                }

                @Override
                public Spliterator.OfDouble trySplit() {
                    return this.cancel.get() ? null : (Spliterator.OfDouble)super.trySplit();
                }

                @Override
                Spliterator.OfDouble makeSpliterator(Spliterator.OfDouble s) {
                    return new Taking(s, this);
                }
            }
        }

        static abstract class OfLong
        extends UnorderedWhileSpliterator<Long, Spliterator.OfLong>
        implements LongConsumer,
        Spliterator.OfLong {
            final LongPredicate p;
            long t;

            OfLong(Spliterator.OfLong s, boolean noSplitting, LongPredicate p) {
                super(s, noSplitting);
                this.p = p;
            }

            OfLong(Spliterator.OfLong s, OfLong parent) {
                super(s, parent);
                this.p = parent.p;
            }

            @Override
            public void accept(long t) {
                this.count = this.count + 1 & 0x3F;
                this.t = t;
            }

            @Override
            Spliterator.OfLong makeSpliterator(Spliterator.OfLong s) {
                return new Dropping(s, this);
            }

            static final class Dropping
            extends OfLong {
                Dropping(Spliterator.OfLong s, boolean noSplitting, LongPredicate p) {
                    super(s, noSplitting, p);
                }

                Dropping(Spliterator.OfLong s, OfLong parent) {
                    super(s, parent);
                }

                @Override
                public boolean tryAdvance(LongConsumer action) {
                    if (this.takeOrDrop) {
                        boolean adv;
                        this.takeOrDrop = false;
                        boolean dropped = false;
                        while ((adv = ((Spliterator.OfLong)this.s).tryAdvance(this)) && this.checkCancelOnCount() && this.p.test(this.t)) {
                            dropped = true;
                        }
                        if (adv) {
                            if (dropped) {
                                this.cancel.set(true);
                            }
                            action.accept(this.t);
                        }
                        return adv;
                    }
                    return ((Spliterator.OfLong)this.s).tryAdvance(action);
                }
            }

            static final class Taking
            extends OfLong {
                Taking(Spliterator.OfLong s, boolean noSplitting, LongPredicate p) {
                    super(s, noSplitting, p);
                }

                Taking(Spliterator.OfLong s, OfLong parent) {
                    super(s, parent);
                }

                @Override
                public boolean tryAdvance(LongConsumer action) {
                    boolean test = true;
                    if (this.takeOrDrop && this.checkCancelOnCount() && ((Spliterator.OfLong)this.s).tryAdvance(this) && (test = this.p.test(this.t))) {
                        action.accept(this.t);
                        return true;
                    }
                    this.takeOrDrop = false;
                    if (!test) {
                        this.cancel.set(true);
                    }
                    return false;
                }

                @Override
                public Spliterator.OfLong trySplit() {
                    return this.cancel.get() ? null : (Spliterator.OfLong)super.trySplit();
                }

                @Override
                Spliterator.OfLong makeSpliterator(Spliterator.OfLong s) {
                    return new Taking(s, this);
                }
            }
        }

        static abstract class OfInt
        extends UnorderedWhileSpliterator<Integer, Spliterator.OfInt>
        implements IntConsumer,
        Spliterator.OfInt {
            final IntPredicate p;
            int t;

            OfInt(Spliterator.OfInt s, boolean noSplitting, IntPredicate p) {
                super(s, noSplitting);
                this.p = p;
            }

            OfInt(Spliterator.OfInt s, OfInt parent) {
                super(s, parent);
                this.p = parent.p;
            }

            @Override
            public void accept(int t) {
                this.count = this.count + 1 & 0x3F;
                this.t = t;
            }

            static final class Dropping
            extends OfInt {
                Dropping(Spliterator.OfInt s, boolean noSplitting, IntPredicate p) {
                    super(s, noSplitting, p);
                }

                Dropping(Spliterator.OfInt s, OfInt parent) {
                    super(s, parent);
                }

                @Override
                public boolean tryAdvance(IntConsumer action) {
                    if (this.takeOrDrop) {
                        boolean adv;
                        this.takeOrDrop = false;
                        boolean dropped = false;
                        while ((adv = ((Spliterator.OfInt)this.s).tryAdvance(this)) && this.checkCancelOnCount() && this.p.test(this.t)) {
                            dropped = true;
                        }
                        if (adv) {
                            if (dropped) {
                                this.cancel.set(true);
                            }
                            action.accept(this.t);
                        }
                        return adv;
                    }
                    return ((Spliterator.OfInt)this.s).tryAdvance(action);
                }

                @Override
                Spliterator.OfInt makeSpliterator(Spliterator.OfInt s) {
                    return new Dropping(s, this);
                }
            }

            static final class Taking
            extends OfInt {
                Taking(Spliterator.OfInt s, boolean noSplitting, IntPredicate p) {
                    super(s, noSplitting, p);
                }

                Taking(Spliterator.OfInt s, OfInt parent) {
                    super(s, parent);
                }

                @Override
                public boolean tryAdvance(IntConsumer action) {
                    boolean test = true;
                    if (this.takeOrDrop && this.checkCancelOnCount() && ((Spliterator.OfInt)this.s).tryAdvance(this) && (test = this.p.test(this.t))) {
                        action.accept(this.t);
                        return true;
                    }
                    this.takeOrDrop = false;
                    if (!test) {
                        this.cancel.set(true);
                    }
                    return false;
                }

                @Override
                public Spliterator.OfInt trySplit() {
                    return this.cancel.get() ? null : (Spliterator.OfInt)super.trySplit();
                }

                @Override
                Spliterator.OfInt makeSpliterator(Spliterator.OfInt s) {
                    return new Taking(s, this);
                }
            }
        }

        static abstract class OfRef<T>
        extends UnorderedWhileSpliterator<T, Spliterator<T>>
        implements Consumer<T> {
            final Predicate<? super T> p;
            T t;

            OfRef(Spliterator<T> s, boolean noSplitting, Predicate<? super T> p) {
                super(s, noSplitting);
                this.p = p;
            }

            OfRef(Spliterator<T> s, OfRef<T> parent) {
                super(s, parent);
                this.p = parent.p;
            }

            @Override
            public void accept(T t) {
                this.count = this.count + 1 & 0x3F;
                this.t = t;
            }

            static final class Dropping<T>
            extends OfRef<T> {
                Dropping(Spliterator<T> s, boolean noSplitting, Predicate<? super T> p) {
                    super(s, noSplitting, p);
                }

                Dropping(Spliterator<T> s, Dropping<T> parent) {
                    super(s, parent);
                }

                @Override
                public boolean tryAdvance(Consumer<? super T> action) {
                    if (this.takeOrDrop) {
                        boolean adv;
                        this.takeOrDrop = false;
                        boolean dropped = false;
                        while ((adv = this.s.tryAdvance(this)) && this.checkCancelOnCount() && this.p.test(this.t)) {
                            dropped = true;
                        }
                        if (adv) {
                            if (dropped) {
                                this.cancel.set(true);
                            }
                            action.accept(this.t);
                        }
                        return adv;
                    }
                    return this.s.tryAdvance(action);
                }

                @Override
                Spliterator<T> makeSpliterator(Spliterator<T> s) {
                    return new Dropping<T>(s, this);
                }
            }

            static final class Taking<T>
            extends OfRef<T> {
                Taking(Spliterator<T> s, boolean noSplitting, Predicate<? super T> p) {
                    super(s, noSplitting, p);
                }

                Taking(Spliterator<T> s, Taking<T> parent) {
                    super(s, parent);
                }

                @Override
                public boolean tryAdvance(Consumer<? super T> action) {
                    boolean test = true;
                    if (this.takeOrDrop && this.checkCancelOnCount() && this.s.tryAdvance(this) && (test = this.p.test(this.t))) {
                        action.accept(this.t);
                        return true;
                    }
                    this.takeOrDrop = false;
                    if (!test) {
                        this.cancel.set(true);
                    }
                    return false;
                }

                @Override
                public Spliterator<T> trySplit() {
                    return this.cancel.get() ? null : (Spliterator<T>)super.trySplit();
                }

                @Override
                Spliterator<T> makeSpliterator(Spliterator<T> s) {
                    return new Taking<T>(s, this);
                }
            }
        }
    }

    static interface DropWhileSink<T>
    extends Sink<T> {
        public long getDropCount();
    }

    static interface DropWhileOp<T> {
        public DropWhileSink<T> opWrapSink(Sink<T> var1, boolean var2);
    }
}

