/*
 * Decompiled with CFR 0.152.
 */
package java9.util.stream;

import java9.util.Spliterator;
import java9.util.concurrent.CountedCompleter;
import java9.util.function.IntFunction;
import java9.util.stream.AbstractPipeline;
import java9.util.stream.AbstractShortCircuitTask;
import java9.util.stream.DoublePipeline;
import java9.util.stream.DoubleStream;
import java9.util.stream.IntPipeline;
import java9.util.stream.IntStream;
import java9.util.stream.LongPipeline;
import java9.util.stream.LongStream;
import java9.util.stream.Node;
import java9.util.stream.Nodes;
import java9.util.stream.PipelineHelper;
import java9.util.stream.ReferencePipeline;
import java9.util.stream.Sink;
import java9.util.stream.Stream;
import java9.util.stream.StreamOpFlag;
import java9.util.stream.StreamShape;
import java9.util.stream.StreamSpliterators;

final class SliceOps {
    private SliceOps() {
    }

    private static long calcSize(long size, long skip, long limit) {
        return size >= 0L ? Math.max(-1L, Math.min(size - skip, limit)) : -1L;
    }

    private static long calcSliceFence(long skip, long limit) {
        long sliceFence = limit >= 0L ? skip + limit : Long.MAX_VALUE;
        return sliceFence >= 0L ? sliceFence : Long.MAX_VALUE;
    }

    private static <P_IN> Spliterator<P_IN> sliceSpliterator(StreamShape shape, Spliterator<P_IN> s, long skip, long limit) {
        long sliceFence = SliceOps.calcSliceFence(skip, limit);
        switch (shape) {
            case REFERENCE: {
                return new StreamSpliterators.SliceSpliterator.OfRef<P_IN>(s, skip, sliceFence);
            }
            case INT_VALUE: {
                return new StreamSpliterators.SliceSpliterator.OfInt((Spliterator.OfInt)s, skip, sliceFence);
            }
            case LONG_VALUE: {
                return new StreamSpliterators.SliceSpliterator.OfLong((Spliterator.OfLong)s, skip, sliceFence);
            }
            case DOUBLE_VALUE: {
                return new StreamSpliterators.SliceSpliterator.OfDouble((Spliterator.OfDouble)s, skip, sliceFence);
            }
        }
        throw new IllegalStateException("Unknown shape " + (Object)((Object)shape));
    }

    public static <T> Stream<T> makeRef(AbstractPipeline<?, T, ?> upstream, final long skip, final long limit) {
        if (skip < 0L) {
            throw new IllegalArgumentException("Skip must be non-negative: " + skip);
        }
        return new ReferencePipeline.StatefulOp<T, T>(upstream, StreamShape.REFERENCE, SliceOps.flags(limit)){

            Spliterator<T> unorderedSkipLimitSpliterator(Spliterator<T> s, long skip2, long limit2, long sizeIfKnown) {
                if (skip2 <= sizeIfKnown) {
                    limit2 = limit2 >= 0L ? Math.min(limit2, sizeIfKnown - skip2) : sizeIfKnown - skip2;
                    skip2 = 0L;
                }
                return new StreamSpliterators.UnorderedSliceSpliterator.OfRef(s, skip2, limit2);
            }

            @Override
            <P_IN> Spliterator<T> opEvaluateParallelLazy(PipelineHelper<T> helper, Spliterator<P_IN> spliterator) {
                long size = helper.exactOutputSizeIfKnown(spliterator);
                if (size > 0L && spliterator.hasCharacteristics(16384)) {
                    return new StreamSpliterators.SliceSpliterator.OfRef(helper.wrapSpliterator(spliterator), skip, SliceOps.calcSliceFence(skip, limit));
                }
                if (!StreamOpFlag.ORDERED.isKnown(helper.getStreamAndOpFlags())) {
                    return this.unorderedSkipLimitSpliterator(helper.wrapSpliterator(spliterator), skip, limit, size);
                }
                return ((Node)new SliceTask(this, helper, spliterator, Nodes.castingArray(), skip, limit).invoke()).spliterator();
            }

            @Override
            <P_IN> Node<T> opEvaluateParallel(PipelineHelper<T> helper, Spliterator<P_IN> spliterator, IntFunction<T[]> generator) {
                long size = helper.exactOutputSizeIfKnown(spliterator);
                if (size > 0L && spliterator.hasCharacteristics(16384)) {
                    Spliterator s = SliceOps.sliceSpliterator(helper.getSourceShape(), spliterator, skip, limit);
                    return Nodes.collect(helper, s, true, generator);
                }
                if (!StreamOpFlag.ORDERED.isKnown(helper.getStreamAndOpFlags())) {
                    Spliterator s = this.unorderedSkipLimitSpliterator(helper.wrapSpliterator(spliterator), skip, limit, size);
                    return Nodes.collect(this, s, true, generator);
                }
                return (Node)new SliceTask(this, helper, spliterator, generator, skip, limit).invoke();
            }

            @Override
            Sink<T> opWrapSink(int flags, Sink<T> sink) {
                return new Sink.ChainedReference<T, T>(sink){
                    long n;
                    long m;
                    {
                        super(downstream);
                        this.n = skip;
                        this.m = limit >= 0L ? limit : Long.MAX_VALUE;
                    }

                    @Override
                    public void begin(long size) {
                        this.downstream.begin(SliceOps.calcSize(size, skip, this.m));
                    }

                    @Override
                    public void accept(T t) {
                        if (this.n == 0L) {
                            if (this.m > 0L) {
                                --this.m;
                                this.downstream.accept(t);
                            }
                        } else {
                            --this.n;
                        }
                    }

                    @Override
                    public boolean cancellationRequested() {
                        return this.m == 0L || this.downstream.cancellationRequested();
                    }
                };
            }
        };
    }

    public static IntStream makeInt(AbstractPipeline<?, Integer, ?> upstream, final long skip, final long limit) {
        if (skip < 0L) {
            throw new IllegalArgumentException("Skip must be non-negative: " + skip);
        }
        return new IntPipeline.StatefulOp<Integer>(upstream, StreamShape.INT_VALUE, SliceOps.flags(limit)){

            Spliterator.OfInt unorderedSkipLimitSpliterator(Spliterator.OfInt s, long skip2, long limit2, long sizeIfKnown) {
                if (skip2 <= sizeIfKnown) {
                    limit2 = limit2 >= 0L ? Math.min(limit2, sizeIfKnown - skip2) : sizeIfKnown - skip2;
                    skip2 = 0L;
                }
                return new StreamSpliterators.UnorderedSliceSpliterator.OfInt(s, skip2, limit2);
            }

            @Override
            <P_IN> Spliterator<Integer> opEvaluateParallelLazy(PipelineHelper<Integer> helper, Spliterator<P_IN> spliterator) {
                long size = helper.exactOutputSizeIfKnown(spliterator);
                if (size > 0L && spliterator.hasCharacteristics(16384)) {
                    return new StreamSpliterators.SliceSpliterator.OfInt((Spliterator.OfInt)helper.wrapSpliterator(spliterator), skip, SliceOps.calcSliceFence(skip, limit));
                }
                if (!StreamOpFlag.ORDERED.isKnown(helper.getStreamAndOpFlags())) {
                    return this.unorderedSkipLimitSpliterator((Spliterator.OfInt)helper.wrapSpliterator(spliterator), skip, limit, size);
                }
                return ((Node)new SliceTask<P_IN, Integer>(this, helper, spliterator, Integer[]::new, skip, limit).invoke()).spliterator();
            }

            @Override
            <P_IN> Node<Integer> opEvaluateParallel(PipelineHelper<Integer> helper, Spliterator<P_IN> spliterator, IntFunction<Integer[]> generator) {
                long size = helper.exactOutputSizeIfKnown(spliterator);
                if (size > 0L && spliterator.hasCharacteristics(16384)) {
                    Spliterator s = SliceOps.sliceSpliterator(helper.getSourceShape(), spliterator, skip, limit);
                    return Nodes.collectInt(helper, s, true);
                }
                if (!StreamOpFlag.ORDERED.isKnown(helper.getStreamAndOpFlags())) {
                    Spliterator.OfInt s = this.unorderedSkipLimitSpliterator((Spliterator.OfInt)helper.wrapSpliterator(spliterator), skip, limit, size);
                    return Nodes.collectInt(this, s, true);
                }
                return (Node)new SliceTask<P_IN, Integer>(this, helper, spliterator, generator, skip, limit).invoke();
            }

            @Override
            Sink<Integer> opWrapSink(int flags, Sink<Integer> sink) {
                return new Sink.ChainedInt<Integer>(sink){
                    long n;
                    long m;
                    {
                        super(downstream);
                        this.n = skip;
                        this.m = limit >= 0L ? limit : Long.MAX_VALUE;
                    }

                    @Override
                    public void begin(long size) {
                        this.downstream.begin(SliceOps.calcSize(size, skip, this.m));
                    }

                    @Override
                    public void accept(int t) {
                        if (this.n == 0L) {
                            if (this.m > 0L) {
                                --this.m;
                                this.downstream.accept(t);
                            }
                        } else {
                            --this.n;
                        }
                    }

                    @Override
                    public boolean cancellationRequested() {
                        return this.m == 0L || this.downstream.cancellationRequested();
                    }
                };
            }
        };
    }

    public static LongStream makeLong(AbstractPipeline<?, Long, ?> upstream, final long skip, final long limit) {
        if (skip < 0L) {
            throw new IllegalArgumentException("Skip must be non-negative: " + skip);
        }
        return new LongPipeline.StatefulOp<Long>(upstream, StreamShape.LONG_VALUE, SliceOps.flags(limit)){

            Spliterator.OfLong unorderedSkipLimitSpliterator(Spliterator.OfLong s, long skip2, long limit2, long sizeIfKnown) {
                if (skip2 <= sizeIfKnown) {
                    limit2 = limit2 >= 0L ? Math.min(limit2, sizeIfKnown - skip2) : sizeIfKnown - skip2;
                    skip2 = 0L;
                }
                return new StreamSpliterators.UnorderedSliceSpliterator.OfLong(s, skip2, limit2);
            }

            @Override
            <P_IN> Spliterator<Long> opEvaluateParallelLazy(PipelineHelper<Long> helper, Spliterator<P_IN> spliterator) {
                long size = helper.exactOutputSizeIfKnown(spliterator);
                if (size > 0L && spliterator.hasCharacteristics(16384)) {
                    return new StreamSpliterators.SliceSpliterator.OfLong((Spliterator.OfLong)helper.wrapSpliterator(spliterator), skip, SliceOps.calcSliceFence(skip, limit));
                }
                if (!StreamOpFlag.ORDERED.isKnown(helper.getStreamAndOpFlags())) {
                    return this.unorderedSkipLimitSpliterator((Spliterator.OfLong)helper.wrapSpliterator(spliterator), skip, limit, size);
                }
                return ((Node)new SliceTask<P_IN, Long>(this, helper, spliterator, Long[]::new, skip, limit).invoke()).spliterator();
            }

            @Override
            <P_IN> Node<Long> opEvaluateParallel(PipelineHelper<Long> helper, Spliterator<P_IN> spliterator, IntFunction<Long[]> generator) {
                long size = helper.exactOutputSizeIfKnown(spliterator);
                if (size > 0L && spliterator.hasCharacteristics(16384)) {
                    Spliterator s = SliceOps.sliceSpliterator(helper.getSourceShape(), spliterator, skip, limit);
                    return Nodes.collectLong(helper, s, true);
                }
                if (!StreamOpFlag.ORDERED.isKnown(helper.getStreamAndOpFlags())) {
                    Spliterator.OfLong s = this.unorderedSkipLimitSpliterator((Spliterator.OfLong)helper.wrapSpliterator(spliterator), skip, limit, size);
                    return Nodes.collectLong(this, s, true);
                }
                return (Node)new SliceTask<P_IN, Long>(this, helper, spliterator, generator, skip, limit).invoke();
            }

            @Override
            Sink<Long> opWrapSink(int flags, Sink<Long> sink) {
                return new Sink.ChainedLong<Long>(sink){
                    long n;
                    long m;
                    {
                        super(downstream);
                        this.n = skip;
                        this.m = limit >= 0L ? limit : Long.MAX_VALUE;
                    }

                    @Override
                    public void begin(long size) {
                        this.downstream.begin(SliceOps.calcSize(size, skip, this.m));
                    }

                    @Override
                    public void accept(long t) {
                        if (this.n == 0L) {
                            if (this.m > 0L) {
                                --this.m;
                                this.downstream.accept(t);
                            }
                        } else {
                            --this.n;
                        }
                    }

                    @Override
                    public boolean cancellationRequested() {
                        return this.m == 0L || this.downstream.cancellationRequested();
                    }
                };
            }
        };
    }

    public static DoubleStream makeDouble(AbstractPipeline<?, Double, ?> upstream, final long skip, final long limit) {
        if (skip < 0L) {
            throw new IllegalArgumentException("Skip must be non-negative: " + skip);
        }
        return new DoublePipeline.StatefulOp<Double>(upstream, StreamShape.DOUBLE_VALUE, SliceOps.flags(limit)){

            Spliterator.OfDouble unorderedSkipLimitSpliterator(Spliterator.OfDouble s, long skip2, long limit2, long sizeIfKnown) {
                if (skip2 <= sizeIfKnown) {
                    limit2 = limit2 >= 0L ? Math.min(limit2, sizeIfKnown - skip2) : sizeIfKnown - skip2;
                    skip2 = 0L;
                }
                return new StreamSpliterators.UnorderedSliceSpliterator.OfDouble(s, skip2, limit2);
            }

            @Override
            <P_IN> Spliterator<Double> opEvaluateParallelLazy(PipelineHelper<Double> helper, Spliterator<P_IN> spliterator) {
                long size = helper.exactOutputSizeIfKnown(spliterator);
                if (size > 0L && spliterator.hasCharacteristics(16384)) {
                    return new StreamSpliterators.SliceSpliterator.OfDouble((Spliterator.OfDouble)helper.wrapSpliterator(spliterator), skip, SliceOps.calcSliceFence(skip, limit));
                }
                if (!StreamOpFlag.ORDERED.isKnown(helper.getStreamAndOpFlags())) {
                    return this.unorderedSkipLimitSpliterator((Spliterator.OfDouble)helper.wrapSpliterator(spliterator), skip, limit, size);
                }
                return ((Node)new SliceTask<P_IN, Double>(this, helper, spliterator, Double[]::new, skip, limit).invoke()).spliterator();
            }

            @Override
            <P_IN> Node<Double> opEvaluateParallel(PipelineHelper<Double> helper, Spliterator<P_IN> spliterator, IntFunction<Double[]> generator) {
                long size = helper.exactOutputSizeIfKnown(spliterator);
                if (size > 0L && spliterator.hasCharacteristics(16384)) {
                    Spliterator s = SliceOps.sliceSpliterator(helper.getSourceShape(), spliterator, skip, limit);
                    return Nodes.collectDouble(helper, s, true);
                }
                if (!StreamOpFlag.ORDERED.isKnown(helper.getStreamAndOpFlags())) {
                    Spliterator.OfDouble s = this.unorderedSkipLimitSpliterator((Spliterator.OfDouble)helper.wrapSpliterator(spliterator), skip, limit, size);
                    return Nodes.collectDouble(this, s, true);
                }
                return (Node)new SliceTask<P_IN, Double>(this, helper, spliterator, generator, skip, limit).invoke();
            }

            @Override
            Sink<Double> opWrapSink(int flags, Sink<Double> sink) {
                return new Sink.ChainedDouble<Double>(sink){
                    long n;
                    long m;
                    {
                        super(downstream);
                        this.n = skip;
                        this.m = limit >= 0L ? limit : Long.MAX_VALUE;
                    }

                    @Override
                    public void begin(long size) {
                        this.downstream.begin(SliceOps.calcSize(size, skip, this.m));
                    }

                    @Override
                    public void accept(double t) {
                        if (this.n == 0L) {
                            if (this.m > 0L) {
                                --this.m;
                                this.downstream.accept(t);
                            }
                        } else {
                            --this.n;
                        }
                    }

                    @Override
                    public boolean cancellationRequested() {
                        return this.m == 0L || this.downstream.cancellationRequested();
                    }
                };
            }
        };
    }

    private static int flags(long limit) {
        return StreamOpFlag.NOT_SIZED | (limit != -1L ? StreamOpFlag.IS_SHORT_CIRCUIT : 0);
    }

    private static final class SliceTask<P_IN, P_OUT>
    extends AbstractShortCircuitTask<P_IN, P_OUT, Node<P_OUT>, SliceTask<P_IN, P_OUT>> {
        private final AbstractPipeline<P_OUT, P_OUT, ?> op;
        private final IntFunction<P_OUT[]> generator;
        private final long targetOffset;
        private final long targetSize;
        private long thisNodeSize;
        private volatile boolean completed;

        SliceTask(AbstractPipeline<P_OUT, P_OUT, ?> op, PipelineHelper<P_OUT> helper, Spliterator<P_IN> spliterator, IntFunction<P_OUT[]> generator, long offset, long size) {
            super(helper, spliterator);
            this.op = op;
            this.generator = generator;
            this.targetOffset = offset;
            this.targetSize = size;
        }

        SliceTask(SliceTask<P_IN, P_OUT> parent, Spliterator<P_IN> spliterator) {
            super(parent, spliterator);
            this.op = parent.op;
            this.generator = parent.generator;
            this.targetOffset = parent.targetOffset;
            this.targetSize = parent.targetSize;
        }

        @Override
        protected SliceTask<P_IN, P_OUT> makeChild(Spliterator<P_IN> spliterator) {
            return new SliceTask<P_IN, P_OUT>(this, spliterator);
        }

        @Override
        protected final Node<P_OUT> getEmptyResult() {
            return Nodes.emptyNode(this.op.getOutputShape());
        }

        @Override
        protected final Node<P_OUT> doLeaf() {
            if (this.isRoot()) {
                long sizeIfKnown = StreamOpFlag.SIZED.isPreserved(this.op.sourceOrOpFlags) ? this.op.exactOutputSizeIfKnown(this.spliterator) : -1L;
                Node.Builder<P_OUT> nb = this.op.makeNodeBuilder(sizeIfKnown, (IntFunction<P_OUT[]>)this.generator);
                Sink<P_OUT> opSink = this.op.opWrapSink(this.helper.getStreamAndOpFlags(), nb);
                this.helper.copyIntoWithCancel(this.helper.wrapSink(opSink), this.spliterator);
                return nb.build();
            }
            Node.Builder<P_OUT> nb = this.op.makeNodeBuilder(-1L, (IntFunction<P_OUT[]>)this.generator);
            if (this.targetOffset == 0L) {
                Sink<P_OUT> opSink = this.op.opWrapSink(this.helper.getStreamAndOpFlags(), nb);
                this.helper.copyIntoWithCancel(this.helper.wrapSink(opSink), this.spliterator);
            } else {
                this.helper.wrapAndCopyInto(nb, this.spliterator);
            }
            Node<P_OUT> node = nb.build();
            this.thisNodeSize = node.count();
            this.completed = true;
            this.spliterator = null;
            return node;
        }

        @Override
        public final void onCompletion(CountedCompleter<?> caller) {
            if (!this.isLeaf()) {
                Object result;
                this.thisNodeSize = ((SliceTask)this.leftChild).thisNodeSize + ((SliceTask)this.rightChild).thisNodeSize;
                if (this.canceled) {
                    this.thisNodeSize = 0L;
                    result = this.getEmptyResult();
                } else {
                    result = this.thisNodeSize == 0L ? this.getEmptyResult() : (((SliceTask)this.leftChild).thisNodeSize == 0L ? (Node)((SliceTask)this.rightChild).getLocalResult() : Nodes.conc(this.op.getOutputShape(), (Node)((SliceTask)this.leftChild).getLocalResult(), (Node)((SliceTask)this.rightChild).getLocalResult()));
                }
                this.setLocalResult(this.isRoot() ? this.doTruncate((Node<P_OUT>)result) : result);
                this.completed = true;
            }
            if (this.targetSize >= 0L && !this.isRoot() && this.isLeftCompleted(this.targetOffset + this.targetSize)) {
                this.cancelLaterNodes();
            }
            super.onCompletion(caller);
        }

        @Override
        protected void cancel() {
            super.cancel();
            if (this.completed) {
                this.setLocalResult(this.getEmptyResult());
            }
        }

        private Node<P_OUT> doTruncate(Node<P_OUT> input) {
            long to = this.targetSize >= 0L ? Math.min(input.count(), this.targetOffset + this.targetSize) : this.thisNodeSize;
            return input.truncate(this.targetOffset, to, this.generator);
        }

        private boolean isLeftCompleted(long target) {
            long size;
            long l = size = this.completed ? this.thisNodeSize : this.completedSize(target);
            if (size >= target) {
                return true;
            }
            SliceTask node = this;
            for (SliceTask parent = (SliceTask)this.getParent(); parent != null; parent = (SliceTask)parent.getParent()) {
                SliceTask left;
                if (node == parent.rightChild && (left = (SliceTask)parent.leftChild) != null && (size += left.completedSize(target)) >= target) {
                    return true;
                }
                node = parent;
            }
            return size >= target;
        }

        private long completedSize(long target) {
            if (this.completed) {
                return this.thisNodeSize;
            }
            SliceTask left = (SliceTask)this.leftChild;
            SliceTask right = (SliceTask)this.rightChild;
            if (left == null || right == null) {
                return this.thisNodeSize;
            }
            long leftSize = left.completedSize(target);
            return leftSize >= target ? leftSize : leftSize + right.completedSize(target);
        }
    }
}

