/*
 * Decompiled with CFR 0.152.
 */
package java9.util.stream;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java9.util.Objects;
import java9.util.function.BiConsumer;
import java9.util.function.BinaryOperator;
import java9.util.function.Function;
import java9.util.function.Supplier;
import java9.util.stream.Collectors;

public interface Collector<T, A, R> {
    public Supplier<A> supplier();

    public BiConsumer<A, T> accumulator();

    public BinaryOperator<A> combiner();

    public Function<A, R> finisher();

    public Set<Characteristics> characteristics();

    public static <T, R> Collector<T, R, R> of(Supplier<R> supplier, BiConsumer<R, T> accumulator, BinaryOperator<R> combiner, Characteristics ... characteristics) {
        Objects.requireNonNull(supplier);
        Objects.requireNonNull(accumulator);
        Objects.requireNonNull(combiner);
        Objects.requireNonNull(characteristics);
        Set<Characteristics> cs = characteristics.length == 0 ? Collectors.CH_ID : Collections.unmodifiableSet(EnumSet.of(Characteristics.IDENTITY_FINISH, characteristics));
        return new Collectors.CollectorImpl(supplier, accumulator, combiner, cs);
    }

    public static <T, A, R> Collector<T, A, R> of(Supplier<A> supplier, BiConsumer<A, T> accumulator, BinaryOperator<A> combiner, Function<A, R> finisher, Characteristics ... characteristics) {
        Objects.requireNonNull(supplier);
        Objects.requireNonNull(accumulator);
        Objects.requireNonNull(combiner);
        Objects.requireNonNull(finisher);
        Objects.requireNonNull(characteristics);
        Set<Characteristics> cs = Collectors.CH_NOID;
        if (characteristics.length > 0) {
            cs = EnumSet.noneOf(Characteristics.class);
            Collections.addAll(cs, characteristics);
            cs = Collections.unmodifiableSet(cs);
        }
        return new Collectors.CollectorImpl<T, A, R>(supplier, accumulator, combiner, finisher, cs);
    }

    public static enum Characteristics {
        CONCURRENT,
        UNORDERED,
        IDENTITY_FINISH;

    }
}

