/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.retroweaver.runtime.java.lang;

public class Math_ {
    private static final double LOG10 = Math.log(10.0);

    public static double log10(double a) {
        return Math.log(a) / LOG10;
    }

    public static double signum(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (d > 0.0) {
            return 1.0;
        }
        if (d < 0.0) {
            return -1.0;
        }
        return d;
    }

    public static float signum(float d) {
        if (Float.isNaN(d)) {
            return Float.NaN;
        }
        if (d > 0.0f) {
            return 1.0f;
        }
        if (d < 0.0f) {
            return -1.0f;
        }
        return d;
    }

    public static double sinh(double x) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (Double.isInfinite(x)) {
            return x;
        }
        if (x == 0.0) {
            return x;
        }
        return (Math.exp(x) - Math.exp(-x)) / 2.0;
    }

    public static double cosh(double x) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (Double.isInfinite(x)) {
            return Double.POSITIVE_INFINITY;
        }
        if (x == 0.0) {
            return 1.0;
        }
        return (Math.exp(x) + Math.exp(-x)) / 2.0;
    }

    public static double tanh(double x) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (x == 0.0) {
            return x;
        }
        if (x == Double.POSITIVE_INFINITY) {
            return 1.0;
        }
        if (x == Double.NEGATIVE_INFINITY) {
            return -1.0;
        }
        double exp1 = Math.exp(x);
        double exp2 = Math.exp(-x);
        return (exp1 - exp2) / (exp1 + exp2);
    }
}

