/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.retroweaver.harmony.runtime.java.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.CharBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import net.sourceforge.retroweaver.harmony.runtime.java.io.Flushable;
import net.sourceforge.retroweaver.harmony.runtime.java.lang.Character_;
import net.sourceforge.retroweaver.harmony.runtime.java.nio.charset.Charset_;
import net.sourceforge.retroweaver.harmony.runtime.java.util.DuplicateFormatFlagsException;
import net.sourceforge.retroweaver.harmony.runtime.java.util.FormatFlagsConversionMismatchException;
import net.sourceforge.retroweaver.harmony.runtime.java.util.Formattable;
import net.sourceforge.retroweaver.harmony.runtime.java.util.FormatterClosedException;
import net.sourceforge.retroweaver.harmony.runtime.java.util.IllegalFormatCodePointException;
import net.sourceforge.retroweaver.harmony.runtime.java.util.IllegalFormatConversionException;
import net.sourceforge.retroweaver.harmony.runtime.java.util.IllegalFormatFlagsException;
import net.sourceforge.retroweaver.harmony.runtime.java.util.IllegalFormatPrecisionException;
import net.sourceforge.retroweaver.harmony.runtime.java.util.IllegalFormatWidthException;
import net.sourceforge.retroweaver.harmony.runtime.java.util.MissingFormatArgumentException;
import net.sourceforge.retroweaver.harmony.runtime.java.util.MissingFormatWidthException;
import net.sourceforge.retroweaver.harmony.runtime.java.util.UnknownFormatConversionException;
import net.sourceforge.retroweaver.runtime.java.io.Closeable;
import net.sourceforge.retroweaver.runtime.java.io.Writer_;
import net.sourceforge.retroweaver.runtime.java.lang.Appendable;
import net.sourceforge.retroweaver.runtime.java.lang.Double_;
import net.sourceforge.retroweaver.runtime.java.lang.Enum;
import net.sourceforge.retroweaver.runtime.java.lang.Float_;

public final class Formatter
implements Closeable,
Flushable {
    private Writer out;
    private Locale locale;
    private boolean closed = false;
    private IOException lastIOException;

    public Formatter() {
        this(null, Locale.getDefault());
    }

    public Formatter(Appendable a) {
        this(a, Locale.getDefault());
    }

    public Formatter(Locale l) {
        this(null, l);
    }

    public Formatter(Appendable a, Locale l) {
        if (null == a) {
            this.out = new StringWriter();
        } else if (a instanceof PrintStream) {
            this.out = new PrintWriter((PrintStream)((Object)a));
        } else if (a instanceof Writer) {
            this.out = (Writer)((Object)a);
        } else {
            throw new UnsupportedOperationException("Appendable in Formatter constructor " + a.getClass());
        }
        this.locale = l;
    }

    public Formatter(String fileName) throws FileNotFoundException {
        this(new File(fileName));
    }

    public Formatter(String fileName, String csn) throws FileNotFoundException, UnsupportedEncodingException {
        this(new File(fileName), csn);
    }

    public Formatter(String fileName, String csn, Locale l) throws FileNotFoundException, UnsupportedEncodingException {
        this(new File(fileName), csn, l);
    }

    public Formatter(File file) throws FileNotFoundException {
        this(new FileOutputStream(file));
    }

    public Formatter(File file, String csn) throws FileNotFoundException, UnsupportedEncodingException {
        this(file, csn, Locale.getDefault());
    }

    public Formatter(File file, String csn, Locale l) throws FileNotFoundException, UnsupportedEncodingException {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(file);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fout, csn);
            this.out = new BufferedWriter(writer);
        }
        catch (RuntimeException e) {
            Formatter.closeOutputStream(fout);
            throw e;
        }
        catch (UnsupportedEncodingException e) {
            Formatter.closeOutputStream(fout);
            throw e;
        }
        this.locale = l;
    }

    public Formatter(OutputStream os) {
        OutputStreamWriter writer = new OutputStreamWriter(os, Charset_.defaultCharset());
        this.out = new BufferedWriter(writer);
        this.locale = Locale.getDefault();
    }

    public Formatter(OutputStream os, String csn) throws UnsupportedEncodingException {
        this(os, csn, Locale.getDefault());
    }

    public Formatter(OutputStream os, String csn, Locale l) throws UnsupportedEncodingException {
        OutputStreamWriter writer = new OutputStreamWriter(os, csn);
        this.out = new BufferedWriter(writer);
        this.locale = l;
    }

    public Formatter(PrintStream ps) {
        if (null == ps) {
            throw new NullPointerException();
        }
        this.out = new PrintWriter(ps);
        this.locale = Locale.getDefault();
    }

    private void checkClosed() {
        if (this.closed) {
            throw new FormatterClosedException();
        }
    }

    public Locale locale() {
        this.checkClosed();
        return this.locale;
    }

    public Appendable out() {
        this.checkClosed();
        return this.out;
    }

    public String toString() {
        this.checkClosed();
        return this.out.toString();
    }

    public void flush() {
        this.checkClosed();
        if (this.out instanceof Flushable) {
            try {
                this.out.flush();
            }
            catch (IOException e) {
                this.lastIOException = e;
            }
        }
    }

    public void close() {
        this.closed = true;
        try {
            if (this.out instanceof Closeable) {
                this.out.close();
            }
        }
        catch (IOException e) {
            this.lastIOException = e;
        }
    }

    public IOException ioException() {
        return this.lastIOException;
    }

    public Formatter format(String format, Object ... args) {
        return this.format(this.locale, format, args);
    }

    public Formatter format(Locale l, String format, Object ... args) {
        this.checkClosed();
        CharBuffer formatBuffer = CharBuffer.wrap(format);
        ParserStateMachine parser = new ParserStateMachine(formatBuffer);
        Transformer transformer = new Transformer(this, l);
        int currentObjectIndex = 0;
        Object lastArgument = null;
        boolean hasLastArgumentSet = false;
        while (formatBuffer.hasRemaining()) {
            String result;
            parser.reset();
            FormatToken token = parser.getNextFormatToken();
            String plainText = token.getPlainText();
            if (token.getConversionType() == '\uffff') {
                result = plainText;
            } else {
                plainText = plainText.substring(0, plainText.indexOf(37));
                Object argument = null;
                if (token.requireArgument()) {
                    int index = token.getArgIndex() == -1 ? currentObjectIndex++ : token.getArgIndex();
                    lastArgument = argument = this.getArgument(args, index, token, lastArgument, hasLastArgumentSet);
                    hasLastArgumentSet = true;
                }
                String string = result = null == (result = transformer.transform(token, argument)) ? plainText : plainText + result;
            }
            if (null == result) continue;
            try {
                Writer_.append(this.out, result);
            }
            catch (IOException e) {
                this.lastIOException = e;
            }
        }
        return this;
    }

    private Object getArgument(Object[] args, int index, FormatToken token, Object lastArgument, boolean hasLastArgumentSet) {
        if (index == -2 && !hasLastArgumentSet) {
            throw new MissingFormatArgumentException("<");
        }
        if (null == args) {
            return null;
        }
        if (index >= args.length) {
            throw new MissingFormatArgumentException(token.getPlainText());
        }
        if (index == -2) {
            return lastArgument;
        }
        return args[index];
    }

    private static void closeOutputStream(OutputStream os) {
        if (null == os) {
            return;
        }
        try {
            os.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class ParserStateMachine {
        private static final char EOS = '\uffff';
        private static final int EXIT_STATE = 0;
        private static final int ENTRY_STATE = 1;
        private static final int START_CONVERSION_STATE = 2;
        private static final int FLAGS_STATE = 3;
        private static final int WIDTH_STATE = 4;
        private static final int PRECISION_STATE = 5;
        private static final int CONVERSION_TYPE_STATE = 6;
        private static final int SUFFIX_STATE = 7;
        private FormatToken token;
        private int state = 1;
        private char currentChar = '\u0000';
        private CharBuffer format = null;

        ParserStateMachine(CharBuffer format) {
            this.format = format;
        }

        void reset() {
            this.currentChar = (char)65535;
            this.state = 1;
            this.token = null;
        }

        FormatToken getNextFormatToken() {
            this.token = new FormatToken();
            this.token.setFormatStringStartIndex(this.format.position());
            while (true) {
                if (0 != this.state) {
                    this.currentChar = this.getNextFormatChar();
                    if ('\uffff' == this.currentChar && 1 != this.state) {
                        throw new UnknownFormatConversionException(this.getFormatString());
                    }
                }
                switch (this.state) {
                    case 0: {
                        this.process_EXIT_STATE();
                        return this.token;
                    }
                    case 1: {
                        this.process_ENTRY_STATE();
                        break;
                    }
                    case 2: {
                        this.process_START_CONVERSION_STATE();
                        break;
                    }
                    case 3: {
                        this.process_FlAGS_STATE();
                        break;
                    }
                    case 4: {
                        this.process_WIDTH_STATE();
                        break;
                    }
                    case 5: {
                        this.process_PRECISION_STATE();
                        break;
                    }
                    case 6: {
                        this.process_CONVERSION_TYPE_STATE();
                        break;
                    }
                    case 7: {
                        this.process_SUFFIX_STATE();
                    }
                }
            }
        }

        private char getNextFormatChar() {
            if (this.format.hasRemaining()) {
                return this.format.get();
            }
            return '\uffff';
        }

        private String getFormatString() {
            int end = this.format.position();
            this.format.rewind();
            String formatString = ((Object)this.format.subSequence(this.token.getFormatStringStartIndex(), end)).toString();
            this.format.position(end);
            return formatString;
        }

        private void process_ENTRY_STATE() {
            if ('\uffff' == this.currentChar) {
                this.state = 0;
            } else if ('%' == this.currentChar) {
                this.state = 2;
            }
        }

        private void process_START_CONVERSION_STATE() {
            if (Character.isDigit(this.currentChar)) {
                int position = this.format.position() - 1;
                int number = this.parseInt(this.format);
                int nextChar = 0;
                if (this.format.hasRemaining()) {
                    nextChar = this.format.get();
                }
                if (36 == nextChar) {
                    int argIndex = number;
                    if (argIndex > 0) {
                        this.token.setArgIndex(argIndex - 1);
                    } else if (argIndex == -1) {
                        throw new MissingFormatArgumentException(this.getFormatString());
                    }
                    this.state = 3;
                } else if ('0' == this.currentChar) {
                    this.state = 3;
                    this.format.position(position);
                } else {
                    this.state = 4;
                    this.format.position(this.format.position() - 1);
                    this.token.setWidth(number);
                }
                this.currentChar = (char)nextChar;
            } else if ('<' == this.currentChar) {
                this.state = 3;
                this.token.setArgIndex(-2);
            } else {
                this.state = 3;
                this.format.position(this.format.position() - 1);
            }
        }

        private void process_FlAGS_STATE() {
            if (!this.token.setFlag(this.currentChar)) {
                if (Character.isDigit(this.currentChar)) {
                    this.token.setWidth(this.parseInt(this.format));
                    this.state = 4;
                } else if ('.' == this.currentChar) {
                    this.state = 5;
                } else {
                    this.state = 6;
                    this.format.position(this.format.position() - 1);
                }
            }
        }

        private void process_WIDTH_STATE() {
            if ('.' == this.currentChar) {
                this.state = 5;
            } else {
                this.state = 6;
                this.format.position(this.format.position() - 1);
            }
        }

        private void process_PRECISION_STATE() {
            if (!Character.isDigit(this.currentChar)) {
                throw new UnknownFormatConversionException(this.getFormatString());
            }
            this.token.setPrecision(this.parseInt(this.format));
            this.state = 6;
        }

        private void process_CONVERSION_TYPE_STATE() {
            this.token.setConversionType(this.currentChar);
            this.state = 't' == this.currentChar || 'T' == this.currentChar ? 7 : 0;
        }

        private void process_SUFFIX_STATE() {
            this.token.setDateSuffix(this.currentChar);
            this.state = 0;
        }

        private void process_EXIT_STATE() {
            this.token.setPlainText(this.getFormatString());
        }

        private int parseInt(CharBuffer buffer) {
            int start = buffer.position() - 1;
            int end = buffer.limit();
            while (buffer.hasRemaining()) {
                if (Character.isDigit(buffer.get())) continue;
                end = buffer.position() - 1;
                break;
            }
            buffer.position(0);
            String intStr = ((Object)buffer.subSequence(start, end)).toString();
            buffer.position(end);
            try {
                return Integer.parseInt(intStr);
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
    }

    private static class DateTimeUtil {
        private Calendar calendar;
        private Locale locale;
        private StringBuffer result;
        private DateFormatSymbols dateFormatSymbols;

        DateTimeUtil(Locale locale) {
            this.locale = locale;
        }

        void transform(FormatToken formatToken, Calendar aCalendar, StringBuffer aResult) {
            this.result = aResult;
            this.calendar = aCalendar;
            char suffix = formatToken.getDateSuffix();
            switch (suffix) {
                case 'H': {
                    this.transform_H();
                    break;
                }
                case 'I': {
                    this.transform_I();
                    break;
                }
                case 'M': {
                    this.transform_M();
                    break;
                }
                case 'S': {
                    this.transform_S();
                    break;
                }
                case 'L': {
                    this.transform_L();
                    break;
                }
                case 'N': {
                    this.transform_N();
                    break;
                }
                case 'k': {
                    this.transform_k();
                    break;
                }
                case 'l': {
                    this.transform_l();
                    break;
                }
                case 'p': {
                    this.transform_p(true);
                    break;
                }
                case 's': {
                    this.transform_s();
                    break;
                }
                case 'z': {
                    this.transform_z();
                    break;
                }
                case 'Z': {
                    this.transform_Z();
                    break;
                }
                case 'Q': {
                    this.transform_Q();
                    break;
                }
                case 'B': {
                    this.transform_B();
                    break;
                }
                case 'b': 
                case 'h': {
                    this.transform_b();
                    break;
                }
                case 'A': {
                    this.transform_A();
                    break;
                }
                case 'a': {
                    this.transform_a();
                    break;
                }
                case 'C': {
                    this.transform_C();
                    break;
                }
                case 'Y': {
                    this.transform_Y();
                    break;
                }
                case 'y': {
                    this.transform_y();
                    break;
                }
                case 'j': {
                    this.transform_j();
                    break;
                }
                case 'm': {
                    this.transform_m();
                    break;
                }
                case 'd': {
                    this.transform_d();
                    break;
                }
                case 'e': {
                    this.transform_e();
                    break;
                }
                case 'R': {
                    this.transform_R();
                    break;
                }
                case 'T': {
                    this.transform_T();
                    break;
                }
                case 'r': {
                    this.transform_r();
                    break;
                }
                case 'D': {
                    this.transform_D();
                    break;
                }
                case 'F': {
                    this.transform_F();
                    break;
                }
                case 'c': {
                    this.transform_c();
                    break;
                }
                default: {
                    throw new UnknownFormatConversionException(String.valueOf(formatToken.getConversionType()) + formatToken.getDateSuffix());
                }
            }
        }

        private void transform_e() {
            int day = this.calendar.get(5);
            this.result.append(day);
        }

        private void transform_d() {
            int day = this.calendar.get(5);
            this.result.append(DateTimeUtil.paddingZeros(day, 2));
        }

        private void transform_m() {
            int month = this.calendar.get(2);
            this.result.append(DateTimeUtil.paddingZeros(++month, 2));
        }

        private void transform_j() {
            int day = this.calendar.get(6);
            this.result.append(DateTimeUtil.paddingZeros(day, 3));
        }

        private void transform_y() {
            int year = this.calendar.get(1);
            this.result.append(DateTimeUtil.paddingZeros(year %= 100, 2));
        }

        private void transform_Y() {
            int year = this.calendar.get(1);
            this.result.append(DateTimeUtil.paddingZeros(year, 4));
        }

        private void transform_C() {
            int year = this.calendar.get(1);
            this.result.append(DateTimeUtil.paddingZeros(year /= 100, 2));
        }

        private void transform_a() {
            int day = this.calendar.get(7);
            this.result.append(this.getDateFormatSymbols().getShortWeekdays()[day]);
        }

        private void transform_A() {
            int day = this.calendar.get(7);
            this.result.append(this.getDateFormatSymbols().getWeekdays()[day]);
        }

        private void transform_b() {
            int month = this.calendar.get(2);
            this.result.append(this.getDateFormatSymbols().getShortMonths()[month]);
        }

        private void transform_B() {
            int month = this.calendar.get(2);
            this.result.append(this.getDateFormatSymbols().getMonths()[month]);
        }

        private void transform_Q() {
            long milliSeconds = this.calendar.getTimeInMillis();
            this.result.append(milliSeconds);
        }

        private void transform_s() {
            long milliSeconds = this.calendar.getTimeInMillis();
            this.result.append(milliSeconds /= 1000L);
        }

        private void transform_Z() {
            TimeZone timeZone = this.calendar.getTimeZone();
            this.result.append(timeZone.getDisplayName(true, 0, this.locale));
        }

        private void transform_z() {
            int zoneOffset = this.calendar.get(15);
            zoneOffset /= 3600000;
            if ((zoneOffset *= 100) >= 0) {
                this.result.append('+');
            }
            this.result.append(DateTimeUtil.paddingZeros(zoneOffset, 4));
        }

        private void transform_p(boolean isLowerCase) {
            int i = this.calendar.get(9);
            String s = this.getDateFormatSymbols().getAmPmStrings()[i];
            if (isLowerCase) {
                s = s.toLowerCase(this.locale);
            }
            this.result.append(s);
        }

        private void transform_N() {
            long nanosecond = (long)this.calendar.get(14) * 1000000L;
            this.result.append(DateTimeUtil.paddingZeros(nanosecond, 9));
        }

        private void transform_L() {
            int millisecond = this.calendar.get(14);
            this.result.append(DateTimeUtil.paddingZeros(millisecond, 3));
        }

        private void transform_S() {
            int second = this.calendar.get(13);
            this.result.append(DateTimeUtil.paddingZeros(second, 2));
        }

        private void transform_M() {
            int minute = this.calendar.get(12);
            this.result.append(DateTimeUtil.paddingZeros(minute, 2));
        }

        private void transform_l() {
            int hour = this.calendar.get(10);
            if (0 == hour) {
                hour = 12;
            }
            this.result.append(hour);
        }

        private void transform_k() {
            int hour = this.calendar.get(11);
            this.result.append(hour);
        }

        private void transform_I() {
            int hour = this.calendar.get(10);
            if (0 == hour) {
                hour = 12;
            }
            this.result.append(DateTimeUtil.paddingZeros(hour, 2));
        }

        private void transform_H() {
            int hour = this.calendar.get(11);
            this.result.append(DateTimeUtil.paddingZeros(hour, 2));
        }

        private void transform_R() {
            this.transform_H();
            this.result.append(':');
            this.transform_M();
        }

        private void transform_T() {
            this.transform_H();
            this.result.append(':');
            this.transform_M();
            this.result.append(':');
            this.transform_S();
        }

        private void transform_r() {
            this.transform_I();
            this.result.append(':');
            this.transform_M();
            this.result.append(':');
            this.transform_S();
            this.result.append(' ');
            this.transform_p(false);
        }

        private void transform_D() {
            this.transform_m();
            this.result.append('/');
            this.transform_d();
            this.result.append('/');
            this.transform_y();
        }

        private void transform_F() {
            this.transform_Y();
            this.result.append('-');
            this.transform_m();
            this.result.append('-');
            this.transform_d();
        }

        private void transform_c() {
            this.transform_a();
            this.result.append(' ');
            this.transform_b();
            this.result.append(' ');
            this.transform_d();
            this.result.append(' ');
            this.transform_T();
            this.result.append(' ');
            this.transform_Z();
            this.result.append(' ');
            this.transform_Y();
        }

        private static String paddingZeros(long number, int length) {
            int len = length;
            StringBuffer result = new StringBuffer();
            result.append(number);
            int startIndex = 0;
            if (number < 0L) {
                ++len;
                startIndex = 1;
            }
            if ((len -= result.length()) > 0) {
                char[] zeros = new char[len];
                Arrays.fill(zeros, '0');
                result.insert(startIndex, zeros);
            }
            return result.toString();
        }

        private DateFormatSymbols getDateFormatSymbols() {
            if (null == this.dateFormatSymbols) {
                this.dateFormatSymbols = new DateFormatSymbols(this.locale);
            }
            return this.dateFormatSymbols;
        }
    }

    private static class FloatUtil {
        private StringBuffer result;
        private DecimalFormat decimalFormat;
        private FormatToken formatToken;
        private Object argument;
        private char minusSign;

        FloatUtil(StringBuffer result, FormatToken formatToken, DecimalFormat decimalFormat, Object argument) {
            this.result = result;
            this.formatToken = formatToken;
            this.decimalFormat = decimalFormat;
            this.argument = argument;
            this.minusSign = decimalFormat.getDecimalFormatSymbols().getMinusSign();
        }

        void transform(FormatToken aFormatToken, StringBuffer aResult) {
            this.result = aResult;
            this.formatToken = aFormatToken;
            switch (this.formatToken.getConversionType()) {
                case 'E': 
                case 'e': {
                    this.transform_e();
                    break;
                }
                case 'f': {
                    this.transform_f();
                    break;
                }
                case 'G': 
                case 'g': {
                    this.transform_g();
                    break;
                }
                case 'A': 
                case 'a': {
                    this.transform_a();
                    break;
                }
                default: {
                    throw new UnknownFormatConversionException(String.valueOf(this.formatToken.getConversionType()));
                }
            }
        }

        char getMinusSign() {
            return this.minusSign;
        }

        char getAddSign() {
            return '+';
        }

        void transform_e() {
            StringBuffer pattern = new StringBuffer();
            pattern.append('0');
            if (this.formatToken.getPrecision() > 0) {
                pattern.append('.');
                char[] zeros = new char[this.formatToken.getPrecision()];
                Arrays.fill(zeros, '0');
                pattern.append(zeros);
            }
            pattern.append('E');
            pattern.append("+00");
            this.decimalFormat.applyPattern(pattern.toString());
            String formattedString = this.decimalFormat.format(this.argument);
            this.result.append(formattedString.replace('E', 'e'));
            if (this.formatToken.isFlagSet(2) && 0 == this.formatToken.getPrecision()) {
                int indexOfE = this.result.indexOf("e");
                char dot = this.decimalFormat.getDecimalFormatSymbols().getDecimalSeparator();
                this.result.insert(indexOfE, dot);
            }
        }

        void transform_g() {
            int precision = this.formatToken.getPrecision();
            precision = 0 == precision ? 1 : precision;
            this.formatToken.setPrecision(precision);
            if (0.0 == ((Number)this.argument).doubleValue()) {
                this.formatToken.setPrecision(--precision);
                this.transform_f();
                return;
            }
            boolean requireScientificRepresentation = true;
            double d = ((Number)this.argument).doubleValue();
            long l = Math.round(d = Math.abs(d));
            if (l >= 1L) {
                if ((double)l < Math.pow(10.0, precision)) {
                    requireScientificRepresentation = false;
                    if (String.valueOf(l = Math.round(d * Math.pow(10.0, (precision = (precision -= String.valueOf(l).length()) < 0 ? 0 : precision) + 1))).length() <= this.formatToken.getPrecision()) {
                        ++precision;
                    }
                    this.formatToken.setPrecision(precision);
                }
            } else {
                l = Math.round(d * Math.pow(10.0, 4.0));
                if (l >= 1L) {
                    requireScientificRepresentation = false;
                    if (String.valueOf(l = Math.round(d * Math.pow(10.0, (precision += 4 - String.valueOf(l).length()) + 1))).length() <= this.formatToken.getPrecision()) {
                        ++precision;
                    }
                    if ((double)(l = Math.round(d * Math.pow(10.0, precision))) < Math.pow(10.0, precision - 4)) {
                        requireScientificRepresentation = true;
                    } else {
                        this.formatToken.setPrecision(precision);
                    }
                }
            }
            if (requireScientificRepresentation) {
                precision = this.formatToken.getPrecision();
                this.formatToken.setPrecision(--precision);
                this.transform_e();
            } else {
                this.transform_f();
            }
        }

        void transform_f() {
            StringBuffer pattern = new StringBuffer();
            if (this.formatToken.isFlagSet(32)) {
                pattern.append(',');
                int groupingSize = this.decimalFormat.getGroupingSize();
                if (groupingSize > 1) {
                    char[] sharps = new char[groupingSize - 1];
                    Arrays.fill(sharps, '#');
                    pattern.append(sharps);
                }
            }
            pattern.append(0);
            if (this.formatToken.getPrecision() > 0) {
                pattern.append('.');
                char[] zeros = new char[this.formatToken.getPrecision()];
                Arrays.fill(zeros, '0');
                pattern.append(zeros);
            }
            this.decimalFormat.applyPattern(pattern.toString());
            this.result.append(this.decimalFormat.format(this.argument));
            if (this.formatToken.isFlagSet(2) && 0 == this.formatToken.getPrecision()) {
                char dot = this.decimalFormat.getDecimalFormatSymbols().getDecimalSeparator();
                this.result.append(dot);
            }
        }

        void transform_a() {
            char currentConversionType = this.formatToken.getConversionType();
            if (this.argument instanceof Float) {
                Float F = (Float)this.argument;
                this.result.append(Float_.toHexString(F.floatValue()));
            } else if (this.argument instanceof Double) {
                Double D = (Double)this.argument;
                this.result.append(Double_.toHexString(D));
            } else {
                throw new IllegalFormatConversionException(currentConversionType, this.argument.getClass());
            }
            if (!this.formatToken.isPrecisionSet()) {
                return;
            }
            int precision = this.formatToken.getPrecision();
            precision = 0 == precision ? 1 : precision;
            int indexOfFirstFracitoanlDigit = this.result.indexOf(".") + 1;
            int indexOfP = this.result.indexOf("p");
            int fractionalLength = indexOfP - indexOfFirstFracitoanlDigit;
            if (fractionalLength == precision) {
                return;
            }
            if (fractionalLength < precision) {
                char[] zeros = new char[precision - fractionalLength];
                Arrays.fill(zeros, '0');
                this.result.insert(indexOfP, zeros);
                return;
            }
            this.result.delete(indexOfFirstFracitoanlDigit + precision, indexOfP);
        }
    }

    private static class Transformer {
        private Formatter formatter;
        private FormatToken formatToken;
        private Object arg;
        private Locale locale;
        private static String lineSeparator;
        private NumberFormat numberFormat;
        private DecimalFormatSymbols decimalFormatSymbols;
        private DateTimeUtil dateTimeUtil;

        Transformer(Formatter formatter, Locale locale) {
            this.formatter = formatter;
            this.locale = null == locale ? Locale.US : locale;
        }

        private NumberFormat getNumberFormat() {
            if (null == this.numberFormat) {
                this.numberFormat = NumberFormat.getInstance(this.locale);
            }
            return this.numberFormat;
        }

        private DecimalFormatSymbols getDecimalFormatSymbols() {
            if (null == this.decimalFormatSymbols) {
                this.decimalFormatSymbols = new DecimalFormatSymbols(this.locale);
            }
            return this.decimalFormatSymbols;
        }

        String transform(FormatToken token, Object argument) {
            String result;
            this.formatToken = token;
            this.arg = argument;
            switch (token.getConversionType()) {
                case 'B': 
                case 'b': {
                    result = this.transformFromBoolean();
                    break;
                }
                case 'H': 
                case 'h': {
                    result = this.transformFromHashCode();
                    break;
                }
                case 'S': 
                case 's': {
                    result = this.transformFromString();
                    break;
                }
                case 'C': 
                case 'c': {
                    result = this.transformFromCharacter();
                    break;
                }
                case 'X': 
                case 'd': 
                case 'o': 
                case 'x': {
                    if (null == this.arg || this.arg instanceof BigInteger) {
                        result = this.transformFromBigInteger();
                        break;
                    }
                    result = this.transformFromInteger();
                    break;
                }
                case 'A': 
                case 'E': 
                case 'G': 
                case 'a': 
                case 'e': 
                case 'f': 
                case 'g': {
                    result = this.transformFromFloat();
                    break;
                }
                case '%': {
                    result = this.transformFromPercent();
                    break;
                }
                case 'n': {
                    result = this.transformFromLineSeparator();
                    break;
                }
                case 'T': 
                case 't': {
                    result = this.transformFromDateTime();
                    break;
                }
                default: {
                    throw new UnknownFormatConversionException(String.valueOf(token.getConversionType()));
                }
            }
            if (Character.isUpperCase(token.getConversionType()) && null != result) {
                result = result.toUpperCase(Locale.US);
            }
            return result;
        }

        private String transformFromBoolean() {
            StringBuffer result = new StringBuffer();
            int startIndex = 0;
            int flags = this.formatToken.getFlags();
            if (this.formatToken.isFlagSet(1) && !this.formatToken.isWidthSet()) {
                throw new MissingFormatWidthException("-" + this.formatToken.getConversionType());
            }
            if (0 != flags && 1 != flags) {
                throw new FormatFlagsConversionMismatchException(this.formatToken.getStrFlags(), this.formatToken.getConversionType());
            }
            if (null == this.arg) {
                result.append("false");
            } else if (this.arg instanceof Boolean) {
                result.append(this.arg);
            } else {
                result.append("true");
            }
            return this.padding(result, startIndex);
        }

        private String transformFromHashCode() {
            StringBuffer result = new StringBuffer();
            int startIndex = 0;
            int flags = this.formatToken.getFlags();
            if (this.formatToken.isFlagSet(1) && !this.formatToken.isWidthSet()) {
                throw new MissingFormatWidthException("-" + this.formatToken.getConversionType());
            }
            if (0 != flags && 1 != flags) {
                throw new FormatFlagsConversionMismatchException(this.formatToken.getStrFlags(), this.formatToken.getConversionType());
            }
            if (null == this.arg) {
                result.append("null");
            } else {
                result.append(Integer.toHexString(this.arg.hashCode()));
            }
            return this.padding(result, startIndex);
        }

        private String transformFromString() {
            StringBuffer result = new StringBuffer();
            int startIndex = 0;
            int flags = this.formatToken.getFlags();
            if (this.formatToken.isFlagSet(1) && !this.formatToken.isWidthSet()) {
                throw new MissingFormatWidthException("-" + this.formatToken.getConversionType());
            }
            if (this.arg instanceof Formattable) {
                int flag = 0;
                if (0 != (flags & 0xFFFFFFFE & 0xFFFFFFFD)) {
                    throw new IllegalFormatFlagsException(this.formatToken.getStrFlags());
                }
                if (this.formatToken.isFlagSet(1)) {
                    flag |= 1;
                }
                if (this.formatToken.isFlagSet(2)) {
                    flag |= 4;
                }
                if (Character.isUpperCase(this.formatToken.getConversionType())) {
                    flag |= 2;
                }
                ((Formattable)this.arg).formatTo(this.formatter, flag, this.formatToken.getWidth(), this.formatToken.getPrecision());
                return null;
            }
            if (0 != flags && 1 != flags) {
                throw new FormatFlagsConversionMismatchException(this.formatToken.getStrFlags(), this.formatToken.getConversionType());
            }
            result.append(this.arg);
            return this.padding(result, startIndex);
        }

        private String transformFromCharacter() {
            StringBuffer result = new StringBuffer();
            int startIndex = 0;
            int flags = this.formatToken.getFlags();
            if (this.formatToken.isFlagSet(1) && !this.formatToken.isWidthSet()) {
                throw new MissingFormatWidthException("-" + this.formatToken.getConversionType());
            }
            if (0 != flags && 1 != flags) {
                throw new FormatFlagsConversionMismatchException(this.formatToken.getStrFlags(), this.formatToken.getConversionType());
            }
            if (this.formatToken.isPrecisionSet()) {
                throw new IllegalFormatPrecisionException(this.formatToken.getPrecision());
            }
            if (null == this.arg) {
                result.append("null");
            } else if (this.arg instanceof Character) {
                result.append(this.arg);
            } else if (this.arg instanceof Byte) {
                byte b = (Byte)this.arg;
                if (!Character_.isValidCodePoint(b)) {
                    throw new IllegalFormatCodePointException(b);
                }
                result.append((char)b);
            } else if (this.arg instanceof Short) {
                short s = (Short)this.arg;
                if (!Character_.isValidCodePoint(s)) {
                    throw new IllegalFormatCodePointException(s);
                }
                result.append((char)s);
            } else if (this.arg instanceof Integer) {
                int codePoint = (Integer)this.arg;
                if (!Character_.isValidCodePoint(codePoint)) {
                    throw new IllegalFormatCodePointException(codePoint);
                }
                result.append(String.valueOf(Character_.toChars(codePoint)));
            } else {
                throw new IllegalFormatConversionException(this.formatToken.getConversionType(), this.arg.getClass());
            }
            return this.padding(result, startIndex);
        }

        private String transformFromPercent() {
            StringBuffer result = new StringBuffer("%");
            int startIndex = 0;
            int flags = this.formatToken.getFlags();
            if (this.formatToken.isFlagSet(1) && !this.formatToken.isWidthSet()) {
                throw new MissingFormatWidthException("-" + this.formatToken.getConversionType());
            }
            if (0 != flags && 1 != flags) {
                throw new FormatFlagsConversionMismatchException(this.formatToken.getStrFlags(), this.formatToken.getConversionType());
            }
            if (this.formatToken.isPrecisionSet()) {
                throw new IllegalFormatPrecisionException(this.formatToken.getPrecision());
            }
            return this.padding(result, startIndex);
        }

        private String transformFromLineSeparator() {
            if (this.formatToken.isPrecisionSet()) {
                throw new IllegalFormatPrecisionException(this.formatToken.getPrecision());
            }
            if (this.formatToken.isWidthSet()) {
                throw new IllegalFormatWidthException(this.formatToken.getWidth());
            }
            int flags = this.formatToken.getFlags();
            if (0 != flags) {
                throw new IllegalFormatFlagsException(this.formatToken.getStrFlags());
            }
            if (null == lineSeparator) {
                lineSeparator = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return System.getProperty("line.separator");
                    }
                });
            }
            return lineSeparator;
        }

        private String padding(StringBuffer source, int startIndex) {
            int start = startIndex;
            boolean paddingRight = this.formatToken.isFlagSet(1);
            char paddingChar = ' ';
            if (this.formatToken.isFlagSet(16)) {
                paddingChar = 'd' == this.formatToken.getConversionType() ? (char)this.getDecimalFormatSymbols().getZeroDigit() : (char)'0';
            } else {
                start = 0;
            }
            int width = this.formatToken.getWidth();
            int precision = this.formatToken.getPrecision();
            int length = source.length();
            if (precision >= 0) {
                length = Math.min(length, precision);
                source.delete(length, source.length());
            }
            if (width > 0) {
                width = Math.max(source.length(), width);
            }
            if (length >= width) {
                return source.toString();
            }
            char[] paddings = new char[width - length];
            Arrays.fill(paddings, paddingChar);
            String insertString = new String(paddings);
            if (paddingRight) {
                source.append(insertString);
            } else {
                source.insert(start, insertString);
            }
            return source.toString();
        }

        private String transformFromInteger() {
            long value;
            int startIndex = 0;
            boolean isNegative = false;
            StringBuffer result = new StringBuffer();
            char currentConversionType = this.formatToken.getConversionType();
            if ((this.formatToken.isFlagSet(1) || this.formatToken.isFlagSet(16)) && !this.formatToken.isWidthSet()) {
                throw new MissingFormatWidthException(this.formatToken.getStrFlags());
            }
            if (this.formatToken.isFlagSet(4) && this.formatToken.isFlagSet(8)) {
                throw new IllegalFormatFlagsException(this.formatToken.getStrFlags());
            }
            if (this.formatToken.isPrecisionSet()) {
                throw new IllegalFormatPrecisionException(this.formatToken.getPrecision());
            }
            if (this.arg instanceof Long) {
                value = (Long)this.arg;
            } else if (this.arg instanceof Integer) {
                value = ((Integer)this.arg).longValue();
            } else if (this.arg instanceof Short) {
                value = ((Short)this.arg).longValue();
            } else if (this.arg instanceof Byte) {
                value = ((Byte)this.arg).longValue();
            } else {
                throw new IllegalFormatConversionException(this.formatToken.getConversionType(), this.arg.getClass());
            }
            if ('d' != currentConversionType && (this.formatToken.isFlagSet(4) || this.formatToken.isFlagSet(8) || this.formatToken.isFlagSet(32) || this.formatToken.isFlagSet(64))) {
                throw new FormatFlagsConversionMismatchException(this.formatToken.getStrFlags(), this.formatToken.getConversionType());
            }
            if (this.formatToken.isFlagSet(2)) {
                if ('d' == currentConversionType) {
                    throw new FormatFlagsConversionMismatchException(this.formatToken.getStrFlags(), this.formatToken.getConversionType());
                }
                if ('o' == currentConversionType) {
                    result.append("0");
                    ++startIndex;
                } else {
                    result.append("0x");
                    startIndex += 2;
                }
            }
            if (this.formatToken.isFlagSet(1) && this.formatToken.isFlagSet(16)) {
                throw new IllegalFormatFlagsException(this.formatToken.getStrFlags());
            }
            if (value < 0L) {
                isNegative = true;
            }
            if ('d' == currentConversionType) {
                NumberFormat numberFormat = this.getNumberFormat();
                if (this.formatToken.isFlagSet(32)) {
                    numberFormat.setGroupingUsed(true);
                } else {
                    numberFormat.setGroupingUsed(false);
                }
                result.append(numberFormat.format(this.arg));
            } else {
                long BYTE_MASK = 255L;
                long SHORT_MASK = 65535L;
                long INT_MASK = 0xFFFFFFFFL;
                if (isNegative) {
                    if (this.arg instanceof Byte) {
                        value &= BYTE_MASK;
                    } else if (this.arg instanceof Short) {
                        value &= SHORT_MASK;
                    } else if (this.arg instanceof Integer) {
                        value &= INT_MASK;
                    }
                }
                if ('o' == currentConversionType) {
                    result.append(Long.toOctalString(value));
                } else {
                    result.append(Long.toHexString(value));
                }
                isNegative = false;
            }
            if (!isNegative) {
                if (this.formatToken.isFlagSet(4)) {
                    result.insert(0, '+');
                    ++startIndex;
                }
                if (this.formatToken.isFlagSet(8)) {
                    result.insert(0, ' ');
                    ++startIndex;
                }
            }
            if (isNegative && this.formatToken.isFlagSet(64)) {
                result = this.wrapParentheses(result);
                return result.toString();
            }
            if (isNegative && this.formatToken.isFlagSet(16)) {
                ++startIndex;
            }
            return this.padding(result, startIndex);
        }

        private StringBuffer wrapParentheses(StringBuffer result) {
            result.deleteCharAt(0);
            result.insert(0, '(');
            if (this.formatToken.isFlagSet(16)) {
                this.formatToken.setWidth(this.formatToken.getWidth() - 1);
                this.padding(result, 1);
                result.append(')');
            } else {
                result.append(')');
                this.padding(result, 0);
            }
            return result;
        }

        private String transformFromSpecialNumber() {
            String source = null;
            if (!(this.arg instanceof Number) || this.arg instanceof BigDecimal) {
                return null;
            }
            Number number = (Number)this.arg;
            double d = number.doubleValue();
            if (Double.isNaN(d)) {
                source = "NaN";
            } else if (Double.isInfinite(d)) {
                source = d >= 0.0 ? (this.formatToken.isFlagSet(4) ? "+Infinity" : (this.formatToken.isFlagSet(8) ? " Infinity" : "Infinity")) : (this.formatToken.isFlagSet(64) ? "(Infinity)" : "-Infinity");
            }
            if (null != source) {
                this.formatToken.setPrecision(-1);
                this.formatToken.setFlags(this.formatToken.getFlags() & 0xFFFFFFEF);
                source = this.padding(new StringBuffer(source), 0);
            }
            return source;
        }

        private String transformFromNull() {
            this.formatToken.setFlags(this.formatToken.getFlags() & 0xFFFFFFEF);
            return this.padding(new StringBuffer("null"), 0);
        }

        private String transformFromBigInteger() {
            int startIndex = 0;
            boolean isNegative = false;
            StringBuffer result = new StringBuffer();
            BigInteger bigInt = (BigInteger)this.arg;
            char currentConversionType = this.formatToken.getConversionType();
            if ((this.formatToken.isFlagSet(1) || this.formatToken.isFlagSet(16)) && !this.formatToken.isWidthSet()) {
                throw new MissingFormatWidthException(this.formatToken.getStrFlags());
            }
            if (this.formatToken.isFlagSet(4) && this.formatToken.isFlagSet(8)) {
                throw new IllegalFormatFlagsException(this.formatToken.getStrFlags());
            }
            if (this.formatToken.isFlagSet(16) && this.formatToken.isFlagSet(1)) {
                throw new IllegalFormatFlagsException(this.formatToken.getStrFlags());
            }
            if (this.formatToken.isPrecisionSet()) {
                throw new IllegalFormatPrecisionException(this.formatToken.getPrecision());
            }
            if ('d' != currentConversionType && this.formatToken.isFlagSet(32)) {
                throw new FormatFlagsConversionMismatchException(this.formatToken.getStrFlags(), currentConversionType);
            }
            if (this.formatToken.isFlagSet(2) && 'd' == currentConversionType) {
                throw new FormatFlagsConversionMismatchException(this.formatToken.getStrFlags(), currentConversionType);
            }
            if (null == bigInt) {
                return this.transformFromNull();
            }
            boolean bl = isNegative = bigInt.compareTo(BigInteger.ZERO) < 0;
            if ('d' == currentConversionType) {
                NumberFormat numberFormat = this.getNumberFormat();
                boolean readableName = this.formatToken.isFlagSet(32);
                numberFormat.setGroupingUsed(readableName);
                result.append(numberFormat.format(bigInt));
            } else if ('o' == currentConversionType) {
                result.append(bigInt.toString(8));
            } else {
                result.append(bigInt.toString(16));
            }
            if (this.formatToken.isFlagSet(2)) {
                int n = startIndex = isNegative ? 1 : 0;
                if ('o' == currentConversionType) {
                    result.insert(startIndex, "0");
                    ++startIndex;
                } else if ('x' == currentConversionType || 'X' == currentConversionType) {
                    result.insert(startIndex, "0x");
                    startIndex += 2;
                }
            }
            if (!isNegative) {
                if (this.formatToken.isFlagSet(4)) {
                    result.insert(0, '+');
                    ++startIndex;
                }
                if (this.formatToken.isFlagSet(8)) {
                    result.insert(0, ' ');
                    ++startIndex;
                }
            }
            if (isNegative && this.formatToken.isFlagSet(64)) {
                result = this.wrapParentheses(result);
                return result.toString();
            }
            if (isNegative && this.formatToken.isFlagSet(16)) {
                ++startIndex;
            }
            return this.padding(result, startIndex);
        }

        private String transformFromFloat() {
            StringBuffer result = new StringBuffer();
            int startIndex = 0;
            char currentConversionType = this.formatToken.getConversionType();
            if (this.formatToken.isFlagSet(17) && !this.formatToken.isWidthSet()) {
                throw new MissingFormatWidthException(this.formatToken.getStrFlags());
            }
            if (this.formatToken.isFlagSet(4) && this.formatToken.isFlagSet(8)) {
                throw new IllegalFormatFlagsException(this.formatToken.getStrFlags());
            }
            if (this.formatToken.isFlagSet(1) && this.formatToken.isFlagSet(16)) {
                throw new IllegalFormatFlagsException(this.formatToken.getStrFlags());
            }
            if ('e' == Character.toLowerCase(currentConversionType) && this.formatToken.isFlagSet(32)) {
                throw new FormatFlagsConversionMismatchException(this.formatToken.getStrFlags(), currentConversionType);
            }
            if ('g' == Character.toLowerCase(currentConversionType) && this.formatToken.isFlagSet(2)) {
                throw new FormatFlagsConversionMismatchException(this.formatToken.getStrFlags(), currentConversionType);
            }
            if ('a' == Character.toLowerCase(currentConversionType) && (this.formatToken.isFlagSet(32) || this.formatToken.isFlagSet(64))) {
                throw new FormatFlagsConversionMismatchException(this.formatToken.getStrFlags(), currentConversionType);
            }
            if (null == this.arg) {
                return this.transformFromNull();
            }
            if (!(this.arg instanceof Float || this.arg instanceof Double || this.arg instanceof BigDecimal)) {
                throw new IllegalFormatConversionException(currentConversionType, this.arg.getClass());
            }
            String specialNumberResult = this.transformFromSpecialNumber();
            if (null != specialNumberResult) {
                return specialNumberResult;
            }
            if ('a' != Character.toLowerCase(currentConversionType)) {
                this.formatToken.setPrecision(this.formatToken.isPrecisionSet() ? this.formatToken.getPrecision() : 6);
            }
            FloatUtil floatUtil = new FloatUtil(result, this.formatToken, (DecimalFormat)NumberFormat.getInstance(this.locale), this.arg);
            floatUtil.transform(this.formatToken, result);
            this.formatToken.setPrecision(-1);
            if (this.getDecimalFormatSymbols().getMinusSign() == result.charAt(0)) {
                if (this.formatToken.isFlagSet(64)) {
                    result = this.wrapParentheses(result);
                    return result.toString();
                }
            } else {
                if (this.formatToken.isFlagSet(8)) {
                    result.insert(0, ' ');
                    ++startIndex;
                }
                if (this.formatToken.isFlagSet(4)) {
                    result.insert(0, floatUtil.getAddSign());
                    ++startIndex;
                }
            }
            char firstChar = result.charAt(0);
            if (this.formatToken.isFlagSet(16) && (firstChar == floatUtil.getAddSign() || firstChar == floatUtil.getMinusSign())) {
                startIndex = 1;
            }
            if ('a' == Character.toLowerCase(currentConversionType)) {
                startIndex += 2;
            }
            return this.padding(result, startIndex);
        }

        private String transformFromDateTime() {
            Calendar calendar;
            int startIndex = 0;
            char currentConversionType = this.formatToken.getConversionType();
            if (this.formatToken.isPrecisionSet()) {
                throw new IllegalFormatPrecisionException(this.formatToken.getPrecision());
            }
            if (this.formatToken.isFlagSet(2)) {
                throw new FormatFlagsConversionMismatchException(this.formatToken.getStrFlags(), currentConversionType);
            }
            if (this.formatToken.isFlagSet(1) && -1 == this.formatToken.getWidth()) {
                throw new MissingFormatWidthException("-" + currentConversionType);
            }
            if (null == this.arg) {
                return this.transformFromNull();
            }
            if (this.arg instanceof Calendar) {
                calendar = (Calendar)this.arg;
            } else {
                Date date = null;
                if (this.arg instanceof Long) {
                    date = new Date((Long)this.arg);
                } else if (this.arg instanceof Date) {
                    date = (Date)this.arg;
                } else {
                    throw new IllegalFormatConversionException(currentConversionType, this.arg.getClass());
                }
                calendar = Calendar.getInstance(this.locale);
                calendar.setTime(date);
            }
            if (null == this.dateTimeUtil) {
                this.dateTimeUtil = new DateTimeUtil(this.locale);
            }
            StringBuffer result = new StringBuffer();
            this.dateTimeUtil.transform(this.formatToken, calendar, result);
            return this.padding(result, startIndex);
        }
    }

    private static class FormatToken {
        static final int LAST_ARGUMENT_INDEX = -2;
        static final int UNSET = -1;
        static final int FLAGS_UNSET = 0;
        static final int DEFAULT_PRECISION = 6;
        static final int FLAG_MINUS = 1;
        static final int FLAG_SHARP = 2;
        static final int FLAG_ADD = 4;
        static final int FLAG_SPACE = 8;
        static final int FLAG_ZERO = 16;
        static final int FLAG_COMMA = 32;
        static final int FLAG_PARENTHESIS = 64;
        private static final int FLAGT_TYPE_COUNT = 6;
        private int formatStringStartIndex;
        private String plainText;
        private int argIndex = -1;
        private int flags = 0;
        private int width = -1;
        private int precision = -1;
        private StringBuffer strFlags = new StringBuffer(6);
        private char dateSuffix;
        private char conversionType = (char)65535;

        private FormatToken() {
        }

        boolean isPrecisionSet() {
            return this.precision != -1;
        }

        boolean isWidthSet() {
            return this.width != -1;
        }

        boolean isFlagSet(int flag) {
            return 0 != (this.flags & flag);
        }

        int getArgIndex() {
            return this.argIndex;
        }

        void setArgIndex(int index) {
            this.argIndex = index;
        }

        String getPlainText() {
            return this.plainText;
        }

        void setPlainText(String plainText) {
            this.plainText = plainText;
        }

        int getWidth() {
            return this.width;
        }

        void setWidth(int width) {
            this.width = width;
        }

        int getPrecision() {
            return this.precision;
        }

        void setPrecision(int precise) {
            this.precision = precise;
        }

        String getStrFlags() {
            return this.strFlags.toString();
        }

        int getFlags() {
            return this.flags;
        }

        void setFlags(int flags) {
            this.flags = flags;
        }

        boolean setFlag(char c) {
            int newFlag;
            switch (c) {
                case '-': {
                    newFlag = 1;
                    break;
                }
                case '#': {
                    newFlag = 2;
                    break;
                }
                case '+': {
                    newFlag = 4;
                    break;
                }
                case ' ': {
                    newFlag = 8;
                    break;
                }
                case '0': {
                    newFlag = 16;
                    break;
                }
                case ',': {
                    newFlag = 32;
                    break;
                }
                case '(': {
                    newFlag = 64;
                    break;
                }
                default: {
                    return false;
                }
            }
            if (0 != (this.flags & newFlag)) {
                throw new DuplicateFormatFlagsException(String.valueOf(c));
            }
            this.flags |= newFlag;
            this.strFlags.append(c);
            return true;
        }

        int getFormatStringStartIndex() {
            return this.formatStringStartIndex;
        }

        void setFormatStringStartIndex(int index) {
            this.formatStringStartIndex = index;
        }

        char getConversionType() {
            return this.conversionType;
        }

        void setConversionType(char c) {
            this.conversionType = c;
        }

        char getDateSuffix() {
            return this.dateSuffix;
        }

        void setDateSuffix(char c) {
            this.dateSuffix = c;
        }

        boolean requireArgument() {
            return this.conversionType != '%' && this.conversionType != 'n';
        }
    }

    /*
     * This class specifies class file version 46.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class BigDecimalLayoutForm
    extends Enum<BigDecimalLayoutForm> {
        public static final /* enum */ BigDecimalLayoutForm SCIENTIFIC = new BigDecimalLayoutForm("SCIENTIFIC", 0);
        public static final /* enum */ BigDecimalLayoutForm DECIMAL_FLOAT = new BigDecimalLayoutForm("DECIMAL_FLOAT", 1);
        private static final /* synthetic */ BigDecimalLayoutForm[] $VALUES;
        private static final /* synthetic */ long serialVersionUID = 0L;
        private static final /* synthetic */ Class class$net$sourceforge$retroweaver$harmony$runtime$java$util$Formatter$BigDecimalLayoutForm;

        public static BigDecimalLayoutForm[] values() {
            return (BigDecimalLayoutForm[])$VALUES.clone();
        }

        public static BigDecimalLayoutForm valueOf(String name) {
            Class<?> clazz = class$net$sourceforge$retroweaver$harmony$runtime$java$util$Formatter$BigDecimalLayoutForm;
            if (clazz == null) {
                clazz = class$net$sourceforge$retroweaver$harmony$runtime$java$util$Formatter$BigDecimalLayoutForm = new BigDecimalLayoutForm[0].getClass().getComponentType();
            }
            return (BigDecimalLayoutForm)Enum.valueOf(clazz, name);
        }

        private BigDecimalLayoutForm(String string, int n) {
            super(string, n);
        }

        static {
            $VALUES = new BigDecimalLayoutForm[]{SCIENTIFIC, DECIMAL_FLOAT};
            Object[] objectArray = BigDecimalLayoutForm.values();
            Class<?> clazz = class$net$sourceforge$retroweaver$harmony$runtime$java$util$Formatter$BigDecimalLayoutForm;
            if (clazz == null) {
                clazz = class$net$sourceforge$retroweaver$harmony$runtime$java$util$Formatter$BigDecimalLayoutForm = new BigDecimalLayoutForm[0].getClass().getComponentType();
            }
            Enum.setEnumValues(objectArray, clazz);
        }
    }
}

