/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.table.internal;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.sourceforge.pmd.lang.java.types.JClassType;
import net.sourceforge.pmd.util.IteratorUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

public enum SuperTypesEnumerator {
    JUST_SELF{

        @Override
        public Iterator<JClassType> iterator(JClassType t) {
            return IteratorUtil.singletonIterator((Object)t);
        }
    }
    ,
    SUPERCLASSES_AND_SELF{

        @Override
        public Iterator<JClassType> iterator(JClassType t) {
            return IteratorUtil.generate((Object)t, JClassType::getSuperClass);
        }
    }
    ,
    DIRECT_STRICT_SUPERTYPES{

        @Override
        public Iterator<JClassType> iterator(JClassType t) {
            return this.iterable(t).iterator();
        }

        @Override
        public Iterable<JClassType> iterable(JClassType t) {
            LinkedHashSet<JClassType> set;
            @Nullable JClassType sup = t.getSuperClass();
            List<JClassType> superItfs = t.getSuperInterfaces();
            if (sup != null) {
                set = new LinkedHashSet<JClassType>(superItfs.size() + 1);
                set.add(sup);
            } else {
                if (superItfs.isEmpty()) {
                    return Collections.emptySet();
                }
                set = new LinkedHashSet(superItfs.size());
            }
            set.addAll(superItfs);
            return set;
        }
    }
    ,
    ALL_STRICT_SUPERTYPES{

        @Override
        public Iterator<JClassType> iterator(JClassType t) {
            Iterator<JClassType> iter = ALL_SUPERTYPES_INCLUDING_SELF.iterator(t);
            IteratorUtil.advance(iter, (int)1);
            return iter;
        }
    }
    ,
    ALL_SUPERTYPES_INCLUDING_SELF{

        @Override
        public Iterator<JClassType> iterator(JClassType t) {
            return new SuperTypeWalker(t);
        }
    };


    public abstract Iterator<JClassType> iterator(JClassType var1);

    public Stream<JClassType> stream(JClassType t) {
        return StreamSupport.stream(this.iterable(t).spliterator(), false);
    }

    public Iterable<JClassType> iterable(JClassType t) {
        return () -> this.iterator(t);
    }

    private static class SuperTypeWalker
    extends IteratorUtil.AbstractIterator<JClassType> {
        final Set<JClassType> seen = new HashSet<JClassType>();
        final Deque<JClassType> todo = new ArrayDeque<JClassType>(2);

        SuperTypeWalker(JClassType start) {
            this.todo.push(start);
        }

        protected void computeNext() {
            if (this.todo.isEmpty()) {
                this.done();
            } else {
                JClassType top = this.todo.pollFirst();
                this.setNext(top);
                this.enqueue(top);
            }
        }

        private void enqueue(JClassType c) {
            JClassType sup = c.getSuperClass();
            if (sup != null && this.seen.add(sup)) {
                this.todo.addFirst(sup);
            }
            for (JClassType iface : c.getSuperInterfaces()) {
                if (!this.seen.add(iface)) continue;
                this.todo.addLast(iface);
            }
        }
    }
}

