/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types.internal.infer.ast;

import java.util.Collections;
import java.util.List;
import net.sourceforge.pmd.lang.java.ast.ASTAssignmentExpression;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorCall;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaExpression;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaParameter;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaParameterList;
import net.sourceforge.pmd.lang.java.ast.ASTMethodCall;
import net.sourceforge.pmd.lang.java.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.java.ast.ASTThrowStatement;
import net.sourceforge.pmd.lang.java.ast.ASTUnaryExpression;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.symbols.JVariableSymbol;
import net.sourceforge.pmd.lang.java.types.JMethodSig;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.TypingContext;
import net.sourceforge.pmd.lang.java.types.internal.infer.ExprMirror;
import net.sourceforge.pmd.lang.java.types.internal.infer.ast.BaseFunctionalMirror;
import net.sourceforge.pmd.lang.java.types.internal.infer.ast.JavaExprMirrors;
import net.sourceforge.pmd.util.AssertionUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

class LambdaMirrorImpl
extends BaseFunctionalMirror<ASTLambdaExpression>
implements ExprMirror.LambdaExprMirror {
    private final List<JVariableSymbol> formalSymbols;

    LambdaMirrorImpl(JavaExprMirrors mirrors, ASTLambdaExpression lambda, @Nullable ExprMirror parent, JavaExprMirrors.MirrorMaker subexprMaker) {
        super(mirrors, lambda, parent, subexprMaker);
        if (this.isExplicitlyTyped()) {
            this.formalSymbols = Collections.emptyList();
        } else {
            this.formalSymbols = ((ASTLambdaExpression)this.myNode).getParameters().toStream().toList(p -> (JVariableSymbol)p.getVarId().getSymbol());
            TypingContext parentCtx = parent == null ? TypingContext.DEFAULT : parent.getTypingContext();
            List<Object> unknownFormals = Collections.nCopies(this.formalSymbols.size(), null);
            this.setTypingContext(parentCtx.andThenZip(this.formalSymbols, unknownFormals));
        }
    }

    @Override
    public boolean isEquivalentToUnderlyingAst() {
        JTypeMirror inferredType = this.getInferredType();
        JMethodSig inferredMethod = this.getInferredMethod();
        AssertionUtil.validateState((inferredType != null && inferredMethod != null ? 1 : 0) != 0, (String)"overload resolution is not complete");
        ASTLambdaParameterList astFormals = ((ASTLambdaExpression)this.myNode).getParameters();
        List<JTypeMirror> thisFormals = inferredMethod.getFormalParameters();
        for (int i = 0; i < thisFormals.size(); ++i) {
            if (thisFormals.get(i).equals(((ASTLambdaParameter)astFormals.get(i)).getTypeMirror())) continue;
            return false;
        }
        return true;
    }

    @Override
    public @Nullable List<JTypeMirror> getExplicitParameterTypes() {
        ASTLambdaParameterList parameters = ((ASTLambdaExpression)this.myNode).getParameters();
        if (parameters.size() == 0) {
            return Collections.emptyList();
        }
        List types = parameters.toStream().map(ASTLambdaParameter::getTypeNode).toList(TypeNode::getTypeMirror);
        return types.isEmpty() ? null : types;
    }

    @Override
    public int getParamCount() {
        return ((ASTLambdaExpression)this.myNode).getParameters().size();
    }

    public List<ExprMirror> getResultExpressions() {
        ASTBlock block = ((ASTLambdaExpression)this.myNode).getBlockBody();
        if (block == null) {
            return Collections.singletonList(this.createSubexpression(((ASTLambdaExpression)this.myNode).getExpressionBody()));
        }
        return block.descendants(ASTReturnStatement.class).map(ASTReturnStatement::getExpr).toList(this::createSubexpression);
    }

    @Override
    public void updateTypingContext(JMethodSig groundFun) {
        if (!this.isExplicitlyTyped()) {
            this.setTypingContext(this.getTypingContext().andThenZip(this.formalSymbols, groundFun.getFormalParameters()));
        }
    }

    @Override
    public boolean isValueCompatible() {
        ASTBlock block = ((ASTLambdaExpression)this.myNode).getBlockBody();
        return block == null || LambdaMirrorImpl.isLambdaBodyCompatible(block, false);
    }

    @Override
    public boolean isVoidCompatible() {
        ASTBlock block = ((ASTLambdaExpression)this.myNode).getBlockBody();
        if (block == null) {
            return LambdaMirrorImpl.isExpressionStatement(((ASTLambdaExpression)this.myNode).getExpressionBody());
        }
        return LambdaMirrorImpl.isLambdaBodyCompatible(block, true);
    }

    private static boolean isLambdaBodyCompatible(ASTBlock body, boolean voidCompatible) {
        boolean noReturnsWithExpr = body.descendants(ASTReturnStatement.class).none(it -> it.getExpr() != null);
        if (noReturnsWithExpr && !voidCompatible) {
            return body.descendants(ASTThrowStatement.class).nonEmpty();
        }
        return noReturnsWithExpr == voidCompatible;
    }

    private static boolean isExpressionStatement(ASTExpression body) {
        return body instanceof ASTMethodCall || body instanceof ASTConstructorCall || body instanceof ASTAssignmentExpression || body instanceof ASTUnaryExpression && !((ASTUnaryExpression)body).getOperator().isPure();
    }
}

