/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types;

import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.JExecutableSymbol;
import net.sourceforge.pmd.lang.java.symbols.JFieldSymbol;
import net.sourceforge.pmd.lang.java.symbols.JMethodSymbol;
import net.sourceforge.pmd.lang.java.symbols.SymbolicValue;
import net.sourceforge.pmd.lang.java.symbols.table.internal.SuperTypesEnumerator;
import net.sourceforge.pmd.lang.java.types.ClassMethodSigImpl;
import net.sourceforge.pmd.lang.java.types.ErasedClassType;
import net.sourceforge.pmd.lang.java.types.JClassType;
import net.sourceforge.pmd.lang.java.types.JMethodSig;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.JTypeVar;
import net.sourceforge.pmd.lang.java.types.JVariableSig;
import net.sourceforge.pmd.lang.java.types.Substitution;
import net.sourceforge.pmd.lang.java.types.TypeOps;
import net.sourceforge.pmd.lang.java.types.TypePrettyPrint;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import net.sourceforge.pmd.util.CollectionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.pcollections.HashTreePSet;
import org.pcollections.PSet;

class ClassTypeImpl
implements JClassType {
    private final @Nullable JClassType enclosingType;
    private final JClassSymbol symbol;
    private final TypeSystem ts;
    private final List<JTypeMirror> typeArgs;
    private final PSet<SymbolicValue.SymAnnot> typeAnnotations;
    private final TypeGenericity genericity;
    private JClassType superClass;
    private List<JClassType> interfaces;
    private Substitution subst;
    private int hash = 0;

    ClassTypeImpl(TypeSystem ts, JClassSymbol symbol, List<JTypeMirror> typeArgs, boolean isRaw, PSet<SymbolicValue.SymAnnot> typeAnnotations) {
        this(ts, null, symbol, typeArgs, typeAnnotations, isRaw);
    }

    private ClassTypeImpl(TypeSystem ts, JClassType enclosing, JClassSymbol symbol, List<JTypeMirror> typeArgs, PSet<SymbolicValue.SymAnnot> typeAnnotations, boolean isRaw) {
        this.typeAnnotations = typeAnnotations;
        ClassTypeImpl.validateParams(enclosing, symbol, typeArgs);
        this.ts = ts;
        this.symbol = symbol;
        this.typeArgs = typeArgs;
        this.enclosingType = enclosing != null ? enclosing : this.makeEnclosingOf(symbol);
        this.genericity = this.computeGenericity(isRaw);
    }

    protected ClassTypeImpl(TypeSystem ts, JClassSymbol symbol, PSet<SymbolicValue.SymAnnot> typeAnnotations) {
        this.typeAnnotations = typeAnnotations;
        this.ts = ts;
        this.symbol = symbol;
        this.typeArgs = CollectionUtil.emptyList();
        this.enclosingType = null;
        this.genericity = TypeGenericity.NON_GENERIC;
    }

    private @NonNull TypeGenericity computeGenericity(boolean isRaw) {
        boolean isGeneric = this.symbol.isGeneric();
        if (this.enclosingType != null && this.enclosingType.isRaw()) {
            return TypeGenericity.RAW;
        }
        if (this.typeArgs.isEmpty()) {
            if (isGeneric && isRaw) {
                return TypeGenericity.RAW;
            }
            if (isGeneric) {
                return TypeGenericity.GENERIC_TYPEDECL;
            }
            return TypeGenericity.NON_GENERIC;
        }
        return TypeGenericity.GENERIC_PARAMETERIZED;
    }

    private JClassType makeEnclosingOf(JClassSymbol sym) {
        if (Modifier.isStatic(sym.getModifiers())) {
            return null;
        }
        JClassSymbol enclosing = sym.getEnclosingClass();
        if (enclosing == null) {
            return null;
        }
        if (this.hasErasedSuperTypes()) {
            return this.ts.erasedType(enclosing);
        }
        return (JClassType)this.ts.typeOf(enclosing, false);
    }

    @Override
    public TypeSystem getTypeSystem() {
        return this.ts;
    }

    @Override
    public PSet<SymbolicValue.SymAnnot> getTypeAnnotations() {
        return this.typeAnnotations;
    }

    @Override
    public JClassType withAnnotations(PSet<SymbolicValue.SymAnnot> newTypeAnnots) {
        if (newTypeAnnots.isEmpty() && this.typeAnnotations.isEmpty()) {
            return this;
        }
        return new ClassTypeImpl(this.ts, this.enclosingType, this.symbol, this.typeArgs, newTypeAnnots, this.isRaw());
    }

    @Override
    public List<JTypeVar> getFormalTypeParams() {
        return this.symbol.getTypeParameters();
    }

    @Override
    public Substitution getTypeParamSubst() {
        if (this.subst == null) {
            Substitution enclSubst = this.getEnclosingType() == null ? Substitution.EMPTY : this.getEnclosingType().getTypeParamSubst();
            this.subst = enclSubst.andThen(this.localSubst());
        }
        return this.subst;
    }

    private Substitution localSubst() {
        if (this.hasErasedSuperTypes()) {
            return Substitution.erasing(this.getFormalTypeParams());
        }
        if (this.isGenericTypeDeclaration() || !this.isGeneric()) {
            return Substitution.EMPTY;
        }
        return Substitution.mapping(this.getFormalTypeParams(), this.getTypeArgs());
    }

    static JTypeMirror eraseToRaw(JTypeMirror t, Substitution typeSubst) {
        if (TypeOps.mentionsAny(t, typeSubst.getMap().keySet())) {
            return t.getErasure();
        }
        return t;
    }

    static JTypeMirror maybeEraseMemberType(JClassType owner, JTypeMirror t) {
        if (owner.isRaw() && TypeOps.mentionsAny(t, owner.getTypeParamSubst().getMap().keySet())) {
            return t.getErasure();
        }
        return t;
    }

    static List<JTypeMirror> maybeEraseMemberType(JClassType owner, List<JTypeMirror> ts) {
        if (owner.isRaw()) {
            return CollectionUtil.map(ts, t -> ClassTypeImpl.maybeEraseMemberType(owner, t));
        }
        return ts;
    }

    @Override
    public final JClassType selectInner(JClassSymbol symbol, List<? extends JTypeMirror> targs, PSet<SymbolicValue.SymAnnot> typeAnnotations) {
        return new ClassTypeImpl(this.ts, this, symbol, CollectionUtil.defensiveUnmodifiableCopy(targs), typeAnnotations, this.isRaw());
    }

    @Override
    public final boolean isRaw() {
        return this.genericity == TypeGenericity.RAW;
    }

    @Override
    public final boolean isGenericTypeDeclaration() {
        return this.genericity == TypeGenericity.GENERIC_TYPEDECL;
    }

    @Override
    public final boolean isParameterizedType() {
        return this.genericity == TypeGenericity.GENERIC_PARAMETERIZED;
    }

    @Override
    public final boolean isGeneric() {
        return this.genericity != TypeGenericity.NON_GENERIC;
    }

    @Override
    public JClassType getGenericTypeDeclaration() {
        if (this.isGenericTypeDeclaration() || !this.isGeneric()) {
            return this;
        }
        return new ClassTypeImpl(this.ts, this.symbol, CollectionUtil.emptyList(), false, this.typeAnnotations);
    }

    @Override
    public List<JTypeMirror> getTypeArgs() {
        return this.isGenericTypeDeclaration() ? this.getFormalTypeParams() : this.typeArgs;
    }

    @Override
    public @Nullable JClassType getEnclosingType() {
        return this.enclosingType;
    }

    @Override
    public boolean hasErasedSuperTypes() {
        return this.isRaw();
    }

    @Override
    public JClassType getErasure() {
        if ((!this.isGeneric() || this.isRaw()) && this.enclosingType == null) {
            return this;
        }
        return new ErasedClassType(this.ts, this.symbol, this.typeAnnotations);
    }

    @Override
    public JClassType withTypeArguments(List<? extends JTypeMirror> typeArgs) {
        if (this.enclosingType != null) {
            return this.enclosingType.selectInner(this.symbol, typeArgs, this.typeAnnotations);
        }
        int expected = this.symbol.getTypeParameterCount();
        if (expected == 0 && typeArgs.isEmpty() && this.typeArgs.isEmpty()) {
            return this;
        }
        return new ClassTypeImpl(this.ts, this.symbol, CollectionUtil.defensiveUnmodifiableCopy(typeArgs), true, this.typeAnnotations);
    }

    @Override
    public @Nullable JClassType getSuperClass() {
        if (this.superClass == null && !this.isTop()) {
            this.superClass = this.hasErasedSuperTypes() ? this.ts.erasedType(this.symbol.getSuperclass()) : this.symbol.getSuperclassType(this.getTypeParamSubst());
        }
        return this.superClass;
    }

    @Override
    public List<JClassType> getSuperInterfaces() {
        if (this.interfaces == null) {
            this.interfaces = this.hasErasedSuperTypes() ? CollectionUtil.map(this.symbol.getSuperInterfaces(), this.ts::erasedType) : this.symbol.getSuperInterfaceTypes(this.getTypeParamSubst());
        }
        return this.interfaces;
    }

    @Override
    public List<JVariableSig.FieldSig> getDeclaredFields() {
        return CollectionUtil.map(this.symbol.getDeclaredFields(), it -> JVariableSig.forField(this, it));
    }

    @Override
    public List<JClassType> getDeclaredClasses() {
        return CollectionUtil.map(this.symbol.getDeclaredClasses(), this::getDeclaredClass);
    }

    private JClassType getDeclaredClass(JClassSymbol inner) {
        if (Modifier.isStatic(inner.getModifiers())) {
            return new ClassTypeImpl(this.ts, null, inner, CollectionUtil.emptyList(), this.typeAnnotations, this.isRaw());
        }
        return this.selectInner(inner, CollectionUtil.emptyList());
    }

    @Override
    public @Nullable JVariableSig.FieldSig getDeclaredField(String simpleName) {
        @Nullable JFieldSymbol declaredField = this.symbol.getDeclaredField(simpleName);
        if (declaredField != null) {
            return JVariableSig.forField(this, declaredField);
        }
        return null;
    }

    @Override
    public @Nullable JClassType getDeclaredClass(String simpleName) {
        JClassSymbol declaredClass = this.symbol.getDeclaredClass(simpleName);
        if (declaredClass != null) {
            if (Modifier.isStatic(declaredClass.getModifiers())) {
                return new ClassTypeImpl(this.ts, null, declaredClass, CollectionUtil.emptyList(), (PSet<SymbolicValue.SymAnnot>)HashTreePSet.empty(), this.isRaw());
            }
            return this.selectInner(declaredClass, CollectionUtil.emptyList());
        }
        return null;
    }

    @Override
    public List<JMethodSig> getConstructors() {
        return CollectionUtil.map(this.symbol.getConstructors(), it -> new ClassMethodSigImpl(this, (JExecutableSymbol)it));
    }

    @Override
    public Stream<JMethodSig> streamMethods(Predicate<? super JMethodSymbol> prefilter) {
        return SuperTypesEnumerator.ALL_SUPERTYPES_INCLUDING_SELF.stream(this).flatMap(sup -> sup.streamDeclaredMethods(prefilter));
    }

    @Override
    public Stream<JMethodSig> streamDeclaredMethods(Predicate<? super JMethodSymbol> prefilter) {
        return this.getSymbol().getDeclaredMethods().stream().filter(prefilter).map(m -> new ClassMethodSigImpl(this, (JExecutableSymbol)m));
    }

    @Override
    public @Nullable JMethodSig getDeclaredMethod(JExecutableSymbol sym) {
        if (sym.getEnclosingClass().equals(this.getSymbol())) {
            return new ClassMethodSigImpl(this, sym);
        }
        return null;
    }

    @Override
    public final @NonNull JClassSymbol getSymbol() {
        return this.symbol;
    }

    @Override
    public final boolean isTop() {
        return this.getSymbol().equals(this.ts.OBJECT.getSymbol());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JClassType)) {
            return false;
        }
        JClassType that = (JClassType)o;
        return TypeOps.isSameType(this, that);
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.typeArgs.hashCode() * 31 + this.symbol.hashCode();
        }
        return this.hash;
    }

    @Override
    public String toString() {
        return TypePrettyPrint.prettyPrint(this);
    }

    private static void validateParams(JClassType enclosing, JClassSymbol symbol, List<JTypeMirror> typeArgs) {
        Objects.requireNonNull(symbol, "Symbol shouldn't be null");
        ClassTypeImpl.checkUserEnclosingTypeIsOk(enclosing, symbol);
        if (!ClassTypeImpl.typeArgsAreOk(symbol, typeArgs)) {
            throw ClassTypeImpl.invalidTypeArgs(symbol, typeArgs);
        }
        for (JTypeMirror arg : typeArgs) {
            ClassTypeImpl.checkTypeArg(symbol, typeArgs, arg);
        }
    }

    protected static @NonNull IllegalArgumentException invalidTypeArgs(JClassSymbol symbol, List<? extends JTypeMirror> typeArgs) {
        return new IllegalArgumentException("Cannot parameterize " + symbol + " with " + typeArgs + ", expecting  " + symbol.getTypeParameterCount() + " type arguments");
    }

    private static void checkTypeArg(JClassSymbol symbol, List<JTypeMirror> typeArgs, JTypeMirror arg) {
        if (arg == null) {
            throw new IllegalArgumentException("Null type argument for " + symbol + " in " + typeArgs);
        }
        if (arg.isPrimitive()) {
            throw new IllegalArgumentException("Primitive type argument for " + symbol + " in " + typeArgs);
        }
    }

    private static boolean typeArgsAreOk(JClassSymbol symbol, List<? extends JTypeMirror> typeArgs) {
        return typeArgs.isEmpty() || symbol.isUnresolved() || symbol.getTypeParameterCount() == typeArgs.size();
    }

    private static void checkUserEnclosingTypeIsOk(@Nullable JClassType enclosing, JClassSymbol symbol) {
        if (symbol.isUnresolved() || enclosing != null && enclosing.getSymbol().isUnresolved()) {
            return;
        }
        if (enclosing != null) {
            if (Modifier.isStatic(symbol.getModifiers())) {
                throw new IllegalArgumentException("Cannot select *static* type " + symbol + " inside " + enclosing);
            }
            if (!enclosing.getSymbol().equals(symbol.getEnclosingClass())) {
                throw new IllegalArgumentException("Cannot select type " + symbol + " inside " + enclosing);
            }
        }
    }

    private static enum TypeGenericity {
        RAW,
        GENERIC_TYPEDECL,
        GENERIC_PARAMETERIZED,
        NON_GENERIC;

    }
}

