/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.internal.ast;

import java.util.function.Function;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTVariableId;
import net.sourceforge.pmd.lang.java.ast.JModifier;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.JFieldSymbol;
import net.sourceforge.pmd.lang.java.symbols.internal.ast.AbstractAstVariableSym;
import net.sourceforge.pmd.lang.java.symbols.internal.ast.AstSymFactory;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.SubstVar;
import net.sourceforge.pmd.lang.java.types.Substitution;
import net.sourceforge.pmd.lang.java.types.TypeOps;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AstFieldSym
extends AbstractAstVariableSym
implements JFieldSymbol {
    private final JClassSymbol owner;
    private final int modifiers;

    AstFieldSym(ASTVariableId node, AstSymFactory factory, JClassSymbol owner) {
        super(node, factory);
        this.owner = owner;
        this.modifiers = JModifier.toReflect(node.getModifiers().getEffectiveModifiers());
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    @Override
    public @Nullable Object getConstValue() {
        if (((ASTVariableId)this.node).hasModifiers(JModifier.STATIC, new JModifier[]{JModifier.FINAL})) {
            ASTExpression init = ((ASTVariableId)this.node).getInitializer();
            return init == null ? null : init.getConstValue();
        }
        return null;
    }

    @Override
    public boolean isEnumConstant() {
        return ((ASTVariableId)this.node).isEnumConstant();
    }

    @Override
    public @NonNull JClassSymbol getEnclosingClass() {
        return this.owner;
    }

    @Override
    public JTypeMirror getTypeMirror(Substitution subst) {
        return TypeOps.subst(((ASTVariableId)this.node).getTypeMirror(), (Function<? super SubstVar, ? extends JTypeMirror>)subst);
    }
}

