/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.internal.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.sourceforge.pmd.lang.java.ast.ASTBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassType;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorCall;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTEnumConstant;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTRecordComponent;
import net.sourceforge.pmd.lang.java.ast.ASTRecordComponentList;
import net.sourceforge.pmd.lang.java.ast.ASTTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTVariableId;
import net.sourceforge.pmd.lang.java.ast.InternalApiBridge;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.JConstructorSymbol;
import net.sourceforge.pmd.lang.java.symbols.JElementSymbol;
import net.sourceforge.pmd.lang.java.symbols.JExecutableSymbol;
import net.sourceforge.pmd.lang.java.symbols.JFieldSymbol;
import net.sourceforge.pmd.lang.java.symbols.JMethodSymbol;
import net.sourceforge.pmd.lang.java.symbols.JRecordComponentSymbol;
import net.sourceforge.pmd.lang.java.symbols.JTypeDeclSymbol;
import net.sourceforge.pmd.lang.java.symbols.JTypeParameterOwnerSymbol;
import net.sourceforge.pmd.lang.java.symbols.internal.ImplicitMemberSymbols;
import net.sourceforge.pmd.lang.java.symbols.internal.ast.AbstractAstTParamOwner;
import net.sourceforge.pmd.lang.java.symbols.internal.ast.AstCtorSym;
import net.sourceforge.pmd.lang.java.symbols.internal.ast.AstFieldSym;
import net.sourceforge.pmd.lang.java.symbols.internal.ast.AstMethodSym;
import net.sourceforge.pmd.lang.java.symbols.internal.ast.AstRecordComponentSym;
import net.sourceforge.pmd.lang.java.symbols.internal.ast.AstSymFactory;
import net.sourceforge.pmd.lang.java.types.JClassType;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.SubstVar;
import net.sourceforge.pmd.lang.java.types.Substitution;
import net.sourceforge.pmd.lang.java.types.TypeOps;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import net.sourceforge.pmd.util.CollectionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.pcollections.HashTreePSet;
import org.pcollections.PSet;

final class AstClassSym
extends AbstractAstTParamOwner<ASTTypeDeclaration>
implements JClassSymbol {
    private final @Nullable JTypeParameterOwnerSymbol enclosing;
    private final List<JClassSymbol> declaredClasses;
    private final List<JMethodSymbol> declaredMethods;
    private final List<JConstructorSymbol> declaredCtors;
    private final List<JFieldSymbol> declaredFields;
    private final List<JFieldSymbol> enumConstants;
    private final List<JRecordComponentSymbol> recordComponents;
    private final PSet<String> annotAttributes;

    AstClassSym(ASTTypeDeclaration node, AstSymFactory factory, @Nullable JTypeParameterOwnerSymbol enclosing) {
        super(node, factory);
        ArrayList enumConstants;
        List<JRecordComponentSymbol> recordComponents;
        this.enclosing = enclosing;
        ArrayList<AstClassSym> myClasses = new ArrayList<AstClassSym>();
        ArrayList<JMethodSymbol> myMethods = new ArrayList<JMethodSymbol>();
        ArrayList<JConstructorSymbol> myCtors = new ArrayList<JConstructorSymbol>();
        ArrayList<JFieldSymbol> myFields = new ArrayList<JFieldSymbol>();
        if (this.isRecord()) {
            ASTRecordComponentList components = Objects.requireNonNull(node.getRecordComponents(), "Null component list for " + node);
            recordComponents = this.mapComponentsToMutableList(factory, components, myFields);
            JConstructorSymbol canonicalRecordCtor = ImplicitMemberSymbols.recordConstructor(this, recordComponents, components.isVarargs());
            myCtors.add(canonicalRecordCtor);
            InternalApiBridge.setSymbol(components, canonicalRecordCtor);
        } else {
            recordComponents = Collections.emptyList();
        }
        if (this.isEnum()) {
            enumConstants = new ArrayList();
            node.getEnumConstants().forEach(constant -> {
                AstFieldSym fieldSym = new AstFieldSym(constant.getVarId(), factory, this);
                enumConstants.add(fieldSym);
                myFields.add(fieldSym);
            });
        } else {
            enumConstants = null;
        }
        for (ASTBodyDeclaration dnode : node.getDeclarations()) {
            if (dnode instanceof ASTTypeDeclaration) {
                myClasses.add(new AstClassSym((ASTTypeDeclaration)dnode, factory, this));
                continue;
            }
            if (dnode instanceof ASTMethodDeclaration) {
                if (!recordComponents.isEmpty() && ((ASTMethodDeclaration)dnode).getArity() == 0) {
                    recordComponents.removeIf(f -> f.nameEquals(((ASTMethodDeclaration)dnode).getName()));
                }
                myMethods.add(new AstMethodSym((ASTMethodDeclaration)dnode, factory, (JClassSymbol)this));
                continue;
            }
            if (dnode instanceof ASTConstructorDeclaration) {
                myCtors.add(new AstCtorSym((ASTConstructorDeclaration)dnode, factory, (JClassSymbol)this));
                continue;
            }
            if (!(dnode instanceof ASTFieldDeclaration)) continue;
            for (ASTVariableId varId : ((ASTFieldDeclaration)dnode).getVarIds()) {
                myFields.add(new AstFieldSym(varId, factory, this));
            }
        }
        if (!recordComponents.isEmpty()) {
            for (JRecordComponentSymbol component : recordComponents) {
                myMethods.add(ImplicitMemberSymbols.recordAccessor(this, component));
            }
        }
        if (myCtors.isEmpty() && this.isClass() && !this.isAnonymousClass()) {
            myCtors.add(ImplicitMemberSymbols.defaultCtor(this));
        }
        if (this.isEnum()) {
            myMethods.add(ImplicitMemberSymbols.enumValues(this));
            myMethods.add(ImplicitMemberSymbols.enumValueOf(this));
        }
        this.declaredClasses = Collections.unmodifiableList(myClasses);
        this.declaredMethods = Collections.unmodifiableList(myMethods);
        this.declaredCtors = Collections.unmodifiableList(myCtors);
        this.declaredFields = Collections.unmodifiableList(myFields);
        this.enumConstants = CollectionUtil.makeUnmodifiableAndNonNull(enumConstants);
        this.recordComponents = CollectionUtil.makeUnmodifiableAndNonNull(recordComponents);
        this.annotAttributes = this.isAnnotation() ? (PSet)this.getDeclaredMethods().stream().filter(JMethodSymbol::isAnnotationAttribute).map(JElementSymbol::getSimpleName).collect(CollectionUtil.toPersistentSet()) : HashTreePSet.empty();
    }

    private List<JRecordComponentSymbol> mapComponentsToMutableList(AstSymFactory factory, ASTRecordComponentList components, List<JFieldSymbol> fieldSyms) {
        ArrayList<JRecordComponentSymbol> list = new ArrayList<JRecordComponentSymbol>();
        for (ASTRecordComponent comp : components) {
            list.add(new AstRecordComponentSym(comp, factory, this));
            fieldSyms.add(new AstFieldSym(comp.getVarId(), factory, this));
        }
        return list;
    }

    @Override
    public @NonNull String getSimpleName() {
        return ((ASTTypeDeclaration)this.node).getSimpleName();
    }

    @Override
    public @NonNull String getBinaryName() {
        return ((ASTTypeDeclaration)this.node).getBinaryName();
    }

    @Override
    public @Nullable String getCanonicalName() {
        return ((ASTTypeDeclaration)this.node).getCanonicalName();
    }

    @Override
    public boolean isUnresolved() {
        return false;
    }

    @Override
    public @Nullable JClassSymbol getEnclosingClass() {
        if (this.enclosing instanceof JClassSymbol) {
            return (JClassSymbol)this.enclosing;
        }
        if (this.enclosing instanceof JExecutableSymbol) {
            return this.enclosing.getEnclosingClass();
        }
        assert (this.enclosing == null);
        return null;
    }

    @Override
    public @Nullable JExecutableSymbol getEnclosingMethod() {
        return this.enclosing instanceof JExecutableSymbol ? (JExecutableSymbol)this.enclosing : null;
    }

    @Override
    public List<JClassSymbol> getDeclaredClasses() {
        return this.declaredClasses;
    }

    @Override
    public List<JMethodSymbol> getDeclaredMethods() {
        return this.declaredMethods;
    }

    @Override
    public List<JConstructorSymbol> getConstructors() {
        return this.declaredCtors;
    }

    @Override
    public List<JFieldSymbol> getDeclaredFields() {
        return this.declaredFields;
    }

    @Override
    public @NonNull List<JFieldSymbol> getEnumConstants() {
        return this.enumConstants;
    }

    @Override
    public @NonNull List<JRecordComponentSymbol> getRecordComponents() {
        return this.recordComponents;
    }

    @Override
    public @Nullable JClassType getSuperclassType(Substitution substitution) {
        TypeSystem ts = this.getTypeSystem();
        if (((ASTTypeDeclaration)this.node).isEnum()) {
            return this.factory.enumSuperclass(this);
        }
        if (this.node instanceof ASTClassDeclaration) {
            ASTClassType superClass = ((ASTClassDeclaration)this.node).getSuperClassTypeNode();
            return superClass == null ? ts.OBJECT : (JClassType)TypeOps.subst(superClass.getTypeMirror(), (Function<? super SubstVar, ? extends JTypeMirror>)substitution);
        }
        if (this.isAnonymousClass()) {
            if (((ASTTypeDeclaration)this.node).getParent() instanceof ASTEnumConstant) {
                return ((ASTTypeDeclaration)this.node).getEnclosingType().getTypeMirror().subst((Function)substitution);
            }
            if (((ASTTypeDeclaration)this.node).getParent() instanceof ASTConstructorCall) {
                @NonNull JTypeMirror sym = ((ASTConstructorCall)((ASTTypeDeclaration)this.node).getParent()).getTypeMirror();
                return sym instanceof JClassType && !sym.isInterface() ? (JClassType)sym : this.factory.types().OBJECT;
            }
        } else {
            if (this.isRecord()) {
                return this.factory.recordSuperclass();
            }
            if (this.isAnnotation()) {
                return ts.OBJECT;
            }
        }
        return null;
    }

    @Override
    public @Nullable JClassSymbol getSuperclass() {
        if (this.isAnonymousClass() && ((ASTTypeDeclaration)this.node).getParent() instanceof ASTConstructorCall) {
            @NonNull JTypeMirror sym = ((ASTConstructorCall)((ASTTypeDeclaration)this.node).getParent()).getTypeNode().getTypeMirror();
            return sym instanceof JClassType && !sym.isInterface() ? ((JClassType)sym).getSymbol() : this.factory.types().OBJECT.getSymbol();
        }
        JClassType sup = this.getSuperclassType(Substitution.EMPTY);
        return sup == null ? null : sup.getSymbol();
    }

    @Override
    public List<JClassSymbol> getSuperInterfaces() {
        List itfs = CollectionUtil.mapNotNull(((ASTTypeDeclaration)this.node).getSuperInterfaceTypeNodes(), n -> {
            JTypeDeclSymbol sym = n.getTypeMirror().getSymbol();
            return sym instanceof JClassSymbol ? (JClassSymbol)sym : null;
        });
        if (this.isAnnotation()) {
            itfs = CollectionUtil.concatView(Collections.singletonList(this.factory.annotationSym()), (List)itfs);
        }
        return itfs;
    }

    @Override
    public List<JClassType> getSuperInterfaceTypes(Substitution subst) {
        List itfs = CollectionUtil.map(((ASTTypeDeclaration)this.node).getSuperInterfaceTypeNodes(), n -> (JClassType)TypeOps.subst(n.getTypeMirror(), (Function<? super SubstVar, ? extends JTypeMirror>)subst));
        if (this.isAnnotation()) {
            itfs = CollectionUtil.concatView(Collections.singletonList(this.factory.annotationType()), (List)itfs);
        }
        return itfs;
    }

    @Override
    public @Nullable JTypeDeclSymbol getArrayComponent() {
        return null;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isInterface() {
        return ((ASTTypeDeclaration)this.node).isInterface();
    }

    @Override
    public boolean isEnum() {
        return ((ASTTypeDeclaration)this.node).isEnum();
    }

    @Override
    public boolean isRecord() {
        return ((ASTTypeDeclaration)this.node).isRecord();
    }

    @Override
    public boolean isAnnotation() {
        return ((ASTTypeDeclaration)this.node).isAnnotation();
    }

    @Override
    public boolean isLocalClass() {
        return ((ASTTypeDeclaration)this.node).isLocal();
    }

    @Override
    public boolean isAnonymousClass() {
        return ((ASTTypeDeclaration)this.node).isAnonymous();
    }

    @Override
    public PSet<String> getAnnotationAttributeNames() {
        return this.annotAttributes;
    }
}

