/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.sourceforge.pmd.lang.ast.GenericToken;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken;
import net.sourceforge.pmd.lang.document.FileLocation;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.JavaComment;
import net.sourceforge.pmd.lang.java.ast.JavadocComment;
import net.sourceforge.pmd.lang.java.ast.JavadocCommentOwner;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.util.DataMap;
import org.checkerframework.checker.nullness.qual.Nullable;

final class CommentAssignmentPass {
    private static final DataMap.SimpleDataKey<JavadocComment> FORMAL_COMMENT_KEY = DataMap.simpleDataKey((String)"java.comment");

    private CommentAssignmentPass() {
    }

    static @Nullable JavadocComment getComment(JavadocCommentOwner commentOwner) {
        return (JavadocComment)commentOwner.getUserMap().get(FORMAL_COMMENT_KEY);
    }

    private static void setComment(JavadocCommentOwner commentableNode, JavadocComment comment) {
        commentableNode.getUserMap().set(FORMAL_COMMENT_KEY, (Object)comment);
        comment.setOwner(commentableNode);
    }

    public static void assignCommentsToDeclarations(ASTCompilationUnit root) {
        List comments = root.getComments().stream().filter(JavadocComment.class::isInstance).map(JavadocComment.class::cast).collect(Collectors.toList());
        if (comments.isEmpty()) {
            return;
        }
        block0: for (JavadocCommentOwner commentableNode : CommentAssignmentPass.javadocOwners(root)) {
            JavaccToken firstToken = commentableNode.getFirstToken();
            for (JavaccToken maybeComment : GenericToken.previousSpecials((GenericToken)firstToken)) {
                JavadocComment searcher;
                int index;
                boolean formalComment = maybeComment.kind == 7;
                boolean isJavadoc = formalComment || JavaAstUtils.isMarkdownComment(maybeComment);
                if (!isJavadoc || (index = Collections.binarySearch(comments, searcher = new JavadocComment(maybeComment), Comparator.comparing(JavaComment::getReportLocation, Comparator.comparing(FileLocation::getStartPos)))) < 0) continue;
                CommentAssignmentPass.setComment(commentableNode, (JavadocComment)comments.get(index));
                continue block0;
            }
        }
    }

    private static NodeStream<JavadocCommentOwner> javadocOwners(ASTCompilationUnit root) {
        return root.descendants().crossFindBoundaries().filterIs(JavadocCommentOwner.class);
    }
}

