/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.internal.asm;

import net.sourceforge.pmd.lang.java.symbols.internal.asm.InvalidTypeSignatureException;
import net.sourceforge.pmd.util.AssertionUtil;
import org.apache.commons.lang3.StringUtils;

class SignatureScanner {
    protected final String chars;
    protected final int start;
    protected final int end;

    SignatureScanner(String descriptor) {
        if (descriptor == null || descriptor.isEmpty()) {
            throw new IllegalArgumentException("Type descriptor \"" + descriptor + "\" is empty or null");
        }
        this.chars = descriptor;
        this.start = 0;
        this.end = descriptor.length();
    }

    SignatureScanner(String chars, int start, int end) {
        assert (chars != null);
        AssertionUtil.assertValidStringRange((CharSequence)chars, (int)start, (int)end);
        this.chars = chars;
        this.start = start;
        this.end = end;
    }

    public char charAt(int off) {
        return off < this.end ? this.chars.charAt(off) : (char)'\u0000';
    }

    public void dumpChars(int start, int end, StringBuilder builder) {
        builder.append(this.chars, start, end);
    }

    public int consumeChar(int start, char l, String s) {
        if (this.charAt(start) != l) {
            throw this.expected(s, start);
        }
        return start + 1;
    }

    public int consumeChar(int start, char l) {
        return this.consumeChar(start, l, "" + l);
    }

    public int nextIndexOf(int start, char stop) {
        int cur;
        for (cur = start; cur < this.end && this.charAt(cur) != stop; ++cur) {
        }
        return cur;
    }

    public int nextIndexOfAny(int start, char stop, char stop2) {
        char c;
        int cur;
        for (cur = start; cur < this.end && (c = this.charAt(cur)) != stop && c != stop2; ++cur) {
        }
        return cur;
    }

    public RuntimeException expected(String expectedWhat, int pos) {
        String indent = "    ";
        String sb = "Expected " + expectedWhat + ":\n" + "    " + this.bufferToString() + "\n" + "    " + StringUtils.repeat((char)' ', (int)(pos - this.start)) + '^' + "\n";
        return new InvalidTypeSignatureException(sb);
    }

    public void expectEoI(int e) {
        this.consumeChar(e, '\u0000', "end of input");
    }

    public String bufferToString() {
        return this.bufferToString(this.start, this.end);
    }

    public String bufferToString(int start, int end) {
        if (start == end) {
            return "";
        }
        return this.chars.substring(start, end);
    }

    public String toString() {
        return "TypeBuilder{sig=" + this.bufferToString() + '}';
    }
}

