/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import java.util.Set;
import java.util.stream.Collectors;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.java.ast.ASTAssignableExpr;
import net.sourceforge.pmd.lang.java.ast.ASTAssignmentExpression;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTBreakStatement;
import net.sourceforge.pmd.lang.java.ast.ASTContinueStatement;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTForStatement;
import net.sourceforge.pmd.lang.java.ast.ASTForUpdate;
import net.sourceforge.pmd.lang.java.ast.ASTForeachStatement;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTInfixExpression;
import net.sourceforge.pmd.lang.java.ast.ASTLocalClassStatement;
import net.sourceforge.pmd.lang.java.ast.ASTLoopStatement;
import net.sourceforge.pmd.lang.java.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.java.ast.ASTStatement;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchStatement;
import net.sourceforge.pmd.lang.java.ast.ASTThrowStatement;
import net.sourceforge.pmd.lang.java.ast.ASTVariableId;
import net.sourceforge.pmd.lang.java.ast.AssignmentOp;
import net.sourceforge.pmd.lang.java.ast.BinaryOp;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.reporting.RuleContext;
import net.sourceforge.pmd.util.StringUtil;

public class AvoidReassigningLoopVariablesRule
extends AbstractJavaRulechainRule {
    private static final PropertyDescriptor<ForeachReassignOption> FOREACH_REASSIGN = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.enumProperty((String)"foreachReassign", ForeachReassignOption.class, ForeachReassignOption::getDisplayName).defaultValue((Object)ForeachReassignOption.DENY)).desc("how/if foreach control variables may be reassigned")).build();
    private static final PropertyDescriptor<ForReassignOption> FOR_REASSIGN = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.enumProperty((String)"forReassign", ForReassignOption.class, ForReassignOption::getDisplayName).defaultValue((Object)ForReassignOption.DENY)).desc("how/if for control variables may be reassigned")).build();

    public AvoidReassigningLoopVariablesRule() {
        super(ASTForStatement.class, ASTForeachStatement.class);
        this.definePropertyDescriptor(FOREACH_REASSIGN);
        this.definePropertyDescriptor(FOR_REASSIGN);
    }

    public Object visit(ASTForeachStatement loopStmt, Object data) {
        ForeachReassignOption behavior = (ForeachReassignOption)((Object)this.getProperty(FOREACH_REASSIGN));
        if (behavior == ForeachReassignOption.ALLOW) {
            return data;
        }
        ASTVariableId loopVar = loopStmt.getVarId();
        boolean ignoreNext = behavior == ForeachReassignOption.FIRST_ONLY;
        for (ASTAssignableExpr.ASTNamedReferenceExpr usage : loopVar.getLocalUsages()) {
            if (usage.getAccessType() == ASTAssignableExpr.AccessType.WRITE) {
                if (ignoreNext) {
                    ignoreNext = false;
                    continue;
                }
                this.asCtx(data).addViolation((Node)usage, new Object[]{loopVar.getName()});
                continue;
            }
            ignoreNext = false;
        }
        return null;
    }

    public Object visit(ASTForStatement loopStmt, Object data) {
        ForReassignOption behavior = (ForReassignOption)((Object)this.getProperty(FOR_REASSIGN));
        if (behavior == ForReassignOption.ALLOW) {
            return data;
        }
        NodeStream<ASTVariableId> loopVars = JavaAstUtils.getLoopVariables(loopStmt);
        if (behavior == ForReassignOption.DENY) {
            ASTForUpdate update = (ASTForUpdate)loopStmt.firstChild(ASTForUpdate.class);
            for (ASTVariableId loopVar : loopVars) {
                for (ASTAssignableExpr.ASTNamedReferenceExpr usage : loopVar.getLocalUsages()) {
                    if (usage.getAccessType() != ASTAssignableExpr.AccessType.WRITE || update != null && usage.ancestors(ASTForUpdate.class).first() == update) continue;
                    this.asCtx(data).addViolation((Node)usage, new Object[]{loopVar.getName()});
                }
            }
        } else {
            Set loopVarNames = (Set)loopVars.collect(Collectors.mapping(ASTVariableId::getName, Collectors.toSet()));
            Set<String> labels = JavaAstUtils.getStatementLabels(loopStmt);
            new ControlFlowCtx(false, loopVarNames, (RuleContext)data, labels, false, false).roamStatementsForExit(loopStmt.getBody());
        }
        return null;
    }

    private static enum ForReassignOption {
        DENY,
        SKIP,
        ALLOW;


        public String toString() {
            return this.getDisplayName();
        }

        public String getDisplayName() {
            return StringUtil.CaseConvention.SCREAMING_SNAKE_CASE.convertTo(StringUtil.CaseConvention.CAMEL_CASE, this.name());
        }
    }

    private static enum ForeachReassignOption {
        DENY,
        FIRST_ONLY,
        ALLOW;


        public String toString() {
            return this.getDisplayName();
        }

        public String getDisplayName() {
            return StringUtil.CaseConvention.SCREAMING_SNAKE_CASE.convertTo(StringUtil.CaseConvention.CAMEL_CASE, this.name());
        }
    }

    class ControlFlowCtx {
        private final boolean guarded;
        private boolean mayExit;
        private final Set<String> loopVarNames;
        private final RuleContext ruleCtx;
        private final Set<String> outerLoopNames;
        private final boolean breakHidden;
        private final boolean continueHidden;

        ControlFlowCtx(boolean guarded, Set<String> loopVarNames, RuleContext ctx, Set<String> outerLoopNames, boolean breakHidden, boolean continueHidden) {
            this.guarded = guarded;
            this.loopVarNames = loopVarNames;
            this.ruleCtx = ctx;
            this.outerLoopNames = outerLoopNames;
            this.breakHidden = breakHidden;
            this.continueHidden = continueHidden;
        }

        ControlFlowCtx withGuard(boolean isGuarded) {
            return this.copy(isGuarded, this.breakHidden, this.continueHidden);
        }

        ControlFlowCtx copy(boolean isGuarded, boolean breakHidden, boolean continueHidden) {
            return new ControlFlowCtx(isGuarded, this.loopVarNames, this.ruleCtx, this.outerLoopNames, breakHidden, continueHidden);
        }

        private boolean roamStatementsForExit(JavaNode node) {
            if (node == null) {
                return false;
            }
            NodeStream unwrappedBlock = node instanceof ASTBlock ? ((ASTBlock)node).toStream() : NodeStream.of((Node)node);
            return this.roamStatementsForExit((NodeStream<? extends JavaNode>)unwrappedBlock);
        }

        private boolean roamStatementsForExit(NodeStream<? extends JavaNode> stmts) {
            for (JavaNode stmt : stmts) {
                String label;
                if (stmt instanceof ASTThrowStatement || stmt instanceof ASTReturnStatement) {
                    return true;
                }
                if (stmt instanceof ASTBreakStatement) {
                    label = ((ASTBreakStatement)stmt).getLabel();
                    return label != null && this.outerLoopNames.contains(label) || !this.breakHidden;
                }
                if (stmt instanceof ASTContinueStatement) {
                    label = ((ASTContinueStatement)stmt).getLabel();
                    return label != null && this.outerLoopNames.contains(label) || !this.continueHidden;
                }
                if (stmt instanceof ASTLoopStatement) {
                    ASTStatement body = ((ASTLoopStatement)stmt).getBody();
                    for (JavaNode child : stmt.children()) {
                        if (child == body) continue;
                        this.checkVorViolations(child);
                    }
                    this.mayExit |= this.copy(true, true, true).roamStatementsForExit(body);
                    continue;
                }
                if (stmt instanceof ASTSwitchStatement) {
                    ASTSwitchStatement switchStmt = (ASTSwitchStatement)stmt;
                    this.checkVorViolations(switchStmt.getTestedExpression());
                    this.mayExit |= this.copy(true, true, false).roamStatementsForExit((NodeStream<? extends JavaNode>)switchStmt.getBranches());
                    continue;
                }
                if (stmt instanceof ASTIfStatement) {
                    ASTIfStatement ifStmt = (ASTIfStatement)stmt;
                    this.checkVorViolations(ifStmt.getCondition());
                    this.mayExit |= this.withGuard(true).roamStatementsForExit(ifStmt.getThenBranch());
                    this.mayExit |= this.withGuard(this.guarded).roamStatementsForExit(ifStmt.getElseBranch());
                    continue;
                }
                if (stmt instanceof ASTExpression) {
                    this.checkVorViolations(stmt);
                    continue;
                }
                if (stmt instanceof ASTLocalClassStatement) continue;
                this.mayExit |= this.roamStatementsForExit((NodeStream<? extends JavaNode>)stmt.children());
            }
            return this.mayExit;
        }

        private void checkVorViolations(JavaNode node) {
            if (node == null) {
                return;
            }
            boolean onlyConsiderWrite = this.guarded || this.mayExit;
            node.descendants(ASTAssignableExpr.ASTNamedReferenceExpr.class).filter(it -> this.loopVarNames.contains(it.getName())).filter(it -> onlyConsiderWrite ? it.getAccessType() == ASTAssignableExpr.AccessType.WRITE && !this.isSimpleSkipOperation((ASTAssignableExpr.ASTNamedReferenceExpr)it) : JavaAstUtils.isVarAccessReadAndWrite(it)).forEach(it -> AvoidReassigningLoopVariablesRule.this.asCtx(this.ruleCtx).addViolation((Node)it, new Object[]{it.getName()}));
        }

        private boolean isSimpleSkipOperation(ASTAssignableExpr.ASTNamedReferenceExpr expr) {
            if (expr.getAccessType() != ASTAssignableExpr.AccessType.WRITE) {
                return false;
            }
            if (expr.getParent() instanceof ASTAssignmentExpression) {
                ASTAssignmentExpression assignment = (ASTAssignmentExpression)expr.getParent();
                if (expr.getIndexInParent() == 0) {
                    return this.isSimpleSkipAssignment(assignment, expr.getName());
                }
            } else {
                return JavaAstUtils.isVarAccessReadAndWrite(expr);
            }
            return false;
        }

        private boolean isSimpleSkipAssignment(ASTAssignmentExpression assignment, String varName) {
            if (assignment.getOperator().isCompound()) {
                AssignmentOp op = assignment.getOperator();
                ASTExpression rhs = assignment.getRightOperand();
                return (op == AssignmentOp.ADD_ASSIGN || op == AssignmentOp.SUB_ASSIGN) && this.isLiteralOne(rhs);
            }
            if (assignment.getOperator() == AssignmentOp.ASSIGN) {
                ASTExpression rhs = assignment.getRightOperand();
                return this.isSimpleIncrementExpression(rhs, varName);
            }
            return false;
        }

        private boolean isLiteralOne(ASTExpression expr) {
            return expr.isCompileTimeConstant() && expr.getConstValue() instanceof Number && ((Number)expr.getConstValue()).intValue() == 1;
        }

        private boolean isSimpleIncrementExpression(ASTExpression expr, String varName) {
            ASTInfixExpression infixExpr;
            BinaryOp operator;
            if (expr instanceof ASTInfixExpression && ((operator = (infixExpr = (ASTInfixExpression)expr).getOperator()) == BinaryOp.ADD || operator == BinaryOp.SUB)) {
                ASTExpression left = infixExpr.getLeftOperand();
                ASTExpression right = infixExpr.getRightOperand();
                if (this.isVariableReference(left, varName) && this.isLiteralOne(right)) {
                    return true;
                }
                if (operator == BinaryOp.ADD && this.isLiteralOne(left) && this.isVariableReference(right, varName)) {
                    return true;
                }
            }
            return false;
        }

        private boolean isVariableReference(ASTExpression expr, String varName) {
            return expr instanceof ASTAssignableExpr.ASTNamedReferenceExpr && ((ASTAssignableExpr.ASTNamedReferenceExpr)expr).getName().equals(varName);
        }
    }
}

