/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.internal;

import java.util.Map;
import net.sourceforge.pmd.cpd.CpdLanguageProperties;
import net.sourceforge.pmd.lang.JvmLanguagePropertyBundle;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.java.JavaLanguageModule;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import org.apache.commons.lang3.EnumUtils;

public class JavaLanguageProperties
extends JvmLanguagePropertyBundle {
    static final PropertyDescriptor<InferenceLoggingVerbosity> INTERNAL_INFERENCE_LOGGING_VERBOSITY = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.enumProperty((String)"xTypeInferenceLogging", (Map)EnumUtils.getEnumMap(InferenceLoggingVerbosity.class)).desc("Verbosity of the type inference logging")).defaultValue((Object)InferenceLoggingVerbosity.DISABLED)).build();
    static final PropertyDescriptor<Boolean> INTERNAL_DO_STRICT_TYPERES = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"xStrictTypeRes").desc("Whether to perform type resolution strictly at the start of execution or not")).defaultValue((Object)true)).build();
    public static final PropertyDescriptor<Boolean> FIRST_CLASS_LOMBOK = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"lombok").desc("Whether to consider lombok-specific things in core facilities like type inference. Disable this option if you want to analyze the AST as it would appear before the lombok pre-processing is applied. For instance, with this option enabled, variables declared with type lombok.val will have their type inferred based on the right-hand-side. With the option disabled, the variable will have type lombok.val instead. See https://github.com/pmd/pmd/issues/3119")).defaultValue((Object)true)).build();

    public JavaLanguageProperties() {
        super((Language)JavaLanguageModule.getInstance());
        this.definePropertyDescriptor(INTERNAL_INFERENCE_LOGGING_VERBOSITY);
        this.definePropertyDescriptor(INTERNAL_DO_STRICT_TYPERES);
        this.definePropertyDescriptor(FIRST_CLASS_LOMBOK);
        this.definePropertyDescriptor(CpdLanguageProperties.CPD_IGNORE_METADATA);
        this.definePropertyDescriptor(CpdLanguageProperties.CPD_ANONYMIZE_IDENTIFIERS);
        this.definePropertyDescriptor(CpdLanguageProperties.CPD_ANONYMIZE_LITERALS);
    }

    public static boolean isPreviewEnabled(LanguageVersion version) {
        return version.getVersion().endsWith("-preview");
    }

    public static int getInternalJdkVersion(LanguageVersion version) {
        String verString = version.getVersion();
        if (JavaLanguageProperties.isPreviewEnabled(version)) {
            verString = verString.substring(0, verString.length() - "-preview".length());
        }
        if (verString.startsWith("1.")) {
            verString = verString.substring(2);
        }
        return Integer.parseInt(verString);
    }

    public static enum InferenceLoggingVerbosity {
        DISABLED,
        SIMPLE,
        VERBOSE;

    }
}

