/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.performance;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorCall;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTList;
import net.sourceforge.pmd.lang.java.ast.ASTMethodCall;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.rule.internal.JavaRuleUtil;
import net.sourceforge.pmd.reporting.RuleContext;

public class InefficientStringBufferingRule
extends AbstractJavaRulechainRule {
    public InefficientStringBufferingRule() {
        super(ASTConstructorCall.class, ASTMethodCall.class);
    }

    public Object visit(ASTMethodCall node, Object data) {
        if (JavaRuleUtil.isStringBuilderCtorOrAppend(node)) {
            this.checkArgument(node.getArguments(), (RuleContext)data);
        }
        return null;
    }

    public Object visit(ASTConstructorCall node, Object data) {
        if (JavaRuleUtil.isStringBuilderCtorOrAppend(node)) {
            this.checkArgument(node.getArguments(), (RuleContext)data);
        }
        return null;
    }

    private void checkArgument(ASTArgumentList argList, RuleContext ctx) {
        ASTExpression arg = ASTList.singleOrNull(argList);
        if (JavaAstUtils.isStringConcatExpr(arg) && !arg.getConstFoldingResult().hasValue()) {
            ctx.addViolation((Node)arg);
        }
    }

    static boolean isInStringBufferOperationChain(Node node, String append) {
        if (!(node instanceof ASTExpression)) {
            return false;
        }
        Node parent = node.getParent();
        return parent instanceof ASTMethodCall && JavaRuleUtil.isStringBuilderCtorOrAppend((ASTMethodCall)parent);
    }
}

