/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types.internal.infer;

import java.util.EnumSet;
import java.util.Set;

enum MethodResolutionPhase {
    STRICT,
    LOOSE,
    VARARGS,
    INVOC_STRICT,
    INVOC_LOOSE,
    INVOC_VARARGS;

    static final Set<MethodResolutionPhase> APPLICABILITY_TESTS;

    MethodResolutionPhase asInvoc() {
        switch (this) {
            case STRICT: {
                return INVOC_STRICT;
            }
            case LOOSE: {
                return INVOC_LOOSE;
            }
            case VARARGS: {
                return INVOC_VARARGS;
            }
        }
        return this;
    }

    boolean requiresVarargs() {
        return this == INVOC_VARARGS || this == VARARGS;
    }

    boolean canBox() {
        return this != STRICT;
    }

    boolean isInvocation() {
        return this == INVOC_STRICT || this == INVOC_LOOSE || this == INVOC_VARARGS;
    }

    static {
        APPLICABILITY_TESTS = EnumSet.of(STRICT, LOOSE, VARARGS);
    }
}

