/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.internal.asm;

import java.util.ArrayList;
import net.sourceforge.pmd.lang.java.symbols.JTypeParameterOwnerSymbol;
import net.sourceforge.pmd.lang.java.symbols.JTypeParameterSymbol;
import net.sourceforge.pmd.lang.java.symbols.SymbolicValue;
import net.sourceforge.pmd.lang.java.symbols.internal.SymbolEquality;
import net.sourceforge.pmd.lang.java.symbols.internal.SymbolToStrings;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.GenericSigBase;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.SignatureParser;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.TypeAnnotationHelper;
import net.sourceforge.pmd.lang.java.types.JIntersectionType;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.JTypeVar;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.TypeReference;
import org.pcollections.HashTreePSet;
import org.pcollections.PSet;

class TParamStub
implements JTypeParameterSymbol {
    private final String name;
    private final JTypeParameterOwnerSymbol owner;
    private final JTypeVar typeVar;
    private final String boundSignature;
    private final SignatureParser sigParser;
    private PSet<SymbolicValue.SymAnnot> annotations = HashTreePSet.empty();
    private TypeAnnotationHelper.TypeAnnotationSetWithReferences typeAnnotationsOnBound;
    private boolean canComputeBound;

    TParamStub(String name, GenericSigBase<?> sig, String bound) {
        this.name = name;
        this.owner = sig.ctx;
        this.sigParser = sig.typeLoader();
        this.boundSignature = bound;
        TypeSystem ts = sig.ctx.getTypeSystem();
        this.typeVar = ts.newTypeVar(this);
    }

    @Override
    public @NonNull String getSimpleName() {
        return this.name;
    }

    @Override
    public JTypeMirror computeUpperBound() {
        if (!this.canComputeBound) {
            throw new IllegalStateException("Can't compute upper bound of " + this.name + " in " + this.owner.getEnclosingTypeParameterOwner());
        }
        JTypeMirror bound = this.sigParser.parseTypeVarBound(this.owner.getLexicalScope(), this.boundSignature);
        if (this.typeAnnotationsOnBound == null) {
            return bound;
        }
        return this.typeAnnotationsOnBound.reduce(bound, (tyRef, path, annot, acc) -> {
            int boundIdx = tyRef.getTypeParameterBoundIndex();
            return TParamStub.applyTypeAnnotationToBound(path, annot, boundIdx, acc);
        });
    }

    private static JTypeMirror applyTypeAnnotationToBound(@Nullable TypePath path, SymbolicValue.SymAnnot annot, int boundIdx, JTypeMirror ub) {
        if (ub instanceof JIntersectionType) {
            JIntersectionType intersection = (JIntersectionType)ub;
            boundIdx = intersection.getPrimaryBound().isTop() ? boundIdx - 1 : boundIdx;
            ArrayList<JTypeMirror> components = new ArrayList<JTypeMirror>(intersection.getComponents());
            JTypeMirror bound = (JTypeMirror)components.get(boundIdx);
            JTypeMirror newBound = TypeAnnotationHelper.applySinglePath(bound, path, annot);
            components.set(boundIdx, newBound);
            return intersection.getTypeSystem().glb(components);
        }
        return TypeAnnotationHelper.applySinglePath(ub, path, annot);
    }

    void setCanComputeBound() {
        this.canComputeBound = true;
    }

    @Override
    public JTypeParameterOwnerSymbol getDeclaringSymbol() {
        return this.owner;
    }

    @Override
    public PSet<SymbolicValue.SymAnnot> getDeclaredAnnotations() {
        return this.annotations;
    }

    void addAnnotation(SymbolicValue.SymAnnot annot) {
        this.annotations = this.annotations.plus((Object)annot);
    }

    @Override
    public JTypeVar getTypeMirror() {
        return this.typeVar;
    }

    @Override
    public TypeSystem getTypeSystem() {
        return this.owner.getTypeSystem();
    }

    public String toString() {
        return SymbolToStrings.ASM.toString(this);
    }

    public int hashCode() {
        return SymbolEquality.TYPE_PARAM.hash(this);
    }

    @Override
    public boolean equals(Object obj) {
        return SymbolEquality.TYPE_PARAM.equals(this, obj);
    }

    void addAnnotationOnBound(TypeReference tyRef, @Nullable TypePath path, SymbolicValue.SymAnnot annot) {
        assert (tyRef.getSort() == 17 || tyRef.getSort() == 18);
        if (this.typeAnnotationsOnBound == null) {
            this.typeAnnotationsOnBound = new TypeAnnotationHelper.TypeAnnotationSetWithReferences();
        }
        this.typeAnnotationsOnBound.add(tyRef, path, annot);
    }
}

