/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.internal.asm;

import net.sourceforge.pmd.lang.java.symbols.SymbolicValue;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.AnnotationBuilderVisitor;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.ExecutableStub;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.SymbolicAnnotationImpl;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.SymbolicValueBuilder;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.TypePath;

class MethodInfoVisitor
extends MethodVisitor {
    private final ExecutableStub execStub;
    private SymbolicValue defaultAnnotValue;

    MethodInfoVisitor(ExecutableStub execStub) {
        super(589824);
        this.execStub = execStub;
    }

    public AnnotationVisitor visitAnnotationDefault() {
        return new SymbolicValueBuilder(this.execStub.getResolver()){

            @Override
            protected void acceptValue(String name, SymbolicValue v) {
                MethodInfoVisitor.this.defaultAnnotValue = v;
            }
        };
    }

    public AnnotationVisitor visitParameterAnnotation(final int parameter, final String descriptor, final boolean visible) {
        return new SymbolicValueBuilder(this.execStub.getResolver()){
            private final SymbolicAnnotationImpl annot;
            {
                super(resolver);
                this.annot = new SymbolicAnnotationImpl(this.getResolver(), visible, descriptor);
            }

            @Override
            protected void acceptValue(String name, SymbolicValue v) {
                this.annot.addAttribute(name, v);
            }

            public void visitEnd() {
                MethodInfoVisitor.this.execStub.addParameterAnnotation(parameter, this.annot);
            }
        };
    }

    public void visitEnd() {
        this.execStub.setDefaultAnnotValue(this.defaultAnnotValue);
        super.visitEnd();
    }

    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        return new AnnotationBuilderVisitor(this.execStub, this.execStub.getResolver(), visible, descriptor);
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        return new AnnotationBuilderVisitor.TypeAnnotBuilderImpl(this.execStub.getResolver(), this.execStub, typeRef, typePath, visible, descriptor);
    }
}

