/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchBranch;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchFallthroughBranch;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchLabel;
import net.sourceforge.pmd.lang.java.ast.ASTTypePattern;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.JTypeDeclSymbol;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;

public interface ASTSwitchLike
extends JavaNode,
Iterable<ASTSwitchBranch> {
    default public boolean hasDefaultCase() {
        return this.getBranches().any(it -> it.getLabel().isDefault());
    }

    default public NodeStream<ASTSwitchBranch> getBranches() {
        return this.children(ASTSwitchBranch.class);
    }

    default public ASTExpression getTestedExpression() {
        return (ASTExpression)this.getChild(0);
    }

    default public boolean isExhaustiveEnumSwitch() {
        JTypeDeclSymbol symbol = this.getTestedExpression().getTypeMirror().getSymbol();
        if (symbol instanceof JClassSymbol && ((JClassSymbol)symbol).isEnum()) {
            long numConstants = ((JClassSymbol)symbol).getEnumConstants().size();
            int numLabels = this.getBranches().sumByInt(it -> it.getLabel().getNumChildren());
            return (long)numLabels == numConstants;
        }
        return false;
    }

    default public boolean isEnumSwitch() {
        JTypeDeclSymbol type = this.getTestedExpression().getTypeMirror().getSymbol();
        return type instanceof JClassSymbol && ((JClassSymbol)type).isEnum();
    }

    default public boolean isExhaustive() {
        JTypeDeclSymbol symbol = this.getTestedExpression().getTypeMirror().getSymbol();
        boolean hasPatterns = this.getBranches().map(ASTSwitchBranch::getLabel).any(ASTSwitchLabel::isPatternLabel);
        if (hasPatterns && !this.hasDefaultCase()) {
            return true;
        }
        if (symbol instanceof JClassSymbol) {
            JClassSymbol classSymbol = (JClassSymbol)symbol;
            if ((classSymbol.isSealed() || classSymbol.equals(this.getTypeSystem().BOOLEAN.getSymbol())) && !this.hasDefaultCase()) {
                return true;
            }
            if (classSymbol.isSealed()) {
                Set checkedSubtypes = this.getBranches().map(ASTSwitchBranch::getLabel).children(ASTTypePattern.class).map(ASTTypePattern::getTypeNode).toStream().map(TypeNode::getTypeMirror).map(JTypeMirror::getSymbol).filter(s -> s instanceof JClassSymbol).map(s -> (JClassSymbol)s).collect(Collectors.toSet());
                HashSet<JClassSymbol> permittedSubtypes = new HashSet<JClassSymbol>(classSymbol.getPermittedSubtypes());
                permittedSubtypes.removeAll(checkedSubtypes);
                for (JClassSymbol remainingType : new HashSet<JClassSymbol>(permittedSubtypes)) {
                    if (!remainingType.isSealed()) continue;
                    HashSet<JClassSymbol> subtypes = new HashSet<JClassSymbol>(remainingType.getPermittedSubtypes());
                    subtypes.removeAll(checkedSubtypes);
                    if (!subtypes.isEmpty()) continue;
                    permittedSubtypes.remove(remainingType);
                }
                return permittedSubtypes.isEmpty();
            }
        }
        return this.isExhaustiveEnumSwitch();
    }

    @Override
    default public Iterator<ASTSwitchBranch> iterator() {
        return this.children(ASTSwitchBranch.class).iterator();
    }

    default public boolean isFallthroughSwitch() {
        return this.getBranches().filterIs(ASTSwitchFallthroughBranch.class).nonEmpty();
    }
}

