/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.internal;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.AstVisitor;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.ast.impl.GenericNode;
import net.sourceforge.pmd.lang.java.ast.ASTAssignableExpr;
import net.sourceforge.pmd.lang.java.ast.ASTAssignmentExpression;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTBreakStatement;
import net.sourceforge.pmd.lang.java.ast.ASTCatchClause;
import net.sourceforge.pmd.lang.java.ast.ASTCatchParameter;
import net.sourceforge.pmd.lang.java.ast.ASTCompactConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalExpression;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorCall;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTContinueStatement;
import net.sourceforge.pmd.lang.java.ast.ASTDoStatement;
import net.sourceforge.pmd.lang.java.ast.ASTEnumConstant;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTFieldAccess;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFinallyClause;
import net.sourceforge.pmd.lang.java.ast.ASTForInit;
import net.sourceforge.pmd.lang.java.ast.ASTForStatement;
import net.sourceforge.pmd.lang.java.ast.ASTForUpdate;
import net.sourceforge.pmd.lang.java.ast.ASTForeachStatement;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTInfixExpression;
import net.sourceforge.pmd.lang.java.ast.ASTInitializer;
import net.sourceforge.pmd.lang.java.ast.ASTLabeledStatement;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaExpression;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTLoopStatement;
import net.sourceforge.pmd.lang.java.ast.ASTMethodCall;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTRecordComponent;
import net.sourceforge.pmd.lang.java.ast.ASTResourceList;
import net.sourceforge.pmd.lang.java.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.java.ast.ASTStatement;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchArrowBranch;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchBranch;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchExpression;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchFallthroughBranch;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchLike;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchStatement;
import net.sourceforge.pmd.lang.java.ast.ASTThisExpression;
import net.sourceforge.pmd.lang.java.ast.ASTThrowStatement;
import net.sourceforge.pmd.lang.java.ast.ASTTryStatement;
import net.sourceforge.pmd.lang.java.ast.ASTTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTUnaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTVariableAccess;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTVariableId;
import net.sourceforge.pmd.lang.java.ast.ASTWhileStatement;
import net.sourceforge.pmd.lang.java.ast.ASTYieldStatement;
import net.sourceforge.pmd.lang.java.ast.BinaryOp;
import net.sourceforge.pmd.lang.java.ast.InvocationNode;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaVisitorBase;
import net.sourceforge.pmd.lang.java.ast.QualifiableExpression;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.rule.design.SingularFieldRule;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.JFieldSymbol;
import net.sourceforge.pmd.lang.java.symbols.JLocalVariableSymbol;
import net.sourceforge.pmd.lang.java.symbols.JVariableSymbol;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.util.CollectionUtil;
import net.sourceforge.pmd.util.DataMap;
import net.sourceforge.pmd.util.OptionalBool;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class DataflowPass {
    private static final DataMap.SimpleDataKey<DataflowResult> DATAFLOW_RESULT_K = DataMap.simpleDataKey((String)"java.dataflow.global");
    private static final DataMap.SimpleDataKey<ReachingDefinitionSet> REACHING_DEFS = DataMap.simpleDataKey((String)"java.dataflow.reaching.backwards");
    private static final DataMap.SimpleDataKey<AssignmentEntry> VAR_DEFINITION = DataMap.simpleDataKey((String)"java.dataflow.field.def");
    private static final DataMap.SimpleDataKey<OptionalBool> SWITCH_BRANCH_FALLS_THROUGH = DataMap.simpleDataKey((String)"java.dataflow.switch.fallthrough");

    private DataflowPass() {
    }

    public static DataflowResult getDataflowResult(ASTCompilationUnit acu) {
        return (DataflowResult)acu.getUserMap().computeIfAbsent(DATAFLOW_RESULT_K, () -> DataflowPass.process(acu));
    }

    public static @Nullable AssignmentEntry getFieldDefinition(ASTVariableId varId) {
        if (!varId.isField()) {
            return null;
        }
        return (AssignmentEntry)varId.getUserMap().get(VAR_DEFINITION);
    }

    private static DataflowResult process(ASTCompilationUnit node) {
        DataflowResult dataflowResult = new DataflowResult();
        for (ASTTypeDeclaration typeDecl : node.getTypeDeclarations()) {
            GlobalAlgoState subResult = new GlobalAlgoState();
            typeDecl.acceptVisitor(ReachingDefsVisitor.ONLY_LOCALS, new SpanInfo(subResult));
            if (subResult.usedAssignments.size() < subResult.allAssignments.size()) {
                Set<AssignmentEntry> unused = subResult.allAssignments;
                unused.removeAll(subResult.usedAssignments);
                unused.removeIf(AssignmentEntry::isUnbound);
                unused.removeIf(AssignmentEntry::isFieldDefaultValue);
                dataflowResult.unusedAssignments.addAll(unused);
            }
            CollectionUtil.mergeMaps(dataflowResult.killRecord, subResult.killRecord, (s1, s2) -> {
                s1.addAll(s2);
                return s1;
            });
        }
        return dataflowResult;
    }

    static class UnboundAssignment
    extends AssignmentEntry {
        private final boolean isFieldStartValue;

        UnboundAssignment(JVariableSymbol var, ASTVariableId node, JavaNode rhs, boolean isFieldStartValue) {
            super(var, node, rhs);
            this.isFieldStartValue = isFieldStartValue;
        }

        @Override
        public boolean isUnbound() {
            return true;
        }

        @Override
        public boolean isFieldAssignmentAtStartOfMethod() {
            return this.isFieldStartValue;
        }

        @Override
        public boolean isFieldAssignmentAtEndOfCtor() {
            return this.rhs instanceof ASTTypeDeclaration;
        }
    }

    public static class AssignmentEntry
    implements Comparable<AssignmentEntry> {
        final JVariableSymbol var;
        final ASTVariableId node;
        final JavaNode rhs;

        AssignmentEntry(JVariableSymbol var, ASTVariableId node, JavaNode rhs) {
            this.var = var;
            this.node = node;
            this.rhs = rhs;
            if ((this.isInitializer() || this.isBlankDeclaration()) && !this.isUnbound()) {
                node.getUserMap().set((DataMap.DataKey)VAR_DEFINITION, (Object)this);
            }
        }

        public boolean isInitializer() {
            return this.rhs.getParent() instanceof ASTVariableDeclarator && this.rhs.getIndexInParent() > 0;
        }

        public boolean isBlankDeclaration() {
            return this.rhs instanceof ASTVariableId;
        }

        public boolean isFieldDefaultValue() {
            return this.isBlankDeclaration() && this.isField();
        }

        public boolean isBlankLocal() {
            return this.isBlankDeclaration() && this.node.isLocalVariable();
        }

        public boolean isUnaryReassign() {
            return this.rhs instanceof ASTUnaryExpression && ReachingDefsVisitor.getVarIfUnaryAssignment((ASTUnaryExpression)this.rhs) == this.var;
        }

        @Override
        public int compareTo(AssignmentEntry o) {
            return this.rhs.compareLocation((Node)o.rhs);
        }

        public int getLine() {
            return this.getLocation().getBeginLine();
        }

        public boolean isField() {
            return this.var instanceof JFieldSymbol;
        }

        public boolean isForeachVar() {
            return this.node.isForeachVariable();
        }

        public ASTVariableId getVarId() {
            return this.node;
        }

        public JavaNode getLocation() {
            return this.rhs;
        }

        public @Nullable ASTExpression getRhsAsExpression() {
            if (this.isUnbound() || this.isBlankDeclaration()) {
                return null;
            }
            if (this.rhs instanceof ASTExpression) {
                return (ASTExpression)this.rhs;
            }
            return null;
        }

        public @Nullable JTypeMirror getRhsType() {
            if (this.isUnbound() || this.isBlankDeclaration()) {
                return null;
            }
            if (this.rhs instanceof ASTExpression) {
                return ((TypeNode)this.rhs).getTypeMirror();
            }
            return null;
        }

        public boolean isUnbound() {
            return false;
        }

        public boolean isFieldAssignmentAtStartOfMethod() {
            return false;
        }

        public boolean isFieldAssignmentAtEndOfCtor() {
            return false;
        }

        public String toString() {
            return this.var.getSimpleName() + " := " + this.rhs;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AssignmentEntry that = (AssignmentEntry)o;
            return Objects.equals(this.var, that.var) && Objects.equals(this.rhs, that.rhs);
        }

        public int hashCode() {
            return 31 * this.var.hashCode() + this.rhs.hashCode();
        }
    }

    static class TargetStack {
        final Deque<SpanInfo> unnamedTargets = new ArrayDeque<SpanInfo>();
        final Map<String, SpanInfo> namedTargets = new LinkedHashMap<String, SpanInfo>();

        TargetStack() {
        }

        void push(SpanInfo state) {
            this.unnamedTargets.push(state);
        }

        SpanInfo pop() {
            return this.unnamedTargets.pop();
        }

        SpanInfo peek() {
            return this.unnamedTargets.getFirst();
        }

        SpanInfo doBreak(SpanInfo data, String label) {
            SpanInfo target = label == null ? this.unnamedTargets.getFirst() : this.namedTargets.get(label);
            if (target != null) {
                target.absorb(data);
            }
            return data.abruptCompletion(target);
        }
    }

    private static final class SpanInfo {
        final SpanInfo parent;
        SpanInfo myFinally = null;
        List<SpanInfo> myCatches;
        final GlobalAlgoState global;
        final Map<JVariableSymbol, VarLocalInfo> symtable;
        private OptionalBool hasCompletedAbruptly = OptionalBool.NO;

        private SpanInfo(GlobalAlgoState global) {
            this(null, global, new LinkedHashMap<JVariableSymbol, VarLocalInfo>());
        }

        private SpanInfo(SpanInfo parent, GlobalAlgoState global, Map<JVariableSymbol, VarLocalInfo> symtable) {
            this.parent = parent;
            this.global = global;
            this.symtable = symtable;
            this.myCatches = Collections.emptyList();
        }

        boolean hasVar(ASTVariableId var) {
            return this.symtable.containsKey(var.getSymbol());
        }

        void declareBlank(ASTVariableId id) {
            this.assign((JVariableSymbol)id.getSymbol(), id);
        }

        void assign(JVariableSymbol var, JavaNode rhs) {
            this.assign(var, rhs, false, false);
        }

        void assign(JVariableSymbol var, JavaNode rhs, boolean outOfScope, boolean isFieldBeforeMethod) {
            ASTVariableId node = (ASTVariableId)var.tryGetNode();
            if (node == null) {
                return;
            }
            AssignmentEntry entry = outOfScope || isFieldBeforeMethod ? new UnboundAssignment(var, node, rhs, isFieldBeforeMethod) : new AssignmentEntry(var, node, rhs);
            VarLocalInfo previous = this.symtable.put(var, new VarLocalInfo(Collections.singleton(entry)));
            if (previous != null) {
                for (AssignmentEntry killed : previous.reachingDefs) {
                    if (killed.isBlankLocal()) continue;
                    this.global.killRecord.computeIfAbsent(killed, k -> new LinkedHashSet(1)).add(entry);
                }
            }
            this.global.allAssignments.add(entry);
        }

        void declareSpecialFieldValues(JClassSymbol sym) {
            List<JFieldSymbol> declaredFields = sym.getDeclaredFields();
            for (JFieldSymbol field : declaredFields) {
                ASTVariableId id = (ASTVariableId)field.tryGetNode();
                if (id == null || !SingularFieldRule.mayBeSingular(id)) continue;
                this.assign(field, id, true, true);
            }
        }

        void assignOutOfScope(@Nullable JVariableSymbol var, JavaNode escapingNode) {
            if (var == null) {
                return;
            }
            this.use(var, null);
            this.assign(var, escapingNode, true, false);
        }

        void use(@Nullable JVariableSymbol var, ASTAssignableExpr.ASTNamedReferenceExpr reachingDefSink) {
            if (var == null) {
                return;
            }
            VarLocalInfo info = this.symtable.get(var);
            if (info != null) {
                this.global.usedAssignments.addAll(info.reachingDefs);
                if (reachingDefSink != null) {
                    ReachingDefinitionSet reaching = new ReachingDefinitionSet(new LinkedHashSet<AssignmentEntry>(info.reachingDefs));
                    reachingDefSink.getUserMap().compute((DataMap.DataKey)REACHING_DEFS, current -> {
                        if (current != null) {
                            current.absorb(reaching);
                            return current;
                        }
                        return reaching;
                    });
                }
            }
        }

        void deleteVar(JVariableSymbol var) {
            this.symtable.remove(var);
        }

        public void recordThisLeak(boolean thisIsLeaking, JClassSymbol enclosingClassSym, JavaNode escapingNode) {
            if (thisIsLeaking && enclosingClassSym != null) {
                ReachingDefsVisitor.useAllSelfFields(null, this, enclosingClassSym, escapingNode);
            }
        }

        SpanInfo fork() {
            return this.doFork(this, this.copyTable());
        }

        SpanInfo forkEmpty() {
            return this.doFork(this, new LinkedHashMap<JVariableSymbol, VarLocalInfo>());
        }

        SpanInfo forkEmptyNonLocal() {
            return this.doFork(null, new LinkedHashMap<JVariableSymbol, VarLocalInfo>());
        }

        SpanInfo forkCapturingNonLocal() {
            return this.doFork(null, this.copyTable());
        }

        private Map<JVariableSymbol, VarLocalInfo> copyTable() {
            return new LinkedHashMap<JVariableSymbol, VarLocalInfo>(this.symtable);
        }

        private SpanInfo doFork(SpanInfo parent, Map<JVariableSymbol, VarLocalInfo> reaching) {
            return new SpanInfo(parent, this.global, reaching);
        }

        SpanInfo abruptCompletion(SpanInfo target) {
            this.hasCompletedAbruptly = OptionalBool.YES;
            SpanInfo parent = this;
            while (parent != target && parent != null) {
                if (parent.myFinally != null) {
                    parent.myFinally.absorb(this);
                    return this;
                }
                parent = parent.parent;
            }
            this.symtable.clear();
            return this;
        }

        SpanInfo abruptCompletionByThrow(boolean byMethodCall) {
            if (!byMethodCall) {
                this.hasCompletedAbruptly = OptionalBool.YES;
            }
            SpanInfo parent = this;
            while (parent != null) {
                if (!parent.myCatches.isEmpty()) {
                    for (SpanInfo c : parent.myCatches) {
                        c.absorb(this);
                    }
                }
                if (parent.myFinally != null) {
                    parent.myFinally.absorb(this);
                    return this;
                }
                parent = parent.parent;
            }
            if (!byMethodCall) {
                this.symtable.clear();
            }
            return this;
        }

        SpanInfo withCatchBlocks(List<SpanInfo> catchStmts) {
            assert (this.myCatches.isEmpty() || catchStmts.isEmpty()) : "Cannot set catch blocks twice";
            this.myCatches = Collections.unmodifiableList(catchStmts);
            return this;
        }

        SpanInfo absorb(SpanInfo other) {
            if (other == this || other == null || other.symtable.isEmpty()) {
                return this;
            }
            CollectionUtil.mergeMaps(this.symtable, other.symtable, VarLocalInfo::merge);
            this.hasCompletedAbruptly = this.mergeCertitude(this.hasCompletedAbruptly, other.hasCompletedAbruptly);
            return this;
        }

        private OptionalBool mergeCertitude(OptionalBool first, OptionalBool other) {
            if (first.isKnown() && other.isKnown()) {
                return first == other ? first : OptionalBool.UNKNOWN;
            }
            return OptionalBool.UNKNOWN;
        }

        public String toString() {
            return this.symtable.toString();
        }
    }

    static class VarLocalInfo {
        final Set<AssignmentEntry> reachingDefs;

        VarLocalInfo(Set<AssignmentEntry> reachingDefs) {
            this.reachingDefs = reachingDefs;
        }

        VarLocalInfo merge(VarLocalInfo other) {
            if (other == this) {
                return this;
            }
            LinkedHashSet<AssignmentEntry> merged = new LinkedHashSet<AssignmentEntry>(this.reachingDefs.size() + other.reachingDefs.size());
            merged.addAll(this.reachingDefs);
            merged.addAll(other.reachingDefs);
            return new VarLocalInfo(merged);
        }

        public String toString() {
            return "VarLocalInfo{reachingDefs=" + this.reachingDefs + '}';
        }
    }

    private static final class GlobalAlgoState {
        final Set<AssignmentEntry> allAssignments;
        final Set<AssignmentEntry> usedAssignments;
        final Map<AssignmentEntry, Set<AssignmentEntry>> killRecord;
        final TargetStack breakTargets = new TargetStack();
        final TargetStack continueTargets = new TargetStack();

        private GlobalAlgoState(Set<AssignmentEntry> allAssignments, Set<AssignmentEntry> usedAssignments, Map<AssignmentEntry, Set<AssignmentEntry>> killRecord) {
            this.allAssignments = allAssignments;
            this.usedAssignments = usedAssignments;
            this.killRecord = killRecord;
        }

        private GlobalAlgoState() {
            this(new LinkedHashSet<AssignmentEntry>(), new LinkedHashSet<AssignmentEntry>(), new LinkedHashMap<AssignmentEntry, Set<AssignmentEntry>>());
        }
    }

    private static final class ReachingDefsVisitor
    extends JavaVisitorBase<SpanInfo, SpanInfo> {
        static final ReachingDefsVisitor ONLY_LOCALS = new ReachingDefsVisitor(null, false);
        private final JClassSymbol enclosingClassScope;
        private final boolean inStaticCtx;

        private ReachingDefsVisitor(JClassSymbol scope, boolean inStaticCtx) {
            this.enclosingClassScope = scope;
            this.inStaticCtx = inStaticCtx;
        }

        private boolean trackThisInstance() {
            return !this.inStaticCtx;
        }

        private boolean trackStaticFields() {
            return this.enclosingClassScope != null && this.inStaticCtx;
        }

        protected SpanInfo visitChildren(Node node, SpanInfo data) {
            for (Node child : node.children()) {
                data = (SpanInfo)child.acceptVisitor((AstVisitor)this, (Object)data);
            }
            return data;
        }

        @Override
        public SpanInfo visit(ASTBlock node, SpanInfo data) {
            SpanInfo state = data;
            LinkedHashSet<ASTVariableId> localsToKill = new LinkedHashSet<ASTVariableId>();
            for (JavaNode child : node.children()) {
                state = this.acceptOpt(child, state);
                if (!(child instanceof ASTLocalVariableDeclaration)) continue;
                for (ASTVariableId id : (ASTLocalVariableDeclaration)child) {
                    localsToKill.add(id);
                }
            }
            for (ASTVariableId var : localsToKill) {
                state.deleteVar((JVariableSymbol)var.getSymbol());
            }
            return state;
        }

        @Override
        public SpanInfo visit(ASTSwitchStatement node, SpanInfo data) {
            return this.processSwitch(node, data);
        }

        @Override
        public SpanInfo visit(ASTSwitchExpression node, SpanInfo data) {
            return this.processSwitch(node, data);
        }

        private SpanInfo processSwitch(ASTSwitchLike switchLike, SpanInfo data) {
            GlobalAlgoState global = data.global;
            SpanInfo before = this.acceptOpt(switchLike.getTestedExpression(), data);
            global.breakTargets.push(before.fork());
            SpanInfo current = before;
            for (ASTSwitchBranch branch : switchLike.getBranches()) {
                if (branch instanceof ASTSwitchArrowBranch) {
                    current = this.acceptOpt(((ASTSwitchArrowBranch)branch).getRightHandSide(), before.fork());
                    current = global.breakTargets.doBreak(current, null);
                    continue;
                }
                current = this.acceptOpt(branch, before.fork().absorb(current));
                branch.getUserMap().set((DataMap.DataKey)SWITCH_BRANCH_FALLS_THROUGH, (Object)current.hasCompletedAbruptly.complement());
            }
            before = global.breakTargets.pop();
            return before.absorb(current);
        }

        @Override
        public SpanInfo visit(ASTIfStatement node, SpanInfo data) {
            return this.makeConditional(data, node.getCondition(), node.getThenBranch(), node.getElseBranch());
        }

        @Override
        public SpanInfo visit(ASTConditionalExpression node, SpanInfo data) {
            return this.makeConditional(data, node.getCondition(), node.getThenBranch(), node.getElseBranch());
        }

        SpanInfo makeConditional(SpanInfo before, ASTExpression condition, JavaNode thenBranch, JavaNode elseBranch) {
            SpanInfo thenState = before.fork();
            SpanInfo elseState = elseBranch != null ? before.fork() : before;
            this.linkConditional(before, condition, thenState, elseState, true);
            thenState = this.acceptOpt(thenBranch, thenState);
            elseState = this.acceptOpt(elseBranch, elseState);
            return elseState.absorb(thenState);
        }

        private SpanInfo linkConditional(SpanInfo before, ASTExpression condition, SpanInfo thenState, SpanInfo elseState, boolean isTopLevel) {
            if (condition == null) {
                return before;
            }
            if (condition instanceof ASTInfixExpression) {
                BinaryOp op = ((ASTInfixExpression)condition).getOperator();
                if (op == BinaryOp.CONDITIONAL_OR) {
                    return this.visitShortcutOrExpr((ASTInfixExpression)condition, before, thenState, elseState);
                }
                if (op == BinaryOp.CONDITIONAL_AND) {
                    return this.visitShortcutOrExpr((ASTInfixExpression)condition, before, elseState, thenState);
                }
            }
            SpanInfo state = this.acceptOpt(condition, before);
            if (isTopLevel) {
                thenState.absorb(state);
                elseState.absorb(state);
            }
            return state;
        }

        SpanInfo visitShortcutOrExpr(ASTInfixExpression orExpr, SpanInfo before, SpanInfo thenState, SpanInfo elseState) {
            SpanInfo cur = before;
            cur = this.linkConditional(cur, orExpr.getLeftOperand(), thenState, elseState, false);
            thenState.absorb(cur);
            cur = this.linkConditional(cur, orExpr.getRightOperand(), thenState, elseState, false);
            thenState.absorb(cur);
            elseState.absorb(cur);
            return cur;
        }

        @Override
        public SpanInfo visit(ASTTryStatement node, SpanInfo before) {
            List catchClauses;
            ASTFinallyClause finallyClause = node.getFinallyClause();
            if (finallyClause != null) {
                before.myFinally = before.forkEmpty();
            }
            ArrayList<SpanInfo> catchSpans = (catchClauses = node.getCatchClauses().toList()).isEmpty() ? Collections.emptyList() : new ArrayList<SpanInfo>();
            for (int i = 0; i < catchClauses.size(); ++i) {
                catchSpans.add(before.forkEmpty());
            }
            @Nullable ASTResourceList resources = node.getResources();
            SpanInfo bodyState = before.fork();
            bodyState = bodyState.withCatchBlocks(catchSpans);
            bodyState = this.acceptOpt(resources, bodyState);
            bodyState = this.acceptOpt(node.getBody(), bodyState);
            bodyState = bodyState.withCatchBlocks(Collections.emptyList());
            SpanInfo exceptionalState = null;
            int i = 0;
            for (ASTCatchClause catchClause : node.getCatchClauses()) {
                SpanInfo current = this.acceptOpt(catchClause, (SpanInfo)catchSpans.get(i));
                exceptionalState = current.absorb(exceptionalState);
                ++i;
            }
            SpanInfo finalState = bodyState.absorb(exceptionalState);
            if (finallyClause != null) {
                SpanInfo abruptFinally = before.myFinally.absorb(before);
                this.acceptOpt(finallyClause, abruptFinally);
                before.myFinally = null;
                abruptFinally.abruptCompletionByThrow(false);
                finalState = this.acceptOpt(finallyClause, finalState);
            }
            return finalState;
        }

        @Override
        public SpanInfo visit(ASTCatchClause node, SpanInfo data) {
            SpanInfo result = (SpanInfo)this.visitJavaNode(node, data);
            result.deleteVar((JVariableSymbol)node.getParameter().getVarId().getSymbol());
            return result;
        }

        @Override
        public SpanInfo visit(ASTLambdaExpression node, SpanInfo data) {
            SpanInfo before = data;
            JavaNode lambdaBody = (JavaNode)node.getChild(node.getNumChildren() - 1);
            this.acceptOpt(lambdaBody, before.forkCapturingNonLocal());
            return before;
        }

        @Override
        public SpanInfo visit(ASTWhileStatement node, SpanInfo data) {
            return this.handleLoop(node, data, null, node.getCondition(), null, node.getBody(), true, null);
        }

        @Override
        public SpanInfo visit(ASTDoStatement node, SpanInfo data) {
            return this.handleLoop(node, data, null, node.getCondition(), null, node.getBody(), false, null);
        }

        @Override
        public SpanInfo visit(ASTForeachStatement node, SpanInfo data) {
            ASTStatement body = node.getBody();
            ASTExpression init = node.getIterableExpr();
            return this.handleLoop(node, data, init, null, null, body, true, node.getVarId());
        }

        @Override
        public SpanInfo visit(ASTForStatement node, SpanInfo data) {
            ASTStatement body = node.getBody();
            ASTForInit init = (ASTForInit)node.firstChild(ASTForInit.class);
            ASTExpression cond = node.getCondition();
            ASTForUpdate update = (ASTForUpdate)node.firstChild(ASTForUpdate.class);
            return this.handleLoop(node, data, init, cond, update, body, true, null);
        }

        private SpanInfo handleLoop(ASTLoopStatement loop, SpanInfo before, JavaNode init, ASTExpression cond, JavaNode update, ASTStatement body, boolean checkFirstIter, ASTVariableId foreachVar) {
            GlobalAlgoState globalState = before.global;
            SpanInfo breakTarget = before.forkEmpty();
            SpanInfo continueTarget = before.forkEmpty();
            this.pushTargets(loop, breakTarget, continueTarget);
            before = this.acceptOpt(init, before);
            if (checkFirstIter && cond != null) {
                SpanInfo ifcondTrue = before.forkEmpty();
                this.linkConditional(before, cond, ifcondTrue, breakTarget, true);
                before = ifcondTrue;
            }
            if (foreachVar != null) {
                before.assign((JVariableSymbol)foreachVar.getSymbol(), foreachVar);
            }
            SpanInfo iter = this.acceptOpt(body, before.fork());
            if (foreachVar != null && iter.hasVar(foreachVar)) {
                iter.assign((JVariableSymbol)foreachVar.getSymbol(), foreachVar);
            } else {
                iter = this.acceptOpt(update, iter);
            }
            this.linkConditional(iter, cond, iter, breakTarget, true);
            iter = this.acceptOpt(body, iter);
            breakTarget = globalState.breakTargets.peek();
            continueTarget = globalState.continueTargets.peek();
            if (!continueTarget.symtable.isEmpty()) {
                this.linkConditional(continueTarget, cond, continueTarget, breakTarget, true);
                continueTarget = this.acceptOpt(body, continueTarget);
                continueTarget = this.acceptOpt(update, continueTarget);
            }
            SpanInfo result = this.popTargets(loop, breakTarget, continueTarget);
            result = result.absorb(iter);
            if (checkFirstIter) {
                result = result.absorb(before);
            }
            if (foreachVar != null) {
                result.deleteVar((JVariableSymbol)foreachVar.getSymbol());
            }
            return result;
        }

        private void pushTargets(ASTLoopStatement loop, SpanInfo breakTarget, SpanInfo continueTarget) {
            GlobalAlgoState globalState = breakTarget.global;
            globalState.breakTargets.unnamedTargets.push(breakTarget);
            globalState.continueTargets.unnamedTargets.push(continueTarget);
            GenericNode parent = loop.getParent();
            while (parent instanceof ASTLabeledStatement) {
                String label = ((ASTLabeledStatement)parent).getLabel();
                globalState.breakTargets.namedTargets.put(label, breakTarget);
                globalState.continueTargets.namedTargets.put(label, continueTarget);
                parent = parent.getParent();
            }
        }

        private SpanInfo popTargets(ASTLoopStatement loop, SpanInfo breakTarget, SpanInfo continueTarget) {
            GlobalAlgoState globalState = breakTarget.global;
            globalState.breakTargets.unnamedTargets.pop();
            globalState.continueTargets.unnamedTargets.pop();
            SpanInfo total = breakTarget.absorb(continueTarget);
            GenericNode parent = loop.getParent();
            while (parent instanceof ASTLabeledStatement) {
                String label = ((ASTLabeledStatement)parent).getLabel();
                total = total.absorb(globalState.breakTargets.namedTargets.remove(label));
                total = total.absorb(globalState.continueTargets.namedTargets.remove(label));
                parent = parent.getParent();
            }
            return total;
        }

        private SpanInfo acceptOpt(JavaNode node, SpanInfo before) {
            return node == null ? before : (SpanInfo)node.acceptVisitor(this, before);
        }

        @Override
        public SpanInfo visit(ASTContinueStatement node, SpanInfo data) {
            return data.global.continueTargets.doBreak(data, node.getImage());
        }

        @Override
        public SpanInfo visit(ASTBreakStatement node, SpanInfo data) {
            return data.global.breakTargets.doBreak(data, node.getImage());
        }

        @Override
        public SpanInfo visit(ASTYieldStatement node, SpanInfo data) {
            super.visit(node, data);
            return data.global.breakTargets.doBreak(data, null);
        }

        @Override
        public SpanInfo visit(ASTThrowStatement node, SpanInfo data) {
            super.visit(node, data);
            return data.abruptCompletionByThrow(false);
        }

        @Override
        public SpanInfo visit(ASTReturnStatement node, SpanInfo data) {
            super.visit(node, data);
            return data.abruptCompletion(null);
        }

        @Override
        public SpanInfo visit(ASTFormalParameter node, SpanInfo data) {
            data.declareBlank(node.getVarId());
            return data;
        }

        @Override
        public SpanInfo visit(ASTCatchParameter node, SpanInfo data) {
            data.declareBlank(node.getVarId());
            return data;
        }

        @Override
        public SpanInfo visit(ASTVariableDeclarator node, SpanInfo data) {
            JVariableSymbol var = (JVariableSymbol)node.getVarId().getSymbol();
            ASTExpression rhs = node.getInitializer();
            if (rhs != null) {
                rhs.acceptVisitor(this, data);
                data.assign(var, rhs);
            } else if (this.isAssignedImplicitly(node.getVarId())) {
                data.declareBlank(node.getVarId());
            }
            return data;
        }

        @Override
        public SpanInfo visit(ASTCompactConstructorDeclaration node, SpanInfo data) {
            super.visit(node, (Object)data);
            for (ASTRecordComponent component : node.getEnclosingType().getRecordComponents()) {
                node.descendants(ASTAssignmentExpression.class).descendants(ASTVariableAccess.class).filter(v -> v.getAccessType() == ASTAssignableExpr.AccessType.WRITE).filter(v -> v.getName().equals(component.getVarId().getName())).forEach(varAccess -> data.use(varAccess.getReferencedSym(), null));
            }
            return data;
        }

        private boolean isAssignedImplicitly(ASTVariableId var) {
            return !var.isLocalVariable() || var.isForeachVariable();
        }

        @Override
        public SpanInfo visit(ASTUnaryExpression node, SpanInfo data) {
            data = this.acceptOpt(node.getOperand(), data);
            if (node.getOperator().isPure()) {
                return data;
            }
            return this.processAssignment(node.getOperand(), node, true, data);
        }

        @Override
        public SpanInfo visit(ASTAssignmentExpression node, SpanInfo data) {
            data = this.acceptOpt(node.getRightOperand(), data);
            data = this.acceptOpt(node.getLeftOperand(), data);
            return this.processAssignment(node.getLeftOperand(), node.getRightOperand(), node.getOperator().isCompound(), data);
        }

        private SpanInfo processAssignment(ASTExpression lhs, ASTExpression rhs, boolean useBeforeAssigning, SpanInfo result) {
            JVariableSymbol lhsVar;
            if (lhs instanceof ASTAssignableExpr.ASTNamedReferenceExpr && (lhsVar = ((ASTAssignableExpr.ASTNamedReferenceExpr)lhs).getReferencedSym()) != null && (lhsVar instanceof JLocalVariableSymbol || this.isRelevantField(lhs))) {
                if (useBeforeAssigning) {
                    result.use(lhsVar, (ASTAssignableExpr.ASTNamedReferenceExpr)lhs);
                }
                result.assign(lhsVar, rhs);
            }
            return result;
        }

        private boolean isRelevantField(ASTExpression lhs) {
            return lhs instanceof ASTAssignableExpr.ASTNamedReferenceExpr && (this.trackThisInstance() && JavaAstUtils.isThisFieldAccess(lhs) || this.trackStaticFields() && this.isStaticFieldOfThisClass(((ASTAssignableExpr.ASTNamedReferenceExpr)lhs).getReferencedSym()));
        }

        private boolean isStaticFieldOfThisClass(JVariableSymbol var) {
            return var instanceof JFieldSymbol && ((JFieldSymbol)var).isStatic() && this.enclosingClassScope.equals(((JFieldSymbol)var).getEnclosingClass());
        }

        private static JVariableSymbol getVarIfUnaryAssignment(ASTUnaryExpression node) {
            ASTExpression operand = node.getOperand();
            if (!node.getOperator().isPure() && operand instanceof ASTAssignableExpr.ASTNamedReferenceExpr) {
                return ((ASTAssignableExpr.ASTNamedReferenceExpr)operand).getReferencedSym();
            }
            return null;
        }

        @Override
        public SpanInfo visit(ASTVariableAccess node, SpanInfo data) {
            if (node.getAccessType() == ASTAssignableExpr.AccessType.READ) {
                data.use(node.getReferencedSym(), node);
            }
            return data;
        }

        @Override
        public SpanInfo visit(ASTFieldAccess node, SpanInfo data) {
            data = (SpanInfo)node.getQualifier().acceptVisitor(this, data);
            if (this.isRelevantField(node) && node.getAccessType() == ASTAssignableExpr.AccessType.READ) {
                data.use(node.getReferencedSym(), node);
            }
            return data;
        }

        @Override
        public SpanInfo visit(ASTThisExpression node, SpanInfo data) {
            if (this.trackThisInstance() && !(node.getParent() instanceof ASTFieldAccess)) {
                data.recordThisLeak(true, this.enclosingClassScope, node);
            }
            return data;
        }

        @Override
        public SpanInfo visit(ASTMethodCall node, SpanInfo state) {
            return this.visitInvocationExpr(node, state);
        }

        @Override
        public SpanInfo visit(ASTConstructorCall node, SpanInfo state) {
            state = this.visitInvocationExpr(node, state);
            this.acceptOpt(node.getAnonymousClassDeclaration(), state);
            return state;
        }

        private <T extends InvocationNode & QualifiableExpression> SpanInfo visitInvocationExpr(T node, SpanInfo state) {
            state = this.acceptOpt(((QualifiableExpression)node).getQualifier(), state);
            state = this.acceptOpt(node.getArguments(), state);
            state.abruptCompletionByThrow(true);
            return state;
        }

        @Override
        public SpanInfo visitTypeDecl(ASTTypeDeclaration node, SpanInfo data) {
            ReachingDefsVisitor.processInitializers(node.getDeclarations(), data, node.getSymbol());
            for (ASTBodyDeclaration decl : node.getDeclarations()) {
                if (decl instanceof ASTMethodDeclaration) {
                    ASTMethodDeclaration method = (ASTMethodDeclaration)decl;
                    if (method.getBody() == null) continue;
                    SpanInfo span = data.forkCapturingNonLocal();
                    if (!method.isStatic()) {
                        span.declareSpecialFieldValues(node.getSymbol());
                    }
                    ONLY_LOCALS.acceptOpt(decl, span);
                    continue;
                }
                if (!(decl instanceof ASTTypeDeclaration)) continue;
                this.visitTypeDecl((ASTTypeDeclaration)decl, data.forkEmptyNonLocal());
            }
            return data;
        }

        private static void processInitializers(NodeStream<ASTBodyDeclaration> declarations, SpanInfo beforeLocal, JClassSymbol classSymbol) {
            ReachingDefsVisitor instanceVisitor = new ReachingDefsVisitor(classSymbol, false);
            ReachingDefsVisitor staticVisitor = new ReachingDefsVisitor(classSymbol, true);
            SpanInfo ctorHeader = beforeLocal.forkCapturingNonLocal();
            SpanInfo staticInit = beforeLocal.forkEmptyNonLocal();
            ArrayList<ASTBodyDeclaration> ctors = new ArrayList<ASTBodyDeclaration>();
            for (ASTBodyDeclaration declaration : declarations) {
                boolean isStatic;
                if (declaration instanceof ASTEnumConstant) {
                    isStatic = true;
                } else if (declaration instanceof ASTFieldDeclaration) {
                    isStatic = ((ASTFieldDeclaration)declaration).isStatic();
                } else if (declaration instanceof ASTInitializer) {
                    isStatic = ((ASTInitializer)declaration).isStatic();
                } else {
                    if (!(declaration instanceof ASTConstructorDeclaration) && !(declaration instanceof ASTCompactConstructorDeclaration)) continue;
                    ctors.add(declaration);
                    continue;
                }
                if (isStatic) {
                    staticInit = staticVisitor.acceptOpt(declaration, staticInit);
                    continue;
                }
                ctorHeader = instanceVisitor.acceptOpt(declaration, ctorHeader);
            }
            SpanInfo ctorEndState = ctors.isEmpty() ? ctorHeader : null;
            for (ASTBodyDeclaration ctor : ctors) {
                SpanInfo state = instanceVisitor.acceptOpt(ctor, ctorHeader.forkCapturingNonLocal());
                ctorEndState = ctorEndState == null ? state : ctorEndState.absorb(state);
            }
            ReachingDefsVisitor.useAllSelfFields(staticInit, ctorEndState, classSymbol, classSymbol.tryGetNode());
        }

        static void useAllSelfFields(@Nullable SpanInfo staticState, SpanInfo instanceState, JClassSymbol enclosingSym, JavaNode escapingNode) {
            for (JFieldSymbol field : enclosingSym.getDeclaredFields()) {
                if (field.isStatic()) {
                    if (staticState == null) continue;
                    staticState.assignOutOfScope(field, escapingNode);
                    continue;
                }
                instanceState.assignOutOfScope(field, escapingNode);
            }
        }
    }

    public static final class DataflowResult {
        final Set<AssignmentEntry> unusedAssignments = new LinkedHashSet<AssignmentEntry>();
        final Map<AssignmentEntry, Set<AssignmentEntry>> killRecord = new LinkedHashMap<AssignmentEntry, Set<AssignmentEntry>>();

        DataflowResult() {
        }

        public Set<AssignmentEntry> getUnusedAssignments() {
            return Collections.unmodifiableSet(this.unusedAssignments);
        }

        public @NonNull Set<AssignmentEntry> getKillers(AssignmentEntry assignment) {
            return this.killRecord.getOrDefault(assignment, Collections.emptySet());
        }

        public @NonNull OptionalBool switchBranchFallsThrough(ASTSwitchBranch b) {
            if (b instanceof ASTSwitchFallthroughBranch) {
                return Objects.requireNonNull((OptionalBool)b.getUserMap().get((DataMap.DataKey)SWITCH_BRANCH_FALLS_THROUGH));
            }
            return OptionalBool.NO;
        }

        public @NonNull ReachingDefinitionSet getReachingDefinitions(ASTAssignableExpr.ASTNamedReferenceExpr expr) {
            return (ReachingDefinitionSet)expr.getUserMap().computeIfAbsent((DataMap.DataKey)REACHING_DEFS, () -> this.reachingFallback(expr));
        }

        private @NonNull ReachingDefinitionSet reachingFallback(ASTAssignableExpr.ASTNamedReferenceExpr expr) {
            JVariableSymbol sym = expr.getReferencedSym();
            if (sym == null || !sym.isField() || !sym.isFinal()) {
                return ReachingDefinitionSet.unknown();
            }
            ASTVariableId node = (ASTVariableId)sym.tryGetNode();
            if (node == null) {
                return ReachingDefinitionSet.unknown();
            }
            Set assignments = (Set)node.getLocalUsages().stream().filter(it -> it.getAccessType() == ASTAssignableExpr.AccessType.WRITE).map(usage -> {
                JavaNode parent = (JavaNode)usage.getParent();
                if (parent instanceof ASTUnaryExpression && !((ASTUnaryExpression)parent).getOperator().isPure()) {
                    return parent;
                }
                if (usage.getIndexInParent() == 0 && parent instanceof ASTAssignmentExpression) {
                    return ((ASTAssignmentExpression)parent).getRightOperand();
                }
                return null;
            }).filter(Objects::nonNull).map(it -> new AssignmentEntry(sym, node, (JavaNode)it)).collect(CollectionUtil.toMutableSet());
            ASTExpression init = node.getInitializer();
            if (init != null) {
                assignments.add(new AssignmentEntry(sym, node, init));
            }
            return new ReachingDefinitionSet(assignments);
        }
    }

    public static final class ReachingDefinitionSet {
        private Set<AssignmentEntry> reaching;
        private boolean isNotFullyKnown;
        private boolean containsInitialFieldValue;

        private ReachingDefinitionSet() {
            this.reaching = Collections.emptySet();
            this.containsInitialFieldValue = false;
            this.isNotFullyKnown = true;
        }

        ReachingDefinitionSet(Set<AssignmentEntry> reaching) {
            this.reaching = reaching;
            this.containsInitialFieldValue = reaching.removeIf(AssignmentEntry::isFieldAssignmentAtStartOfMethod);
            this.isNotFullyKnown = this.containsInitialFieldValue | reaching.removeIf(AssignmentEntry::isUnbound);
        }

        public Set<AssignmentEntry> getReaching() {
            return Collections.unmodifiableSet(this.reaching);
        }

        public boolean isNotFullyKnown() {
            return this.isNotFullyKnown;
        }

        public boolean containsInitialFieldValue() {
            return this.containsInitialFieldValue;
        }

        void absorb(ReachingDefinitionSet reaching) {
            this.containsInitialFieldValue |= reaching.containsInitialFieldValue;
            this.isNotFullyKnown |= reaching.isNotFullyKnown;
            if (this.reaching.isEmpty()) {
                this.reaching = new LinkedHashSet<AssignmentEntry>(reaching.reaching);
            } else {
                this.reaching.addAll(reaching.reaching);
            }
        }

        public static ReachingDefinitionSet unknown() {
            return new ReachingDefinitionSet();
        }
    }
}

