/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import java.util.EnumSet;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTCastExpression;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTInfixExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.java.ast.ASTUnaryExpression;
import net.sourceforge.pmd.lang.java.ast.BinaryOp;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.types.JPrimitiveType;
import net.sourceforge.pmd.reporting.RuleContext;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SimplifyBooleanReturnsRule
extends AbstractJavaRulechainRule {
    private static final Set<BinaryOp> NEGATABLE_OPS = EnumSet.of(BinaryOp.EQ, new BinaryOp[]{BinaryOp.NE, BinaryOp.GT, BinaryOp.LT, BinaryOp.GE, BinaryOp.LE});

    public SimplifyBooleanReturnsRule() {
        super(ASTReturnStatement.class, new Class[0]);
    }

    public Object visit(ASTReturnStatement node, Object data) {
        ASTExpression expr = node.getExpr();
        if (expr == null || !expr.getTypeMirror().isPrimitive(JPrimitiveType.PrimitiveTypeKind.BOOLEAN) || !this.isThenBranchOfSomeIf(node)) {
            return null;
        }
        this.checkIf((ASTIfStatement)node.ancestors(ASTIfStatement.class).firstOrThrow(), this.asCtx(data), expr);
        return null;
    }

    private boolean isThenBranchOfSomeIf(ASTReturnStatement node) {
        if (node.getParent() instanceof ASTIfStatement) {
            return node.getIndexInParent() == 1;
        }
        return node.getParent() instanceof ASTBlock && ((ASTBlock)node.getParent()).size() == 1 && ((JavaNode)node.getParent()).getParent() instanceof ASTIfStatement && ((JavaNode)node.getParent()).getIndexInParent() == 1;
    }

    private void checkIf(ASTIfStatement node, RuleContext data, ASTExpression thenExpr) {
        ASTExpression elseExpr = this.getElseExpr(node);
        if (elseExpr == null) {
            return;
        }
        if (JavaAstUtils.isBooleanLiteral(thenExpr) || JavaAstUtils.isBooleanLiteral(elseExpr)) {
            String fix = this.needsToBeReportedWhenOneBranchIsBoolean(node.getCondition(), thenExpr, elseExpr);
            if (fix != null) {
                data.addViolation((Node)node, new Object[]{fix});
            }
        } else if (JavaAstUtils.areComplements(thenExpr, elseExpr)) {
            data.addViolation((Node)node, new Object[]{"return {condition};"});
        }
    }

    private String needsToBeReportedWhenOneBranchIsBoolean(ASTExpression condition, ASTExpression thenExpr, ASTExpression elseExpr) {
        ASTExpression branch;
        boolean conditionNegated;
        boolean thenFalse = JavaAstUtils.isBooleanLiteral(thenExpr, false);
        boolean thenTrue = JavaAstUtils.isBooleanLiteral(thenExpr, true);
        boolean elseTrue = JavaAstUtils.isBooleanLiteral(elseExpr, true);
        boolean elseFalse = JavaAstUtils.isBooleanLiteral(elseExpr, false);
        assert (thenFalse || elseFalse || thenTrue || elseTrue) : "expected boolean branch";
        if (JavaAstUtils.isBooleanLiteral(thenExpr) && JavaAstUtils.isBooleanLiteral(elseExpr)) {
            if (thenTrue && elseFalse) {
                return "return {condition};";
            }
            if (thenFalse && elseTrue) {
                return "return !{condition};";
            }
            if (thenTrue) {
                return "return true;";
            }
            return "return false;";
        }
        boolean bl = conditionNegated = thenFalse || elseTrue;
        if (conditionNegated && SimplifyBooleanReturnsRule.needsNewParensWhenNegating(condition)) {
            return null;
        }
        BinaryOp op = thenFalse || elseFalse ? BinaryOp.CONDITIONAL_AND : BinaryOp.CONDITIONAL_OR;
        ASTExpression aSTExpression = branch = thenFalse || thenTrue ? elseExpr : thenExpr;
        if (SimplifyBooleanReturnsRule.doesNotNeedNewParensUnderInfix(condition, op) && SimplifyBooleanReturnsRule.doesNotNeedNewParensUnderInfix(branch, op)) {
            if (thenTrue) {
                return "return {condition} || {elseBranch};";
            }
            if (thenFalse) {
                return "return !{condition} || {elseBranch};";
            }
            if (elseTrue) {
                return "return !{condition} && {thenBranch};";
            }
            return "return {condition} && {thenBranch};";
        }
        return null;
    }

    private static boolean needsNewParensWhenNegating(ASTExpression e) {
        if (e instanceof ASTPrimaryExpression || e instanceof ASTCastExpression || e.isParenthesized() || JavaAstUtils.isInfixExprWithOperator((JavaNode)e, NEGATABLE_OPS) || JavaAstUtils.isBooleanNegation(e)) {
            return false;
        }
        if (JavaAstUtils.isInfixExprWithOperator((JavaNode)e, BinaryOp.CONDITIONAL_OR) || JavaAstUtils.isInfixExprWithOperator((JavaNode)e, BinaryOp.CONDITIONAL_AND)) {
            ASTInfixExpression infix = (ASTInfixExpression)e;
            return SimplifyBooleanReturnsRule.needsNewParensWhenNegating(infix.getLeftOperand()) || SimplifyBooleanReturnsRule.needsNewParensWhenNegating(infix.getRightOperand());
        }
        return true;
    }

    private static boolean doesNotNeedNewParensUnderInfix(ASTExpression e, BinaryOp op) {
        return e instanceof ASTPrimaryExpression || e instanceof ASTCastExpression || e instanceof ASTUnaryExpression || e.isParenthesized() || JavaAstUtils.isInfixExprWithOperator((JavaNode)e, BinaryOp.opsWithGreaterPrecedence(op));
    }

    private @Nullable ASTExpression getReturnExpr(JavaNode node) {
        if (node instanceof ASTReturnStatement) {
            return ((ASTReturnStatement)node).getExpr();
        }
        if (node instanceof ASTBlock && ((ASTBlock)node).size() == 1) {
            return this.getReturnExpr((JavaNode)((ASTBlock)node).get(0));
        }
        return null;
    }

    private @Nullable ASTExpression getElseExpr(ASTIfStatement node) {
        return node.hasElse() ? this.getReturnExpr(node.getElseBranch()) : this.getReturnExpr((JavaNode)node.getNextSibling());
    }
}

