/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.metrics.JavaMetrics;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.metrics.Metric;
import net.sourceforge.pmd.lang.metrics.MetricsUtil;
import net.sourceforge.pmd.reporting.RuleContext;
import net.sourceforge.pmd.util.StringUtil;

public class DataClassRule
extends AbstractJavaRulechainRule {
    private static final int ACCESSOR_OR_FIELD_FEW_LEVEL = 3;
    private static final int ACCESSOR_OR_FIELD_MANY_LEVEL = 5;
    private static final double WOC_LEVEL = 0.3333333333333333;
    private static final int WMC_HIGH_LEVEL = 31;
    private static final int WMC_VERY_HIGH_LEVEL = 47;

    public DataClassRule() {
        super(ASTTypeDeclaration.class, new Class[0]);
    }

    @Override
    public Object visitJavaNode(JavaNode node, Object data) {
        this.visitTypeDecl((ASTTypeDeclaration)node, (RuleContext)data);
        return null;
    }

    private void visitTypeDecl(ASTTypeDeclaration node, RuleContext data) {
        boolean isDataClass;
        if (!MetricsUtil.supportsAll((Node)node, (Metric[])new Metric[]{JavaMetrics.NUMBER_OF_ACCESSORS, JavaMetrics.NUMBER_OF_PUBLIC_FIELDS, JavaMetrics.WEIGHED_METHOD_COUNT, JavaMetrics.WEIGHT_OF_CLASS})) {
            return;
        }
        boolean bl = isDataClass = this.interfaceRevealsData(node) && this.classRevealsDataAndLacksComplexity(node);
        if (isDataClass) {
            double woc = (Double)MetricsUtil.computeMetric(JavaMetrics.WEIGHT_OF_CLASS, (Node)node);
            int nopa = (Integer)MetricsUtil.computeMetric(JavaMetrics.NUMBER_OF_PUBLIC_FIELDS, (Node)node);
            int noam = (Integer)MetricsUtil.computeMetric(JavaMetrics.NUMBER_OF_ACCESSORS, (Node)node);
            int wmc = (Integer)MetricsUtil.computeMetric(JavaMetrics.WEIGHED_METHOD_COUNT, (Node)node);
            this.asCtx(data).addViolation((Node)node, new Object[]{node.getSimpleName(), StringUtil.percentageString((double)woc, (int)3), nopa, noam, wmc});
        }
    }

    private boolean interfaceRevealsData(ASTTypeDeclaration node) {
        double woc = (Double)MetricsUtil.computeMetric(JavaMetrics.WEIGHT_OF_CLASS, (Node)node);
        return woc < 0.3333333333333333;
    }

    private boolean classRevealsDataAndLacksComplexity(ASTTypeDeclaration node) {
        int nopa = (Integer)MetricsUtil.computeMetric(JavaMetrics.NUMBER_OF_PUBLIC_FIELDS, (Node)node);
        int noam = (Integer)MetricsUtil.computeMetric(JavaMetrics.NUMBER_OF_ACCESSORS, (Node)node);
        int wmc = (Integer)MetricsUtil.computeMetric(JavaMetrics.WEIGHED_METHOD_COUNT, (Node)node);
        return nopa + noam > 3 && wmc < 31 || nopa + noam > 5 && wmc < 47;
    }
}

