/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorCall;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTList;
import net.sourceforge.pmd.lang.java.ast.ASTMethodCall;
import net.sourceforge.pmd.lang.java.ast.InvocationNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.types.JMethodSig;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.OverloadSelectionResult;
import net.sourceforge.pmd.lang.java.types.TypePrettyPrint;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.lang.java.types.ast.ExprContext;
import net.sourceforge.pmd.reporting.RuleContext;
import net.sourceforge.pmd.util.CollectionUtil;
import org.apache.commons.lang3.StringUtils;

public class UnnecessaryBoxingRule
extends AbstractJavaRulechainRule {
    private static final Set<String> INTERESTING_NAMES = CollectionUtil.setOf((Object)"valueOf", (Object[])new String[]{"booleanValue", "charValue", "byteValue", "shortValue", "intValue", "longValue", "floatValue", "doubleValue"});

    public UnnecessaryBoxingRule() {
        super(ASTMethodCall.class, ASTConstructorCall.class);
    }

    public Object visit(ASTConstructorCall node, Object data) {
        if (node.getTypeMirror().isBoxedPrimitive()) {
            ASTExpression arg = ASTList.singleOrNull(node.getArguments());
            if (arg == null) {
                return null;
            }
            JTypeMirror argT = arg.getTypeMirror();
            if (argT.isPrimitive()) {
                this.checkBox((RuleContext)data, "boxing", node, arg, node.getMethodType().getFormalParameters().get(0));
            }
        }
        return null;
    }

    public Object visit(ASTMethodCall node, Object data) {
        if (INTERESTING_NAMES.contains(node.getMethodName())) {
            OverloadSelectionResult overload = node.getOverloadSelectionInfo();
            if (overload.isFailed()) {
                return null;
            }
            JMethodSig m = overload.getMethodType();
            boolean isValueOf = "valueOf".equals(node.getMethodName());
            ASTExpression qualifier = node.getQualifier();
            if (isValueOf && this.isWrapperValueOf(m)) {
                this.checkBox((RuleContext)data, "boxing", node, (ASTExpression)node.getArguments().get(0), m.getFormalParameters().get(0));
            } else if (isValueOf && this.isStringValueOf(m) && qualifier != null) {
                this.checkUnboxing((RuleContext)data, node, qualifier.getTypeMirror());
            } else if (!isValueOf && this.isUnboxingCall(m) && qualifier != null) {
                this.checkBox((RuleContext)data, "unboxing", node, qualifier, qualifier.getTypeMirror());
            }
        }
        return null;
    }

    private boolean isUnboxingCall(JMethodSig m) {
        return !m.isStatic() && m.getDeclaringType().isBoxedPrimitive() && m.getArity() == 0;
    }

    private boolean isWrapperValueOf(JMethodSig m) {
        return m.isStatic() && m.getArity() == 1 && m.getDeclaringType().isBoxedPrimitive() && m.getFormalParameters().get(0).isPrimitive();
    }

    private boolean isStringValueOf(JMethodSig m) {
        return m.isStatic() && (m.getArity() == 1 || m.getArity() == 2) && m.getDeclaringType().isBoxedPrimitive() && TypeTestUtil.isA(String.class, m.getFormalParameters().get(0));
    }

    private void checkBox(RuleContext rctx, String opKind, ASTExpression conversionExpr, ASTExpression convertedExpr, JTypeMirror conversionInput) {
        JTypeMirror sourceType = convertedExpr.getTypeMirror();
        JTypeMirror conversionOutput = conversionExpr.getTypeMirror();
        ExprContext ctx = conversionExpr.getConversionContext();
        JTypeMirror ctxType = ctx.getTargetType();
        if (ctxType == null && conversionExpr instanceof InvocationNode) {
            ctxType = conversionOutput;
        }
        if (ctxType != null && this.isImplicitlyConvertible(conversionInput, conversionOutput)) {
            boolean simpleConv = UnnecessaryBoxingRule.isReferenceSubtype(sourceType, conversionInput);
            String reason = simpleConv && conversionInput.unbox().equals(conversionOutput) ? "explicit unboxing" : (simpleConv && conversionInput.box().equals(conversionOutput) ? "explicit boxing" : (sourceType.equals(conversionOutput) ? "boxing of boxed value" : (sourceType.equals(ctxType) ? opKind : "explicit conversion from " + TypePrettyPrint.prettyPrintWithSimpleNames(sourceType) + " to " + TypePrettyPrint.prettyPrintWithSimpleNames(ctxType))));
            rctx.addViolation((Node)conversionExpr, new Object[]{reason});
        }
    }

    private void checkUnboxing(RuleContext rctx, ASTMethodCall methodCall, JTypeMirror conversionOutput) {
        ExprContext ctx = methodCall.getConversionContext();
        JTypeMirror ctxType = ctx.getTargetType();
        if (ctxType != null && this.isImplicitlyConvertible(conversionOutput, ctxType) && conversionOutput.unbox().equals(ctxType)) {
            rctx.addViolation((Node)methodCall, new Object[]{"implicit unboxing. Use " + conversionOutput.getSymbol().getSimpleName() + ".parse" + StringUtils.capitalize((String)ctxType.getSymbol().getSimpleName()) + "(...) instead"});
        }
    }

    private boolean isImplicitlyConvertible(JTypeMirror i, JTypeMirror o) {
        return i.box().isSubtypeOf(o.box()) || i.unbox().isSubtypeOf(o.unbox());
    }

    private static boolean isReferenceSubtype(JTypeMirror s, JTypeMirror t) {
        return s.isPrimitive() ? t.equals(s) : s.isSubtypeOf(t);
    }
}

