/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken;
import net.sourceforge.pmd.lang.java.ast.ASTAmbiguousName;
import net.sourceforge.pmd.lang.java.ast.ASTReferenceType;
import net.sourceforge.pmd.lang.java.ast.ASTTypeArguments;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaTypeNode;
import net.sourceforge.pmd.lang.java.ast.JavaVisitor;
import net.sourceforge.pmd.lang.java.symbols.JTypeDeclSymbol;
import net.sourceforge.pmd.lang.java.types.JClassType;
import net.sourceforge.pmd.util.AssertionUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ASTClassType
extends AbstractJavaTypeNode
implements ASTReferenceType {
    private JTypeDeclSymbol symbol;
    private String simpleName;
    private boolean isFqcn;
    private JClassType implicitEnclosing;

    ASTClassType(ASTAmbiguousName lhs, String simpleName) {
        super(37);
        assert (lhs != null) : "Null LHS";
        this.addChild(lhs, 0);
        this.setSimpleName(simpleName);
    }

    ASTClassType(ASTAmbiguousName simpleName) {
        super(37);
        this.setSimpleName(simpleName.getFirstToken().getImage());
    }

    ASTClassType(@Nullable ASTClassType lhs, boolean isFqcn, JavaccToken firstToken, JavaccToken identifier) {
        super(37);
        this.setSimpleName(identifier.getImage());
        this.isFqcn = isFqcn;
        if (lhs != null) {
            this.addChild(lhs, 0);
        }
        this.setFirstToken(firstToken);
        this.setLastToken(identifier);
    }

    ASTClassType(int id) {
        super(id);
    }

    public boolean isFullyQualified() {
        return this.isFqcn;
    }

    void setSymbol(JTypeDeclSymbol symbol) {
        this.symbol = symbol;
    }

    void setImplicitEnclosing(JClassType enclosing) {
        this.implicitEnclosing = enclosing;
    }

    JClassType getImplicitEnclosing() {
        return this.implicitEnclosing;
    }

    JTypeDeclSymbol getReferencedSym() {
        return this.symbol;
    }

    public @Nullable ASTClassType getQualifier() {
        return (ASTClassType)this.firstChild(ASTClassType.class);
    }

    public @Nullable ASTTypeArguments getTypeArguments() {
        return (ASTTypeArguments)this.firstChild(ASTTypeArguments.class);
    }

    @Override
    protected <P, R> R acceptVisitor(JavaVisitor<? super P, ? extends R> visitor, P data) {
        return visitor.visit(this, data);
    }

    void setSimpleName(String simpleName) {
        this.simpleName = simpleName;
        this.assertSimpleNameOk();
    }

    private void assertSimpleNameOk() {
        assert (this.simpleName != null && this.simpleName.indexOf(46) < 0 && AssertionUtil.isJavaIdentifier((CharSequence)this.simpleName)) : "Invalid simple name '" + this.simpleName + "'";
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    void setFullyQualified() {
        this.isFqcn = true;
    }
}

