/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types;

import java.util.List;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotationTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTImplementsList;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.types.TypesFromReflection;

public final class TypeTestUtil {
    private TypeTestUtil() {
    }

    public static boolean isA(Class<?> clazz, TypeNode node) {
        TypeTestUtil.requireParamNotNull("class", clazz);
        if (node == null) {
            return false;
        }
        if (node.getType() == clazz) {
            return true;
        }
        return TypeTestUtil.canBeExtended(clazz) ? TypeTestUtil.isA(clazz.getName(), node) : TypeTestUtil.isExactlyA(clazz, node);
    }

    public static boolean isA(String canonicalName, TypeNode node) {
        TypeTestUtil.requireParamNotNull("canonicalName", canonicalName);
        if (node == null) {
            return false;
        }
        Class<?> nodeType = node.getType();
        if (nodeType == null) {
            return TypeTestUtil.fallbackIsA(node, canonicalName, true);
        }
        if (nodeType.isAnnotation()) {
            return TypeTestUtil.isAnnotationSubtype(nodeType, canonicalName);
        }
        Class<?> clazz = TypeTestUtil.loadClassWithNodeClassloader(node, canonicalName);
        if (clazz != null) {
            return clazz.isAssignableFrom(nodeType);
        }
        return TypeTestUtil.fallbackIsA(node, canonicalName, true);
    }

    public static boolean isExactlyA(Class<?> clazz, TypeNode node) {
        TypeTestUtil.requireParamNotNull("class", clazz);
        if (node == null) {
            return false;
        }
        return node.getType() == null ? TypeTestUtil.fallbackIsA(node, clazz.getName(), false) : node.getType() == clazz;
    }

    public static boolean isExactlyA(String canonicalName, TypeNode node) {
        TypeTestUtil.requireParamNotNull("canonicalName", canonicalName);
        if (node == null) {
            return false;
        }
        return node.getType() == null ? TypeTestUtil.fallbackIsA(node, canonicalName, false) : node.getType().getCanonicalName().equals(canonicalName);
    }

    private static void requireParamNotNull(String name, Object o) {
        if (o == null) {
            throw new NullPointerException("Parameter '" + name + "' was null");
        }
    }

    private static boolean canBeExtended(Class<?> clazz) {
        return (clazz.getModifiers() & 0x2010) == 0;
    }

    private static boolean isAnnotationSubtype(Class<?> n, String clazzName) {
        assert (n != null && n.isAnnotation()) : "Not an annotation type";
        return "java.lang.annotation.Annotation".equals(clazzName) || "java.lang.Object".equals(clazzName) || clazzName.equals(n.getName());
    }

    private static boolean fallbackIsA(TypeNode n, String canonicalName, boolean considerSubtype) {
        if (n.getImage() != null && !n.getImage().contains(".") && canonicalName.contains(".")) {
            List imports = n.getRoot().findChildrenOfType(ASTImportDeclaration.class);
            for (ASTImportDeclaration importDecl : imports) {
                if (!n.hasImageEqualTo(importDecl.getImportedSimpleName())) continue;
                return canonicalName.equals(importDecl.getImportedName());
            }
        }
        if (n instanceof ASTAnyTypeDeclaration) {
            ASTAnyTypeDeclaration decl = (ASTAnyTypeDeclaration)n;
            if (decl.getBinaryName().equals(canonicalName)) {
                return true;
            }
            if (!considerSubtype) {
                return false;
            }
            return TypeTestUtil.isStrictSuperType(decl, canonicalName);
        }
        return canonicalName.equals(n.getImage()) || canonicalName.endsWith("." + n.getImage());
    }

    private static boolean isStrictSuperType(ASTAnyTypeDeclaration n, String binaryName) {
        if (n instanceof ASTClassOrInterfaceDeclaration) {
            ASTClassOrInterfaceType superClass = ((ASTClassOrInterfaceDeclaration)n).getSuperClassTypeNode();
            if (superClass != null) {
                return TypeTestUtil.isA(binaryName, (TypeNode)superClass);
            }
            for (ASTClassOrInterfaceType itf : ((ASTClassOrInterfaceDeclaration)n).getSuperInterfacesTypeNodes()) {
                if (!TypeTestUtil.isA(binaryName, (TypeNode)itf)) continue;
                return true;
            }
        } else {
            if (n instanceof ASTEnumDeclaration) {
                ASTImplementsList implemented = (ASTImplementsList)n.getFirstChildOfType(ASTImplementsList.class);
                if (implemented != null) {
                    for (ASTClassOrInterfaceType itf : implemented) {
                        if (!TypeTestUtil.isA(binaryName, (TypeNode)itf)) continue;
                        return true;
                    }
                }
                return "java.lang.Enum".equals(binaryName) || "java.lang.Comparable".equals(binaryName) || "java.io.Serializable".equals(binaryName) || "java.lang.Object".equals(binaryName);
            }
            if (n instanceof ASTAnnotationTypeDeclaration) {
                return "java.lang.annotation.Annotation".equals(binaryName) || "java.lang.Object".equals(binaryName);
            }
        }
        return false;
    }

    static Class<?> loadClassWithNodeClassloader(TypeNode n, String clazzName) {
        if (n.getType() != null) {
            return TypesFromReflection.loadClass(n.getRoot().getClassTypeResolver(), clazzName);
        }
        return null;
    }
}

