/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotationTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public class FieldDeclarationsShouldBeAtStartOfClassRule
extends AbstractJavaRule {
    private final PropertyDescriptor<Boolean> ignoreEnumDeclarations = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"ignoreEnumDeclarations").defaultValue((Object)true)).desc("Ignore Enum Declarations that precede fields.")).build();
    private final PropertyDescriptor<Boolean> ignoreAnonymousClassDeclarations = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"ignoreAnonymousClassDeclarations").defaultValue((Object)true)).desc("Ignore Field Declarations, that are initialized with anonymous class declarations")).build();
    private final PropertyDescriptor<Boolean> ignoreInterfaceDeclarations = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"ignoreInterfaceDeclarations").defaultValue((Object)false)).desc("Ignore Interface Declarations that precede fields.")).build();

    public FieldDeclarationsShouldBeAtStartOfClassRule() {
        this.definePropertyDescriptor(this.ignoreEnumDeclarations);
        this.definePropertyDescriptor(this.ignoreAnonymousClassDeclarations);
        this.definePropertyDescriptor(this.ignoreInterfaceDeclarations);
    }

    @Override
    public Object visit(ASTFieldDeclaration node, Object data) {
        JavaNode parent = ((JavaNode)node.getParent()).getParent();
        for (int i = 0; i < parent.getNumChildren(); ++i) {
            Node child = parent.getChild(i);
            if (child.getNumChildren() > 0) {
                child = this.skipAnnotations(child);
            }
            if (child.equals(node)) break;
            if (child instanceof ASTFieldDeclaration || node.hasDescendantOfType(ASTClassOrInterfaceBodyDeclaration.class) && ((Boolean)this.getProperty(this.ignoreAnonymousClassDeclarations)).booleanValue()) continue;
            if (child instanceof ASTMethodDeclaration || child instanceof ASTConstructorDeclaration || child instanceof ASTAnnotationTypeDeclaration) {
                this.addViolation(data, node);
                break;
            }
            if (child instanceof ASTClassOrInterfaceDeclaration) {
                ASTClassOrInterfaceDeclaration declaration = (ASTClassOrInterfaceDeclaration)child;
                if (declaration.isInterface() && ((Boolean)this.getProperty(this.ignoreInterfaceDeclarations)).booleanValue()) continue;
                this.addViolation(data, node);
                break;
            }
            if (!(child instanceof ASTEnumDeclaration) || ((Boolean)this.getProperty(this.ignoreEnumDeclarations)).booleanValue()) continue;
            this.addViolation(data, node);
            break;
        }
        return data;
    }

    private Node skipAnnotations(Node child) {
        Node nextChild = child.getChild(0);
        for (int j = 0; j < child.getNumChildren(); ++j) {
            if (child.getChild(j) instanceof ASTAnnotation) continue;
            nextChild = child.getChild(j);
            break;
        }
        return nextChild;
    }
}

