/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.AbstractNode;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAssignmentOperator;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTBlockStatement;
import net.sourceforge.pmd.lang.java.ast.ASTContinueStatement;
import net.sourceforge.pmd.lang.java.ast.ASTDoStatement;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTForInit;
import net.sourceforge.pmd.lang.java.ast.ASTForStatement;
import net.sourceforge.pmd.lang.java.ast.ASTForUpdate;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPostfixExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPreDecrementExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPreIncrementExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.ASTStatement;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchStatement;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.ASTWhileStatement;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaTypeNode;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.performance.AbstractOptimizationRule;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public class AvoidReassigningLoopVariablesRule
extends AbstractOptimizationRule {
    private static final Map<String, ForeachReassignOption> FOREACH_REASSIGN_VALUES;
    private static final PropertyDescriptor<ForeachReassignOption> FOREACH_REASSIGN;
    private static final Map<String, ForReassignOption> FOR_REASSIGN_VALUES;
    private static final PropertyDescriptor<ForReassignOption> FOR_REASSIGN;

    public AvoidReassigningLoopVariablesRule() {
        this.definePropertyDescriptor(FOREACH_REASSIGN);
        this.definePropertyDescriptor(FOR_REASSIGN);
        this.addRuleChainVisit(ASTLocalVariableDeclaration.class);
    }

    @Override
    public Object visit(ASTLocalVariableDeclaration node, Object data) {
        ASTStatement loopBody;
        HashSet<String> loopVariables = new HashSet<String>();
        for (ASTVariableDeclaratorId declaratorId : node.findDescendantsOfType(ASTVariableDeclaratorId.class)) {
            loopVariables.add(declaratorId.getImage());
        }
        if (node.getParent() instanceof ASTForInit) {
            loopBody = (ASTStatement)((JavaNode)node.getParent()).getParent().getFirstChildOfType(ASTStatement.class);
            ForReassignOption forReassign = (ForReassignOption)((Object)this.getProperty(FOR_REASSIGN));
            if (forReassign != ForReassignOption.ALLOW) {
                this.checkAssignExceptIncrement(data, loopVariables, loopBody, new IgnoreFlags[0]);
                if (forReassign == ForReassignOption.SKIP) {
                    this.checkIncrementAndDecrement(data, loopVariables, loopBody, IgnoreFlags.IGNORE_CONDITIONAL);
                } else {
                    this.checkIncrementAndDecrement(data, loopVariables, loopBody, new IgnoreFlags[0]);
                }
            }
        } else if (node.getParent() instanceof ASTForStatement) {
            loopBody = (ASTStatement)((JavaNode)node.getParent()).getFirstChildOfType(ASTStatement.class);
            ForeachReassignOption foreachReassign = (ForeachReassignOption)((Object)this.getProperty(FOREACH_REASSIGN));
            if (foreachReassign == ForeachReassignOption.FIRST_ONLY) {
                this.checkAssignExceptIncrement(data, loopVariables, loopBody, IgnoreFlags.IGNORE_FIRST);
                this.checkIncrementAndDecrement(data, loopVariables, loopBody, IgnoreFlags.IGNORE_FIRST);
            } else if (foreachReassign == ForeachReassignOption.DENY) {
                this.checkAssignExceptIncrement(data, loopVariables, loopBody, new IgnoreFlags[0]);
                this.checkIncrementAndDecrement(data, loopVariables, loopBody, new IgnoreFlags[0]);
            }
        }
        return data;
    }

    private void checkAssignExceptIncrement(Object data, Set<String> loopVariables, ASTStatement loopBody, IgnoreFlags ... ignoreFlags) {
        this.checkAssignments(data, loopVariables, loopBody, false, ignoreFlags);
    }

    private void checkIncrementAndDecrement(Object data, Set<String> loopVariables, ASTStatement loopBody, IgnoreFlags ... ignoreFlags) {
        for (AbstractJavaTypeNode expression : loopBody.findDescendantsOfType(ASTPostfixExpression.class)) {
            if (this.ignoreNode((Node)expression, loopBody, ignoreFlags)) continue;
            this.checkVariable(data, loopVariables, (AbstractNode)this.singleVariableName((ASTPrimaryExpression)expression.getFirstDescendantOfType(ASTPrimaryExpression.class)));
        }
        for (AbstractJavaTypeNode expression : loopBody.findDescendantsOfType(ASTPreIncrementExpression.class)) {
            if (this.ignoreNode((Node)expression, loopBody, ignoreFlags)) continue;
            this.checkVariable(data, loopVariables, (AbstractNode)this.singleVariableName((ASTPrimaryExpression)expression.getFirstDescendantOfType(ASTPrimaryExpression.class)));
        }
        for (AbstractJavaTypeNode expression : loopBody.findDescendantsOfType(ASTPreDecrementExpression.class)) {
            if (this.ignoreNode((Node)expression, loopBody, ignoreFlags)) continue;
            this.checkVariable(data, loopVariables, (AbstractNode)this.singleVariableName((ASTPrimaryExpression)expression.getFirstDescendantOfType(ASTPrimaryExpression.class)));
        }
        this.checkAssignments(data, loopVariables, loopBody, true, ignoreFlags);
    }

    private void checkAssignments(Object data, Set<String> loopVariables, ASTStatement loopBody, boolean checkIncrement, IgnoreFlags ... ignoreFlags) {
        for (ASTAssignmentOperator operator : loopBody.findDescendantsOfType(ASTAssignmentOperator.class)) {
            String operatorImage = operator.getImage();
            boolean isIncrement = "+=".equals(operatorImage) || "-=".equals(operatorImage);
            if (isIncrement != checkIncrement || this.ignoreNode((Node)operator, loopBody, ignoreFlags)) continue;
            ASTPrimaryExpression primaryExpression = (ASTPrimaryExpression)((JavaNode)operator.getParent()).getFirstChildOfType(ASTPrimaryExpression.class);
            this.checkVariable(data, loopVariables, (AbstractNode)this.singleVariableName(primaryExpression));
        }
    }

    private boolean ignoreNode(Node node, ASTStatement loopBody, IgnoreFlags ... ignoreFlags) {
        if (ignoreFlags.length == 0) {
            return false;
        }
        List<IgnoreFlags> ignoreFlagsList = Arrays.asList(ignoreFlags);
        boolean ignoredFirstStatement = ignoreFlagsList.contains((Object)IgnoreFlags.IGNORE_FIRST) && this.isFirstStatementInBlock(node, loopBody);
        boolean ignoredConditional = ignoreFlagsList.contains((Object)IgnoreFlags.IGNORE_CONDITIONAL) && this.isConditionallyExecuted(node, loopBody);
        return ignoredFirstStatement || ignoredConditional;
    }

    private ASTName singleVariableName(ASTPrimaryExpression primaryExpression) {
        ASTPrimaryPrefix primaryPrefix = (ASTPrimaryPrefix)primaryExpression.getFirstChildOfType(ASTPrimaryPrefix.class);
        ASTPrimarySuffix primarySuffix = (ASTPrimarySuffix)primaryExpression.getFirstChildOfType(ASTPrimarySuffix.class);
        if (primarySuffix != null || primaryPrefix == null) {
            return null;
        }
        return (ASTName)primaryPrefix.getFirstChildOfType(ASTName.class);
    }

    private boolean isFirstStatementInBlock(Node node, ASTStatement loopBody) {
        ASTBlockStatement statement = (ASTBlockStatement)node.getFirstParentOfType(ASTBlockStatement.class);
        ASTBlock block = (ASTBlock)loopBody.getFirstDescendantOfType(ASTBlock.class);
        if (statement == null || block == null) {
            return false;
        }
        return block.equals(statement.getParent()) && statement.getIndexInParent() == 0;
    }

    private boolean isConditionallyExecuted(Node node, ASTStatement loopBody) {
        Node checkNode = node;
        while (checkNode.getParent() != null && !checkNode.getParent().equals(loopBody)) {
            Node parent = checkNode.getParent();
            if (parent instanceof ASTIfStatement || parent instanceof ASTSwitchStatement || parent instanceof ASTWhileStatement || parent instanceof ASTDoStatement) {
                return !(checkNode instanceof ASTExpression);
            }
            if (parent instanceof ASTForStatement) {
                return !(checkNode instanceof ASTForInit) && !(checkNode instanceof ASTExpression) && !(checkNode instanceof ASTForUpdate);
            }
            checkNode = parent;
        }
        ASTBlock block = (ASTBlock)loopBody.getFirstDescendantOfType(ASTBlock.class);
        if (block != null) {
            for (int i = 0; i < block.getNumChildren(); ++i) {
                Node statement = block.getChild(i);
                if (statement.hasDescendantOfType(ASTContinueStatement.class)) {
                    return true;
                }
                if (!this.isParent(statement, node)) continue;
                return false;
            }
        }
        return false;
    }

    private boolean isParent(Node possibleParent, Node node) {
        Node checkNode = node;
        while (checkNode.getParent() != null) {
            if (checkNode.getParent().equals(possibleParent)) {
                return true;
            }
            checkNode = checkNode.getParent();
        }
        return false;
    }

    private void checkVariable(Object data, Set<String> loopVariables, AbstractNode node) {
        if (node != null && loopVariables.contains(node.getImage())) {
            this.addViolation(data, (Node)node, node.getImage());
        }
    }

    static {
        HashMap<String, Enum> map = new HashMap<String, Enum>();
        map.put("deny", ForeachReassignOption.DENY);
        map.put("firstOnly", ForeachReassignOption.FIRST_ONLY);
        map.put("allow", ForeachReassignOption.ALLOW);
        FOREACH_REASSIGN_VALUES = Collections.unmodifiableMap(map);
        FOREACH_REASSIGN = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.enumProperty((String)"foreachReassign", FOREACH_REASSIGN_VALUES).defaultValue((Object)ForeachReassignOption.DENY)).desc("how/if foreach control variables may be reassigned")).build();
        map = new HashMap();
        map.put("deny", ForReassignOption.DENY);
        map.put("skip", ForReassignOption.SKIP);
        map.put("allow", ForReassignOption.ALLOW);
        FOR_REASSIGN_VALUES = Collections.unmodifiableMap(map);
        FOR_REASSIGN = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.enumProperty((String)"forReassign", FOR_REASSIGN_VALUES).defaultValue((Object)ForReassignOption.DENY)).desc("how/if for control variables may be reassigned")).build();
    }

    private static enum IgnoreFlags {
        IGNORE_FIRST,
        IGNORE_CONDITIONAL;

    }

    private static enum ForReassignOption {
        DENY,
        SKIP,
        ALLOW;


        public String toString() {
            for (Map.Entry entry : FOR_REASSIGN_VALUES.entrySet()) {
                if (!((ForReassignOption)((Object)entry.getValue())).equals((Object)this)) continue;
                return (String)entry.getKey();
            }
            return super.toString();
        }
    }

    private static enum ForeachReassignOption {
        DENY,
        FIRST_ONLY,
        ALLOW;


        public String toString() {
            for (Map.Entry entry : FOREACH_REASSIGN_VALUES.entrySet()) {
                if (!((ForeachReassignOption)((Object)entry.getValue())).equals((Object)this)) continue;
                return (String)entry.getKey();
            }
            return super.toString();
        }
    }
}

