/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.extremity;

import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.UDrawable;
import net.sourceforge.plantuml.klimt.shape.UEllipse;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.svek.extremity.Extremity;

class ExtremityPlus
extends Extremity {
    private final UEllipse circle;
    private final double px;
    private final double py;
    private static final double radius = 8.0;
    private final double angle;
    private final HColor backgroundColor;

    private ExtremityPlus(double x, double y, double angle, HColor backgroundColor) {
        this.angle = angle;
        this.circle = UEllipse.build(16.0, 16.0);
        this.px = x;
        this.py = y;
        this.backgroundColor = backgroundColor;
    }

    @Override
    public XPoint2D somePoint() {
        return new XPoint2D(this.px, this.py);
    }

    public static UDrawable create(XPoint2D p1, double angle, HColor backgroundColor) {
        double x = p1.getX() - 8.0 + 8.0 * Math.sin(angle);
        double y = p1.getY() - 8.0 - 8.0 * Math.cos(angle);
        return new ExtremityPlus(x, y, angle, backgroundColor);
    }

    @Override
    public void drawU(UGraphic ug) {
        ug.apply(this.backgroundColor.bg()).apply(new UTranslate(this.px + 0.0, this.py + 0.0)).draw(this.circle);
        ExtremityPlus.drawLine(ug, 0.0, 0.0, this.getPointOnCircle(this.angle - 1.5707963267948966), this.getPointOnCircle(this.angle + 1.5707963267948966));
        ExtremityPlus.drawLine(ug, 0.0, 0.0, this.getPointOnCircle(this.angle), this.getPointOnCircle(this.angle + Math.PI));
    }

    private XPoint2D getPointOnCircle(double angle) {
        double x = this.px + 8.0 + 8.0 * Math.cos(angle);
        double y = this.py + 8.0 + 8.0 * Math.sin(angle);
        return new XPoint2D(x, y);
    }

    private static void drawLine(UGraphic ug, double x, double y, XPoint2D p1, XPoint2D p2) {
        double dx = p2.getX() - p1.getX();
        double dy = p2.getY() - p1.getY();
        ug.apply(new UTranslate(x + p1.getX(), y + p1.getY())).draw(new ULine(dx, dy));
    }

    @Override
    public double getDecorationLength() {
        return 16.0;
    }
}

