/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.style;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.style.NoStyleAvailableException;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.Value;
import net.sourceforge.plantuml.style.ValueImpl;
import net.sourceforge.plantuml.style.parser.StyleParser;
import net.sourceforge.plantuml.style.parser.StyleParsingException;
import net.sourceforge.plantuml.utils.BlocLines;
import net.sourceforge.plantuml.utils.LineLocation;
import net.sourceforge.plantuml.utils.LineLocationImpl;
import net.sourceforge.plantuml.utils.Log;

public final class StyleLoader {
    private static final Map<String, SoftReference<StyleBuilder>> cache = new ConcurrentHashMap<String, SoftReference<StyleBuilder>>();
    public static final int DELTA_PRIORITY_FOR_STEREOTYPE = 1000;

    private StyleLoader() {
    }

    public static StyleBuilder loadSkin(String filename) throws IOException, StyleParsingException {
        StyleBuilder builder;
        SoftReference<StyleBuilder> ref = cache.get(filename);
        StyleBuilder styleBuilder = builder = ref == null ? null : ref.get();
        if (builder == null) {
            builder = StyleLoader.loadSkinSlow(filename);
            cache.put(filename, new SoftReference<StyleBuilder>(builder));
        }
        return builder.cloneMe();
    }

    private static StyleBuilder loadSkinSlow(String filename) throws IOException, StyleParsingException {
        StyleBuilder styleBuilder = new StyleBuilder();
        InputStream internalIs = StyleLoader.getInputStreamForStyle(filename);
        if (internalIs == null) {
            Log.error("No .skin file seems to be available");
            throw new NoStyleAvailableException();
        }
        BlocLines lines2 = BlocLines.load(internalIs, (LineLocation)new LineLocationImpl(filename, null));
        for (Style newStyle : StyleParser.parse(lines2, styleBuilder)) {
            styleBuilder.loadInternal(newStyle.getSignature(), newStyle);
        }
        return styleBuilder;
    }

    public static InputStream getInputStreamForStyle(String filename) throws IOException {
        InputStream internalIs = null;
        SFile localFile = new SFile(filename);
        Log.info("Trying to load style " + filename);
        try {
            if (!localFile.exists()) {
                localFile = FileSystem.getInstance().getFile(filename);
            }
        }
        catch (IOException e) {
            Log.info("Cannot open file. " + e);
        }
        if (localFile.exists()) {
            Log.info("File found : " + localFile.getPrintablePath());
            internalIs = localFile.openFile();
        } else {
            Log.info("File not found : " + localFile.getPrintablePath());
            String res = "/skin/" + filename;
            internalIs = StyleLoader.class.getResourceAsStream(res);
            if (internalIs != null) {
                Log.info("... but " + filename + " found inside the .jar");
            }
        }
        return internalIs;
    }

    public static Map<PName, Value> addPriorityForStereotype(Map<PName, Value> tmp) {
        EnumMap<PName, Value> result = new EnumMap<PName, Value>(PName.class);
        for (Map.Entry<PName, Value> ent : tmp.entrySet()) {
            result.put(ent.getKey(), ((ValueImpl)ent.getValue()).addPriority(1000));
        }
        return result;
    }
}

