/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.text.FoxSignature;
import net.sourceforge.plantuml.text.TLineType;
import net.sourceforge.plantuml.utils.LineLocation;

public final class StringLocated {
    private final String s;
    private final LineLocation location;
    private final String preprocessorError;
    private StringLocated trimmed;
    private long fox = -1L;
    private TLineType type;
    private static final Pattern TRIPLE_PATTERN = Pattern.compile("!!!|'''|\"\"\"");

    public List<StringLocated> expandsJawsForPreprocessor() {
        return Arrays.asList(this);
    }

    private int searchMultilineTripleSeparators() {
        Matcher matcher = TRIPLE_PATTERN.matcher(this.s);
        if (matcher.find()) {
            return matcher.start();
        }
        return -1;
    }

    public List<StringLocated> expandsJaws5() {
        ArrayList<StringLocated> copy = new ArrayList<StringLocated>();
        for (String s : this.expandsJaws3()) {
            copy.add(new StringLocated(s, this.location, this.preprocessorError));
        }
        return copy;
    }

    public StringLocated jawsHideBackslash() {
        return new StringLocated(this.s.replace('\\', '\ue110'), this.location, this.preprocessorError);
    }

    public List<String> expandsJaws3() {
        return Arrays.asList(this.s.split("\ue100"));
    }

    public static List<String> expandsJaws4(String s) {
        return Arrays.asList(s.split("\ue100"));
    }

    public StringLocated(String s, LineLocation location) {
        this(s, location, null);
    }

    public StringLocated(String s, LineLocation location, String preprocessorError) {
        this.s = Objects.requireNonNull(s);
        this.location = location;
        this.preprocessorError = preprocessorError;
    }

    public String toString() {
        return this.s;
    }

    public StringLocated append(String endOfLine) {
        return new StringLocated(this.s + endOfLine, this.location, this.preprocessorError);
    }

    public StringLocated append(char endOfLine) {
        return new StringLocated(this.s + endOfLine, this.location, this.preprocessorError);
    }

    public StringLocated mergeEndBackslash(StringLocated next) {
        if (!StringUtils.endsWithBackslash(this.s)) {
            throw new IllegalArgumentException();
        }
        return new StringLocated(this.s.substring(0, this.s.length() - 1) + next.s, this.location, this.preprocessorError);
    }

    public StringLocated withErrorPreprocessor(String preprocessorError) {
        return new StringLocated(this.s, this.location, preprocessorError);
    }

    public StringLocated substring(int start, int end) {
        return new StringLocated(this.getString().substring(start, end), this.getLocation(), this.getPreprocessorError());
    }

    public StringLocated substring(int start) {
        return new StringLocated(this.getString().substring(start), this.getLocation(), this.getPreprocessorError());
    }

    public StringLocated getTrimmed() {
        if (this.trimmed == null) {
            this.trimmed = new StringLocated(StringUtils.trin(this.getString()), this.location, this.preprocessorError);
            this.trimmed.fox = this.fox;
            this.trimmed.trimmed = this.trimmed;
        }
        return this.trimmed;
    }

    public StringLocated removeInnerComment() {
        int idx;
        String string = this.s.toString();
        String trim = string.replace('\t', ' ').trim();
        if (trim.startsWith("/'") && (idx = string.indexOf("'/")) != -1) {
            return new StringLocated(this.removeSpecialInnerComment(this.s.substring(idx + 2, this.s.length())), this.location, this.preprocessorError);
        }
        if (trim.endsWith("'/") && (idx = string.lastIndexOf("/'")) != -1) {
            return new StringLocated(this.removeSpecialInnerComment(this.s.substring(0, idx)), this.location, this.preprocessorError);
        }
        if (trim.contains("/'''") && trim.contains("'''/")) {
            return new StringLocated(this.removeSpecialInnerComment(this.s), this.location, this.preprocessorError);
        }
        return this;
    }

    private String removeSpecialInnerComment(String s) {
        if (s.contains("/'''") && s.contains("'''/")) {
            return s.replaceAll("/'''[-\\w]*'''/", "");
        }
        return s;
    }

    public String getString() {
        return this.s;
    }

    public LineLocation getLocation() {
        return this.location;
    }

    public String getPreprocessorError() {
        return this.preprocessorError;
    }

    public long getFoxSignature() {
        if (this.fox == -1L) {
            this.fox = FoxSignature.getFoxSignatureFromRealString(this.getString());
        }
        return this.fox;
    }

    public TLineType getType() {
        if (this.type == null) {
            this.type = TLineType.getFromLineInternal(this.s);
        }
        return this.type;
    }

    public int length() {
        return this.s.length();
    }

    public char charAt(int i) {
        return this.s.charAt(i);
    }
}

