/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sdot;

import gen.lib.cgraph.attr__c;
import gen.lib.cgraph.edge__c;
import gen.lib.cgraph.graph__c;
import gen.lib.cgraph.node__c;
import gen.lib.cgraph.subg__c;
import gen.lib.gvc.gvc__c;
import gen.lib.gvc.gvlayout__c;
import h.ST_Agedge_s;
import h.ST_Agnode_s;
import h.ST_Agraph_s;
import h.ST_Agraphinfo_t;
import h.ST_Agrec_s;
import h.ST_GVC_s;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.atmp.CucaDiagram;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.abel.CucaNote;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.GroupType;
import net.sourceforge.plantuml.abel.LeafType;
import net.sourceforge.plantuml.abel.Link;
import net.sourceforge.plantuml.abel.LinkArrow;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.eggs.QuoteUtils;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.CreoleMode;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.MinMaxMutable;
import net.sourceforge.plantuml.klimt.geom.Rankdir;
import net.sourceforge.plantuml.klimt.geom.VerticalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.sdot.BoxInfo;
import net.sourceforge.plantuml.sdot.SmetanaEdge;
import net.sourceforge.plantuml.sdot.YMirror;
import net.sourceforge.plantuml.skin.AlignmentParam;
import net.sourceforge.plantuml.skin.UmlDiagramType;
import net.sourceforge.plantuml.skin.VisibilityModifier;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.ClusterHeader;
import net.sourceforge.plantuml.svek.CucaDiagramFileMaker;
import net.sourceforge.plantuml.svek.GeneralImageBuilder;
import net.sourceforge.plantuml.svek.GraphvizCrash;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.SvekNode;
import net.sourceforge.plantuml.svek.image.EntityImageNote;
import net.sourceforge.plantuml.svek.image.EntityImageNoteLink;
import net.sourceforge.plantuml.utils.Position;
import smetana.core.CString;
import smetana.core.Globals;
import smetana.core.JUtils;
import smetana.core.Macro;
import smetana.core.debug.SmetanaDebug;

public class CucaDiagramFileMakerSmetana
extends CucaDiagramFileMaker {
    private final Map<Entity, ST_Agnode_s> nodes = new LinkedHashMap<Entity, ST_Agnode_s>();
    private final Map<Entity, ST_Agnode_s> coreNodes = new LinkedHashMap<Entity, ST_Agnode_s>();
    private final Map<Link, ST_Agedge_s> edges = new LinkedHashMap<Link, ST_Agedge_s>();
    private final Map<Link, SmetanaEdge> smetanaPathes = new LinkedHashMap<Link, SmetanaEdge>();
    private final Map<Entity, ST_Agraph_s> clusters = new LinkedHashMap<Entity, ST_Agraph_s>();
    private final Rankdir rankdir;
    private static final Lock lock = new ReentrantLock();

    public CucaDiagramFileMakerSmetana(CucaDiagram diagram) {
        super(diagram);
        this.rankdir = diagram.getSkinParam().getRankdir();
    }

    private MinMaxMutable getSmetanaMinMax() {
        MinMaxMutable result = MinMaxMutable.getEmpty(false);
        for (ST_Agnode_s n : this.nodes.values()) {
            BoxInfo data = BoxInfo.fromNode(n);
            result.addPoint(data.getUpperRight());
            result.addPoint(data.getLowerLeft());
        }
        for (ST_Agraph_s gr : this.clusters.values()) {
            ST_Agrec_s tmp1 = gr.data;
            if (!(tmp1 instanceof ST_Agraphinfo_t)) {
                System.err.println("ERROR IN CucaDiagramFileMakerSmetana");
                continue;
            }
            ST_Agraphinfo_t info = (ST_Agraphinfo_t)tmp1;
            BoxInfo data = BoxInfo.fromGraphInfo(info);
            result.addPoint(data.getUpperRight());
            result.addPoint(data.getLowerLeft());
        }
        return result;
    }

    private boolean isOpalisable(Entity entity) {
        if (entity.isGroup()) {
            return false;
        }
        if (entity.getLeafType() != LeafType.NOTE) {
            return false;
        }
        Link single = this.onlyOneLink(entity);
        if (single == null) {
            return false;
        }
        return single.getOther(entity).getLeafType() != LeafType.NOTE;
    }

    private Link onlyOneLink(Entity ent) {
        Link single = null;
        for (Link link : this.diagram.getLinks()) {
            if (link.isInvis() || !link.contains(ent)) continue;
            if (single != null) {
                return null;
            }
            single = link;
        }
        return single;
    }

    private void drawGroup(UGraphic ug, YMirror ymirror, Entity group, ST_Agraph_s gr) {
        JUtils.LOG2("drawGroup");
        try {
            ST_Agrec_s tmp1 = gr.data;
            ST_Agraphinfo_t data = (ST_Agraphinfo_t)tmp1;
            BoxInfo boxInfo = BoxInfo.fromGraphInfo(data);
            XPoint2D upperRight = ymirror.getMirrored(boxInfo.getUpperRight());
            XPoint2D lowerLeft = ymirror.getMirrored(boxInfo.getLowerLeft());
            Cluster cluster = this.getBibliotekon().getCluster(group);
            cluster.setPosition(upperRight, lowerLeft);
            XDimension2D dimTitle = cluster.getTitleDimension(ug.getStringBounder());
            if (dimTitle != null) {
                double x = (upperRight.getX() + lowerLeft.getX()) / 2.0 - dimTitle.getWidth() / 2.0;
                cluster.setTitlePosition(new XPoint2D(x, Math.min(upperRight.getY(), lowerLeft.getY())));
            }
            JUtils.LOG2("cluster=" + cluster);
            cluster.drawU(ug);
        }
        catch (Exception e) {
            System.err.println("CANNOT DRAW GROUP");
        }
    }

    private void printAllSubgroups(StringBounder stringBounder, Entity parent) {
        for (Entity g : this.diagram.getChildrenGroups(parent)) {
            if (g.isRemoved()) continue;
            if (this.diagram.isEmpty(g) && g.getGroupType() == GroupType.PACKAGE) {
                g.muteToType(LeafType.EMPTY_PACKAGE);
                this.printEntity(stringBounder, g);
                continue;
            }
            this.printSingleGroup(stringBounder, g);
        }
    }

    private void printSingleGroup(StringBounder stringBounder, Entity g) {
        if (g.getGroupType() == GroupType.CONCURRENT_STATE) {
            return;
        }
        if (!g.isPacked()) {
            ClusterHeader clusterHeader = new ClusterHeader(g, this.diagram, stringBounder);
            this.clusterManager.openCluster(g, clusterHeader);
        }
        this.printEntities(stringBounder, g.leafs());
        this.printAllSubgroups(stringBounder, g);
        if (!g.isPacked()) {
            this.clusterManager.closeCluster();
        }
    }

    private void printEntities(StringBounder stringBounder, Collection<Entity> entities) {
        for (Entity ent : entities) {
            if (ent.isRemoved()) continue;
            this.printEntity(stringBounder, ent);
        }
    }

    private void exportEntities(Globals zz, ST_Agraph_s cluster, Collection<Entity> entities) {
        for (Entity ent : entities) {
            if (ent.isRemoved()) continue;
            this.exportEntity(zz, cluster, ent);
        }
    }

    private XDimension2D getDim(SvekNode node) {
        double width = node.getWidth() / 72.0;
        double height = node.getHeight() / 72.0;
        return new XDimension2D(width, height);
    }

    private ST_Agnode_s getCoreFromGroup(Globals zz, Entity group) {
        ST_Agnode_s result = this.coreNodes.get(group);
        if (result != null) {
            return result;
        }
        ST_Agraph_s cluster = this.clusters.get(group);
        if (cluster == null) {
            throw new IllegalStateException();
        }
        result = node__c.agnode(zz, cluster, new CString("z" + group.getUid()), true);
        attr__c.agsafeset(zz, result, new CString("shape"), new CString("box"), new CString(""));
        attr__c.agsafeset(zz, result, new CString("width"), new CString("0.1"), new CString(""));
        attr__c.agsafeset(zz, result, new CString("height"), new CString("0.1"), new CString(""));
        this.coreNodes.put(group, result);
        return result;
    }

    private void exportEntity(Globals zz, ST_Agraph_s cluster, Entity leaf) {
        SvekNode node = this.getBibliotekon().getNode(leaf);
        if (node == null) {
            System.err.println("CANNOT FIND NODE");
            return;
        }
        ST_Agnode_s agnode = node__c.agnode(zz, cluster, new CString(node.getUid()), true);
        attr__c.agsafeset(zz, agnode, new CString("shape"), new CString("box"), new CString(""));
        XDimension2D dim = this.getDim(node);
        String width = "" + dim.getWidth();
        String height = "" + dim.getHeight();
        attr__c.agsafeset(zz, agnode, new CString("width"), new CString(width), new CString(""));
        attr__c.agsafeset(zz, agnode, new CString("height"), new CString(height), new CString(""));
        this.nodes.put(leaf, agnode);
    }

    private void printEntity(StringBounder stringBounder, Entity ent) {
        if (ent.isRemoved()) {
            throw new IllegalStateException();
        }
        IEntityImage image = this.printEntityInternal(ent);
        SvekNode node = this.getBibliotekon().createNode(ent, image, stringBounder);
        this.clusterManager.addNode(node);
    }

    private Collection<Entity> getUnpackagedEntities() {
        ArrayList<Entity> result = new ArrayList<Entity>();
        for (Entity ent : this.diagram.leafs()) {
            if (this.diagram.getRootGroup() != ent.getParentContainer()) continue;
            result.add(ent);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImageData createFile(OutputStream os, List<String> dotStrings, FileFormatOption fileFormatOption) throws IOException {
        StringBounder stringBounder = fileFormatOption.getDefaultStringBounder(this.diagram.getSkinParam());
        this.printAllSubgroups(stringBounder, this.diagram.getRootGroup());
        this.printEntities(stringBounder, this.getUnpackagedEntities());
        for (Link link : this.diagram.getLinks()) {
            SvekNode other;
            SvekNode node;
            if (link.isRemoved()) continue;
            if (this.isOpalisable(link.getEntity1())) {
                node = this.getBibliotekon().getNode(link.getEntity1());
                other = this.getBibliotekon().getNode(link.getEntity2());
                if (other == null) continue;
                ((EntityImageNote)node.getImage()).setOpaleLink(link, node, other, this.smetanaPathes);
                link.setOpale(true);
                continue;
            }
            if (!this.isOpalisable(link.getEntity2())) continue;
            node = this.getBibliotekon().getNode(link.getEntity2());
            other = this.getBibliotekon().getNode(link.getEntity1());
            if (other == null) continue;
            ((EntityImageNote)node.getImage()).setOpaleLink(link, node, other, this.smetanaPathes);
            link.setOpale(true);
        }
        lock.lock();
        try {
            ImageData imageData = this.createFileLocked(os, dotStrings, fileFormatOption);
            return imageData;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createOneGraphic(UGraphic ug) {
        Globals zz = Globals.open();
        try {
            TextBlock textBlock = this.getTextBlock(ug.getStringBounder(), zz);
            textBlock.drawU(ug);
        }
        catch (Throwable e) {
            SmetanaDebug.printMe();
        }
        finally {
            Globals.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageData createFileLocked(OutputStream os, List<String> dotStrings, FileFormatOption fileFormatOption) throws IOException {
        Globals zz = Globals.open();
        try {
            StringBounder stringBounder = fileFormatOption.getDefaultStringBounder(this.diagram.getSkinParam());
            TextBlock drawable = this.getTextBlock(stringBounder, zz);
            ImageData imageData = this.diagram.createImageBuilder(fileFormatOption).drawable(drawable).write(os);
            return imageData;
        }
        catch (Throwable e) {
            SmetanaDebug.printMe();
            UmlDiagram.exportDiagramError(os, e, fileFormatOption, this.diagram.seed(), this.diagram.getMetadata(), this.diagram.getFlashData(), CucaDiagramFileMakerSmetana.getFailureText3(e));
            ImageData imageData = ImageDataSimple.error();
            return imageData;
        }
        finally {
            Globals.close();
        }
    }

    private TextBlock getTextBlock(StringBounder stringBounder, Globals zz) {
        ST_Agraph_s g = graph__c.agopen(zz, new CString("g"), zz.Agdirected, null);
        this.exportEntities(zz, g, this.getUnpackagedEntities());
        this.exportGroups(zz, g, this.diagram.getRootGroup());
        for (Link link : this.diagram.getLinks()) {
            ST_Agedge_s e = this.createEdge(stringBounder, zz, g, link);
            if (e == null) continue;
            this.edges.put(link, e);
        }
        ST_GVC_s gvc = gvc__c.gvContext(zz, new Object[0]);
        SmetanaDebug.reset();
        if (this.rankdir == Rankdir.LEFT_TO_RIGHT) {
            attr__c.agsafeset(zz, g, new CString("rankdir"), new CString("LR"), new CString("LR"));
        }
        gvlayout__c.gvLayoutJobs(zz, gvc, g);
        SmetanaDebug.printMe();
        Drawing drawable = new Drawing();
        return drawable;
    }

    private void exportGroups(Globals zz, ST_Agraph_s graph, Entity parent) {
        for (Entity g : this.diagram.getChildrenGroups(parent)) {
            if (g.isRemoved()) continue;
            if (this.diagram.isEmpty(g) && g.getGroupType() == GroupType.PACKAGE) {
                this.exportEntity(zz, graph, g);
                continue;
            }
            this.exportGroup(zz, graph, g);
        }
    }

    private void exportGroup(Globals zz, ST_Agraph_s graph, Entity group) {
        if (group.isPacked()) {
            this.exportEntities(zz, graph, group.leafs());
            this.exportGroups(zz, graph, group);
            return;
        }
        Cluster cluster = this.getBibliotekon().getCluster(group);
        if (cluster == null) {
            System.err.println("CucaDiagramFileMakerSmetana::exportGroup issue");
            return;
        }
        JUtils.LOG2("cluster = " + cluster.getClusterId());
        ST_Agraph_s cluster1 = subg__c.agsubg(zz, graph, new CString(cluster.getClusterId()), true);
        if (cluster.isLabel()) {
            double width = cluster.getTitleAndAttributeWidth();
            double height = cluster.getTitleAndAttributeHeight() - 5;
            attr__c.agsafeset(zz, cluster1, new CString("label"), this.createLabelDim(width, height), new CString(""));
        }
        this.exportEntities(zz, cluster1, group.leafs());
        this.clusters.put(group, cluster1);
        this.exportGroups(zz, cluster1, group);
    }

    private CString createLabelDim(double width, double height) {
        return Macro.createHackInitDimensionFromLabel((int)width, (int)height);
    }

    private Style getStyle() {
        return StyleSignatureBasic.of(SName.root, SName.element, this.diagram.getUmlDiagramType().getStyleName(), SName.arrow).getMergedStyle(this.diagram.getSkinParam().getCurrentStyleBuilder());
    }

    public final StyleSignature getDefaultStyleDefinitionArrow(Stereotype stereotype, SName styleName) {
        StyleSignature result = StyleSignatureBasic.of(SName.root, SName.element, styleName, SName.arrow);
        if (stereotype != null) {
            result = result.withTOBECHANGED(stereotype);
        }
        return result;
    }

    private FontConfiguration getFontForLink(Link link, ISkinParam skinParam) {
        SName styleName = skinParam.getUmlDiagramType().getStyleName();
        Style style = this.getDefaultStyleDefinitionArrow(link.getStereotype(), styleName).getMergedStyle(link.getStyleBuilder());
        return style.getFontConfiguration(skinParam.getIHtmlColorSet());
    }

    private HorizontalAlignment getMessageTextAlignment(UmlDiagramType umlDiagramType, ISkinParam skinParam) {
        if (umlDiagramType == UmlDiagramType.STATE) {
            return skinParam.getHorizontalAlignment(AlignmentParam.stateMessageAlignment, null, false, null);
        }
        return skinParam.getDefaultTextAlignment(HorizontalAlignment.CENTER);
    }

    private TextBlock addVisibilityModifier(TextBlock block, Link link, ISkinParam skinParam) {
        VisibilityModifier visibilityModifier = link.getVisibilityModifier();
        if (visibilityModifier != null) {
            Rose rose = new Rose();
            HColor fore = rose.getHtmlColor(skinParam, visibilityModifier.getForeground());
            TextBlock visibility = visibilityModifier.getUBlock(skinParam.classAttributeIconSize(), fore, null, false);
            visibility = TextBlockUtils.withMargin(visibility, 0.0, 1.0, 2.0, 0.0);
            block = TextBlockUtils.mergeLR(visibility, block, VerticalAlignment.CENTER);
        }
        double marginLabel = 1.0;
        return TextBlockUtils.withMargin(block, 1.0, 1.0);
    }

    private LinkArrow getLinkArrow(Link link) {
        return link.getLinkArrow();
    }

    private TextBlock getLabel(StringBounder stringBounder, Link link) {
        CucaNote note;
        TextBlock labelOnly;
        ISkinParam skinParam = this.diagram.getSkinParam();
        double marginLabel = 1.0;
        UmlDiagramType type = skinParam.getUmlDiagramType();
        FontConfiguration font = this.getFontForLink(link, skinParam);
        if (Display.isNull(link.getLabel())) {
            labelOnly = TextBlockUtils.EMPTY_TEXT_BLOCK;
            if (this.getLinkArrow(link) != LinkArrow.NONE_OR_SEVERAL) {
                // empty if block
            }
        } else {
            HorizontalAlignment alignment = this.getMessageTextAlignment(type, skinParam);
            boolean hasSeveralGuideLines = link.getLabel().hasSeveralGuideLines();
            TextBlock block = link.getLabel().create0(font, alignment, skinParam, skinParam.maxMessageSize(), CreoleMode.SIMPLE_LINE, null, null);
            labelOnly = this.addVisibilityModifier(block, link, skinParam);
            if (this.getLinkArrow(link) == LinkArrow.NONE_OR_SEVERAL || !hasSeveralGuideLines) {
                // empty if block
            }
        }
        if ((note = link.getNote()) == null) {
            if (!TextBlockUtils.isEmpty(labelOnly, stringBounder)) {
                labelOnly = TextBlockUtils.withMargin(labelOnly, 1.0, 1.0);
            }
            return labelOnly;
        }
        EntityImageNoteLink noteOnly = new EntityImageNoteLink(note.getDisplay(), note.getColors(), skinParam, link.getStyleBuilder());
        if (note.getPosition() == Position.LEFT) {
            return TextBlockUtils.mergeLR(noteOnly, labelOnly, VerticalAlignment.CENTER);
        }
        if (note.getPosition() == Position.RIGHT) {
            return TextBlockUtils.mergeLR(labelOnly, noteOnly, VerticalAlignment.CENTER);
        }
        if (note.getPosition() == Position.TOP) {
            return TextBlockUtils.mergeTB((TextBlock)noteOnly, labelOnly, HorizontalAlignment.CENTER);
        }
        return TextBlockUtils.mergeTB(labelOnly, noteOnly, HorizontalAlignment.CENTER);
    }

    private TextBlock getQuantifier(StringBounder stringBounder, Link link, int n) {
        String tmp;
        String string = tmp = n == 1 ? link.getQuantifier1() : link.getQuantifier2();
        if (tmp == null) {
            return null;
        }
        double marginLabel = 1.0;
        ISkinParam skinParam = this.diagram.getSkinParam();
        Style style = this.getStyle();
        FontConfiguration labelFont = style.getFontConfiguration(skinParam.getIHtmlColorSet());
        TextBlock label = Display.getWithNewlines(this.diagram.getPragma(), tmp).create(labelFont, skinParam.getDefaultTextAlignment(HorizontalAlignment.CENTER), skinParam);
        if (TextBlockUtils.isEmpty(label, stringBounder)) {
            return label;
        }
        return TextBlockUtils.withMargin(label, 1.0, 1.0);
    }

    private ST_Agnode_s getAgnodeFromLeaf(Entity entity) {
        ST_Agnode_s n = this.nodes.get(entity);
        if (n != null) {
            return n;
        }
        try {
            String id = this.getBibliotekon().getNodeUid(entity);
            for (Map.Entry<Entity, ST_Agnode_s> ent : this.nodes.entrySet()) {
                if (!id.equals(this.getBibliotekon().getNodeUid(ent.getKey()))) continue;
                return ent.getValue();
            }
        }
        catch (IllegalStateException e) {
            System.err.println("UNKNOWN ENTITY");
        }
        return null;
    }

    private ST_Agedge_s createEdge(StringBounder stringBounder, Globals zz, ST_Agraph_s g, Link link) {
        TextBlock q2;
        TextBlock q1;
        ST_Agnode_s node1 = link.getEntity1().isGroup() ? this.getCoreFromGroup(zz, link.getEntity1()) : this.getAgnodeFromLeaf(link.getEntity1());
        ST_Agnode_s node2 = link.getEntity2().isGroup() ? this.getCoreFromGroup(zz, link.getEntity2()) : this.getAgnodeFromLeaf(link.getEntity2());
        if (node1 == null || node2 == null) {
            return null;
        }
        ST_Agedge_s e = edge__c.agedge(zz, g, node1, node2, null, true);
        attr__c.agsafeset(zz, e, new CString("arrowtail"), new CString("none"), new CString(""));
        attr__c.agsafeset(zz, e, new CString("arrowhead"), new CString("none"), new CString(""));
        int length = link.getLength();
        attr__c.agsafeset(zz, e, new CString("minlen"), new CString("" + (length - 1)), new CString(""));
        TextBlock label = this.getLabel(stringBounder, link);
        if (!TextBlockUtils.isEmpty(label, stringBounder)) {
            XDimension2D dimLabel = label.calculateDimension(stringBounder);
            CString hackDim = this.createLabelDim(dimLabel.getWidth(), dimLabel.getHeight());
            attr__c.agsafeset(zz, e, new CString("label"), hackDim, new CString(""));
        }
        if ((q1 = this.getQuantifier(stringBounder, link, 1)) != null) {
            XDimension2D dimLabel = q1.calculateDimension(stringBounder);
            CString hackDim = this.createLabelDim(dimLabel.getWidth(), dimLabel.getHeight());
            attr__c.agsafeset(zz, e, new CString("taillabel"), hackDim, new CString(""));
        }
        if ((q2 = this.getQuantifier(stringBounder, link, 2)) != null) {
            XDimension2D dimLabel = q2.calculateDimension(stringBounder);
            CString hackDim = this.createLabelDim(dimLabel.getWidth(), dimLabel.getHeight());
            attr__c.agsafeset(zz, e, new CString("headlabel"), hackDim, new CString(""));
        }
        return e;
    }

    private static List<String> getFailureText3(Throwable exception) {
        Logme.error(exception);
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("An error has occured : " + exception);
        String quote = StringUtils.rot(QuoteUtils.getSomeQuote());
        strings.add("<i>" + quote);
        strings.add(" ");
        GraphvizCrash.addProperties(strings);
        strings.add(" ");
        strings.add("Sorry, the subproject Smetana is not finished yet...");
        strings.add(" ");
        strings.add("You should send this diagram and this image to <b>plantuml@gmail.com</b> or");
        strings.add("post to <b>https://plantuml.com/qa</b> to solve this issue.");
        strings.add(" ");
        return strings;
    }

    private IEntityImage printEntityInternal(Entity ent) {
        if (ent.isRemoved()) {
            throw new IllegalStateException();
        }
        if (ent.getSvekImage() == null) {
            ISkinParam skinParam = this.diagram.getSkinParam();
            if (skinParam.sameClassWidth()) {
                System.err.println("NOT YET IMPLEMENED");
            }
            IEntityImage result = GeneralImageBuilder.createEntityImageBlock(ent, this.diagram.isHideEmptyDescriptionForState(), this.diagram, this.getBibliotekon(), null, this.diagram.getLinks());
            ent.setSvekImage(result);
            return result;
        }
        return ent.getSvekImage();
    }

    class Drawing
    extends AbstractTextBlock {
        private final YMirror ymirror;
        private final MinMaxMutable minMax;

        public Drawing() {
            this.minMax = CucaDiagramFileMakerSmetana.this.getSmetanaMinMax();
            this.ymirror = new YMirror(this.minMax.getMaxY() + 6.0);
        }

        @Override
        public void drawU(UGraphic ug) {
            CucaDiagramFileMakerSmetana.this.smetanaPathes.clear();
            ug = ug.apply(new UTranslate(6.0, 6.0 - this.minMax.getMinY()));
            for (Map.Entry ent : CucaDiagramFileMakerSmetana.this.edges.entrySet()) {
                Link link = (Link)ent.getKey();
                if (link.isInvis()) continue;
                ST_Agedge_s edge = (ST_Agedge_s)ent.getValue();
                SmetanaEdge smetanaPath = new SmetanaEdge(link, edge, this.ymirror, CucaDiagramFileMakerSmetana.this.getLabel(ug.getStringBounder(), link), CucaDiagramFileMakerSmetana.this.getQuantifier(ug.getStringBounder(), link, 1), CucaDiagramFileMakerSmetana.this.getQuantifier(ug.getStringBounder(), link, 2), CucaDiagramFileMakerSmetana.this.getBibliotekon(), CucaDiagramFileMakerSmetana.this.diagram.getSkinParam());
                CucaDiagramFileMakerSmetana.this.smetanaPathes.put(link, smetanaPath);
            }
            for (Map.Entry ent : CucaDiagramFileMakerSmetana.this.clusters.entrySet()) {
                CucaDiagramFileMakerSmetana.this.drawGroup(ug, this.ymirror, (Entity)ent.getKey(), (ST_Agraph_s)ent.getValue());
            }
            for (Map.Entry ent : CucaDiagramFileMakerSmetana.this.nodes.entrySet()) {
                Entity leaf = (Entity)ent.getKey();
                ST_Agnode_s agnode = (ST_Agnode_s)ent.getValue();
                XPoint2D corner = this.getCorner(agnode);
                SvekNode node = CucaDiagramFileMakerSmetana.this.getBibliotekon().getNode(leaf);
                node.resetMove();
                node.moveDelta(corner.getX(), corner.getY());
                IEntityImage image = node.getImage();
                image.drawU(ug.apply(UTranslate.point(corner)));
            }
            for (Map.Entry ent : CucaDiagramFileMakerSmetana.this.smetanaPathes.entrySet()) {
                if (((Link)ent.getKey()).isOpale()) continue;
                ((SmetanaEdge)ent.getValue()).drawU(ug);
            }
        }

        @Override
        public XDimension2D calculateDimension(StringBounder stringBounder) {
            return this.minMax.getDimension().delta(6.0);
        }

        private XPoint2D getCorner(ST_Agnode_s n) {
            BoxInfo data = BoxInfo.fromNode(n);
            return this.ymirror.getMirrored(data.getLowerLeft());
        }

        @Override
        public HColor getBackcolor() {
            return null;
        }
    }
}

