/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.objectdiagram;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.abel.DisplayPositioned;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.LeafType;
import net.sourceforge.plantuml.abel.Link;
import net.sourceforge.plantuml.abel.LinkArg;
import net.sourceforge.plantuml.abel.NoteLinkStrategy;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.decoration.LinkDecor;
import net.sourceforge.plantuml.decoration.LinkType;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.plasma.Quark;
import net.sourceforge.plantuml.skin.UmlDiagramType;

public abstract class AbstractClassOrObjectDiagram
extends AbstractEntityDiagram {
    private final List<Association> associations = new ArrayList<Association>();

    public AbstractClassOrObjectDiagram(UmlSource source, UmlDiagramType type, Map<String, String> orig) {
        super(source, type, orig);
        this.setNamespaceSeparator(".");
    }

    public final boolean insertBetween(Entity entity1, Entity entity2, Entity node) {
        Link link = this.foundLink(entity1, entity2);
        if (link == null) {
            return false;
        }
        Link l1 = new Link(this, this.getSkinParam().getCurrentStyleBuilder(), entity1, node, link.getType(), LinkArg.build(link.getLabel(), link.getLength(), this.getSkinParam().classAttributeIconSize() > 0).withQuantifier(link.getQuantifier1(), null).withDistanceAngle(link.getLabeldistance(), link.getLabelangle()));
        Link l2 = new Link(this, this.getSkinParam().getCurrentStyleBuilder(), node, entity2, link.getType(), LinkArg.build(link.getLabel(), link.getLength(), this.getSkinParam().classAttributeIconSize() > 0).withQuantifier(null, link.getQuantifier2()).withDistanceAngle(link.getLabeldistance(), link.getLabelangle()));
        this.addLink(l1);
        this.addLink(l2);
        this.removeLink(link);
        return true;
    }

    private Link foundLink(Entity entity1, Entity entity2) {
        List<Link> links = this.getLinks();
        for (int i = links.size() - 1; i >= 0; --i) {
            Link l = links.get(i);
            if (!l.isBetween(entity1, entity2)) continue;
            return l;
        }
        return null;
    }

    public int getNbOfHozizontalLollipop(Entity entity) {
        if (entity.getLeafType() == LeafType.LOLLIPOP_FULL || entity.getLeafType() == LeafType.LOLLIPOP_HALF) {
            throw new IllegalArgumentException();
        }
        int result = 0;
        for (Link link : this.getLinks()) {
            if (link.getLength() != 1 || !link.contains(entity) || !link.containsType(LeafType.LOLLIPOP_FULL) && !link.containsType(LeafType.LOLLIPOP_HALF)) continue;
            ++result;
        }
        return result;
    }

    public CommandExecutionResult associationClass(Entity entity1A, Entity entity1B, Entity entity2A, Entity entity2B, LinkType linkType, Display label) {
        List<Association> same1 = this.getExistingAssociatedPoints(entity1A, entity1B);
        List<Association> same2 = this.getExistingAssociatedPoints(entity2A, entity2B);
        if (same1.size() == 0 && same2.size() == 0) {
            String tmp1 = this.getUniqueSequence("apoint");
            String tmp2 = this.getUniqueSequence("apoint");
            Quark<Entity> code1 = this.getCurrentGroup().getQuark().child(tmp1);
            Entity point1 = this.reallyCreateLeaf(code1, Display.getWithNewlines(this.getPragma(), ""), LeafType.POINT_FOR_ASSOCIATION, null);
            Quark<Entity> code2 = this.getCurrentGroup().getQuark().child(tmp2);
            Entity point2 = this.reallyCreateLeaf(code2, Display.getWithNewlines(this.getPragma(), ""), LeafType.POINT_FOR_ASSOCIATION, null);
            this.insertPointBetween(entity1A, entity1B, point1);
            this.insertPointBetween(entity2A, entity2B, point2);
            boolean length = true;
            Link point1ToPoint2 = new Link(this, this.getSkinParam().getCurrentStyleBuilder(), point1, point2, linkType, LinkArg.build(label, 1));
            this.addLink(point1ToPoint2);
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Cannot link two associations points");
    }

    private void insertPointBetween(Entity entity1A, Entity entity1B, Entity point1) {
        Link existingLink1 = this.foundLink(entity1A, entity1B);
        if (existingLink1 == null) {
            existingLink1 = new Link(this, this.getSkinParam().getCurrentStyleBuilder(), entity1A, entity1B, new LinkType(LinkDecor.NONE, LinkDecor.NONE), LinkArg.noDisplay(2));
        } else {
            this.removeLink(existingLink1);
        }
        Entity entity1real = existingLink1.isInverted() ? existingLink1.getEntity2() : existingLink1.getEntity1();
        Entity entity2real = existingLink1.isInverted() ? existingLink1.getEntity1() : existingLink1.getEntity2();
        Link entity1ToPoint = new Link(this, this.getSkinParam().getCurrentStyleBuilder(), entity1real, point1, existingLink1.getType().getPart2(), LinkArg.build(existingLink1.getLabel(), existingLink1.getLength()).withQuantifier(existingLink1.getQuantifier1(), null).withDistanceAngle(existingLink1.getLabeldistance(), existingLink1.getLabelangle()));
        entity1ToPoint.setLinkArrow(existingLink1.getLinkArrow());
        Link pointToEntity2 = new Link(this, this.getSkinParam().getCurrentStyleBuilder(), point1, entity2real, existingLink1.getType().getPart1(), LinkArg.noDisplay(existingLink1.getLength()).withQuantifier(null, existingLink1.getQuantifier2()).withDistanceAngle(existingLink1.getLabeldistance(), existingLink1.getLabelangle()));
        this.addLink(entity1ToPoint);
        this.addLink(pointToEntity2);
    }

    public boolean associationClass(int mode, Entity entity1, Entity entity2, Entity associed, LinkType linkType, Display label) {
        List<Association> same = this.getExistingAssociatedPoints(entity1, entity2);
        if (same.size() > 1) {
            return false;
        }
        if (same.size() == 0) {
            Association association = new Association(mode, entity1, entity2, associed);
            association.createNew(mode, linkType, label);
            this.associations.add(association);
            return true;
        }
        assert (same.size() == 1);
        Association association = same.get(0).createSecondAssociation(mode, associed, label);
        association.createInSecond(linkType, label);
        this.associations.add(association);
        return true;
    }

    private List<Association> getExistingAssociatedPoints(Entity entity1, Entity entity2) {
        ArrayList<Association> same = new ArrayList<Association>();
        for (Association existing : this.associations) {
            if (!existing.sameCouple(entity1, entity2)) continue;
            same.add(existing);
        }
        return same;
    }

    @Override
    public void setLegend(DisplayPositioned legend) {
        Entity currentGroup = this.getCurrentGroup();
        if (currentGroup.isRoot()) {
            super.setLegend(legend);
            return;
        }
        currentGroup.setLegend(legend);
    }

    class Association {
        private Entity entity1;
        private Entity entity2;
        private Entity associed;
        private Entity point;
        private Link existingLink;
        private Link entity1ToPoint;
        private Link pointToEntity2;
        private Link pointToAssocied;
        private Association other;

        public Association(int mode, Entity entity1, Entity entity2, Entity associed) {
            this.entity1 = entity1;
            this.entity2 = entity2;
            this.associed = associed;
            String idShort = AbstractClassOrObjectDiagram.this.getUniqueSequence("apoint");
            Quark<Entity> quark = entity1.getQuark().getParent() == entity2.getQuark().getParent() ? entity1.getQuark().getParent().child(idShort) : AbstractClassOrObjectDiagram.this.quarkInContext(true, AbstractClassOrObjectDiagram.this.cleanId(idShort));
            this.point = AbstractClassOrObjectDiagram.this.reallyCreateLeaf(quark, Display.getWithNewlines(AbstractClassOrObjectDiagram.this.getPragma(), ""), LeafType.POINT_FOR_ASSOCIATION, null);
        }

        public Association createSecondAssociation(int mode2, Entity associed2, Display label) {
            Association result = new Association(mode2, this.entity1, this.entity2, associed2);
            result.existingLink = this.existingLink;
            result.other = this;
            if (this.existingLink.getLength() == 1) {
                this.entity1ToPoint.setLength(2);
                this.pointToEntity2.setLength(2);
                this.pointToAssocied.setLength(1);
            }
            return result;
        }

        void createNew(int mode, LinkType linkType, Display label) {
            this.existingLink = AbstractClassOrObjectDiagram.this.foundLink(this.entity1, this.entity2);
            if (this.existingLink == null) {
                this.existingLink = new Link(AbstractClassOrObjectDiagram.this, AbstractClassOrObjectDiagram.this.getSkinParam().getCurrentStyleBuilder(), this.entity1, this.entity2, new LinkType(LinkDecor.NONE, LinkDecor.NONE), LinkArg.noDisplay(2));
            } else {
                AbstractClassOrObjectDiagram.this.removeLink(this.existingLink);
            }
            Entity entity1real = this.existingLink.isInverted() ? this.existingLink.getEntity2() : this.existingLink.getEntity1();
            Entity entity2real = this.existingLink.isInverted() ? this.existingLink.getEntity1() : this.existingLink.getEntity2();
            this.entity1ToPoint = new Link(AbstractClassOrObjectDiagram.this, AbstractClassOrObjectDiagram.this.getSkinParam().getCurrentStyleBuilder(), entity1real, this.point, this.existingLink.getType().getPart2(), LinkArg.build(this.existingLink.getLabel(), this.existingLink.getLength()).withQuantifier(this.existingLink.getQuantifier1(), null).withDistanceAngle(this.existingLink.getLabeldistance(), this.existingLink.getLabelangle()));
            this.entity1ToPoint.setLinkArrow(this.existingLink.getLinkArrow());
            this.pointToEntity2 = new Link(AbstractClassOrObjectDiagram.this, AbstractClassOrObjectDiagram.this.getSkinParam().getCurrentStyleBuilder(), this.point, entity2real, this.existingLink.getType().getPart1(), LinkArg.noDisplay(this.existingLink.getLength()).withQuantifier(null, this.existingLink.getQuantifier2()).withDistanceAngle(this.existingLink.getLabeldistance(), this.existingLink.getLabelangle()));
            int length = 1;
            if (this.existingLink.getLength() == 1 && this.entity1 != this.entity2) {
                length = 2;
            }
            if (this.existingLink.getLength() == 2 && this.entity1 == this.entity2) {
                length = 2;
            }
            if (length == 1) {
                this.entity1ToPoint.addNoteFrom(this.existingLink, NoteLinkStrategy.NORMAL);
            } else {
                this.entity1ToPoint.addNoteFrom(this.existingLink, NoteLinkStrategy.HALF_PRINTED_FULL);
                this.pointToEntity2.addNoteFrom(this.existingLink, NoteLinkStrategy.HALF_NOT_PRINTED);
            }
            AbstractClassOrObjectDiagram.this.addLink(this.entity1ToPoint);
            AbstractClassOrObjectDiagram.this.addLink(this.pointToEntity2);
            this.pointToAssocied = mode == 1 ? new Link(AbstractClassOrObjectDiagram.this, AbstractClassOrObjectDiagram.this.getSkinParam().getCurrentStyleBuilder(), this.point, this.associed, linkType, LinkArg.build(label, length)) : new Link(AbstractClassOrObjectDiagram.this, AbstractClassOrObjectDiagram.this.getSkinParam().getCurrentStyleBuilder(), this.associed, this.point, linkType, LinkArg.build(label, length));
            AbstractClassOrObjectDiagram.this.addLink(this.pointToAssocied);
        }

        void createInSecond(LinkType linkType, Display label) {
            this.existingLink = AbstractClassOrObjectDiagram.this.foundLink(this.entity1, this.entity2);
            if (this.existingLink == null) {
                this.existingLink = new Link(AbstractClassOrObjectDiagram.this, AbstractClassOrObjectDiagram.this.getSkinParam().getCurrentStyleBuilder(), this.entity1, this.entity2, new LinkType(LinkDecor.NONE, LinkDecor.NONE), LinkArg.noDisplay(2));
            } else {
                AbstractClassOrObjectDiagram.this.removeLink(this.existingLink);
            }
            this.entity1ToPoint = new Link(AbstractClassOrObjectDiagram.this, AbstractClassOrObjectDiagram.this.getSkinParam().getCurrentStyleBuilder(), this.entity1, this.point, this.existingLink.getType().getPart2(), LinkArg.build(this.existingLink.getLabel(), 2).withQuantifier(this.existingLink.getQuantifier1(), null).withDistanceAngle(this.existingLink.getLabeldistance(), this.existingLink.getLabelangle()));
            this.pointToEntity2 = new Link(AbstractClassOrObjectDiagram.this, AbstractClassOrObjectDiagram.this.getSkinParam().getCurrentStyleBuilder(), this.point, this.entity2, this.existingLink.getType().getPart1(), LinkArg.noDisplay(2).withQuantifier(null, this.existingLink.getQuantifier2()).withDistanceAngle(this.existingLink.getLabeldistance(), this.existingLink.getLabelangle()));
            AbstractClassOrObjectDiagram.this.addLink(this.entity1ToPoint);
            AbstractClassOrObjectDiagram.this.addLink(this.pointToEntity2);
            if (this.other.pointToAssocied.getEntity1().getLeafType() == LeafType.POINT_FOR_ASSOCIATION) {
                AbstractClassOrObjectDiagram.this.removeLink(this.other.pointToAssocied);
                this.other.pointToAssocied = this.other.pointToAssocied.getInv();
                AbstractClassOrObjectDiagram.this.addLink(this.other.pointToAssocied);
            }
            this.pointToAssocied = new Link(AbstractClassOrObjectDiagram.this, AbstractClassOrObjectDiagram.this.getSkinParam().getCurrentStyleBuilder(), this.point, this.associed, linkType, LinkArg.build(label, 1));
            AbstractClassOrObjectDiagram.this.addLink(this.pointToAssocied);
            Link lnode = new Link(AbstractClassOrObjectDiagram.this, AbstractClassOrObjectDiagram.this.getSkinParam().getCurrentStyleBuilder(), this.other.point, this.point, new LinkType(LinkDecor.NONE, LinkDecor.NONE), LinkArg.noDisplay(1));
            lnode.setInvis(true);
            AbstractClassOrObjectDiagram.this.addLink(lnode);
        }

        boolean sameCouple(Entity entity1, Entity entity2) {
            if (this.entity1 == entity1 && this.entity2 == entity2) {
                return true;
            }
            return this.entity1 == entity2 && this.entity2 == entity1;
        }
    }
}

