/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.sprite;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import net.atmp.ImageBuilder;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.klimt.sprite.Sprite;
import net.sourceforge.plantuml.skin.UmlDiagramType;

public class ListSpriteDiagram
extends UmlDiagram {
    public ListSpriteDiagram(UmlSource source, Map<String, String> skinMap) {
        super(source, UmlDiagramType.HELP, skinMap);
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Sprites)");
    }

    @Override
    public ImageBuilder createImageBuilder(FileFormatOption fileFormatOption) throws IOException {
        return super.createImageBuilder(fileFormatOption).annotations(false);
    }

    @Override
    protected ImageData exportDiagramInternal(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        return this.createImageBuilder(fileFormatOption).drawable(this.getTextMainBlock(fileFormatOption)).write(os);
    }

    @Override
    protected TextBlock getTextMainBlock(FileFormatOption fileFormatOption) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                double x = 0.0;
                double y = 0.0;
                double rawHeight = 0.0;
                for (String n : ListSpriteDiagram.this.getSkinParam().getAllSpriteNames()) {
                    Sprite sprite = ListSpriteDiagram.this.getSkinParam().getSprite(n);
                    TextBlock blockName = Display.create(n).create(FontConfiguration.blackBlueTrue(UFont.sansSerif(14)), HorizontalAlignment.LEFT, ListSpriteDiagram.this.getSkinParam());
                    TextBlock tb = sprite.asTextBlock(HColors.BLACK, 1.0);
                    tb = TextBlockUtils.mergeTB(tb, blockName, HorizontalAlignment.CENTER);
                    tb.drawU(ug.apply(new UTranslate(x, y)));
                    XDimension2D dim = tb.calculateDimension(ug.getStringBounder());
                    rawHeight = Math.max(rawHeight, dim.getHeight());
                    x += dim.getWidth();
                    if (!((x += 30.0) > 1024.0)) continue;
                    x = 0.0;
                    y += rawHeight + 50.0;
                    rawHeight = 0.0;
                }
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                return new XDimension2D(1024.0, 1024.0);
            }
        };
    }
}

