/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.chronology;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.TitledDiagram;
import net.sourceforge.plantuml.WithSprite;
import net.sourceforge.plantuml.chronology.TaskChronology;
import net.sourceforge.plantuml.chronology.TimeHeaderChronology;
import net.sourceforge.plantuml.chronology.TimeScaleChronology;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColorSet;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.project.GanttStyle;
import net.sourceforge.plantuml.project.LabelPosition;
import net.sourceforge.plantuml.project.LabelStrategy;
import net.sourceforge.plantuml.project.LoadPlanable;
import net.sourceforge.plantuml.project.TimeHeaderParameters;
import net.sourceforge.plantuml.project.ToTaskDraw;
import net.sourceforge.plantuml.project.core.PrintScale;
import net.sourceforge.plantuml.project.core.Task;
import net.sourceforge.plantuml.project.core.TaskCode;
import net.sourceforge.plantuml.project.core.TaskGroup;
import net.sourceforge.plantuml.project.draw.TaskDraw;
import net.sourceforge.plantuml.project.draw.TaskDrawDiamond;
import net.sourceforge.plantuml.project.draw.TimeHeader;
import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.project.timescale.TimeScale;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.real.RealOrigin;
import net.sourceforge.plantuml.real.RealUtils;
import net.sourceforge.plantuml.skin.UmlDiagramType;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;

public class ChronologyDiagram
extends TitledDiagram
implements ToTaskDraw,
WithSprite,
GanttStyle {
    private final Map<Task, TaskDraw> draws = new LinkedHashMap<Task, TaskDraw>();
    private final Map<TaskCode, Task> tasks = new LinkedHashMap<TaskCode, Task>();
    private final HColorSet colorSet = HColorSet.instance();
    private LabelStrategy labelStrategy = new LabelStrategy(LabelPosition.LEGACY, HorizontalAlignment.LEFT);
    private Locale locale = Locale.ENGLISH;
    private Day min;
    private Day max;
    private TimeScaleChronology timeScale;
    private final RealOrigin origin = RealUtils.createOrigin();
    private TaskGroup currentGroup = null;

    public CommandExecutionResult changeLanguage(String lang) {
        this.locale = new Locale(lang);
        return CommandExecutionResult.ok();
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Chronology)");
    }

    public ChronologyDiagram(UmlSource source) {
        super(source, UmlDiagramType.CHRONOLOGY, null);
    }

    @Override
    protected ImageData exportDiagramNow(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        return this.createImageBuilder(fileFormatOption).drawable(this.getTextMainBlock(fileFormatOption)).write(os);
    }

    @Override
    protected TextBlock getTextMainBlock(FileFormatOption fileFormatOption) {
        StringBounder stringBounder = fileFormatOption.getDefaultStringBounder(this.getSkinParam());
        this.initMinMax();
        final TimeHeaderChronology timeHeader = new TimeHeaderChronology(stringBounder, this.thParam(), PrintScale.DAILY, this.timeScale);
        this.initTaskAndResourceDraws(timeHeader.getTimeScale(), ((TimeHeader)timeHeader).getFullHeaderHeight(stringBounder), stringBounder);
        return new AbstractTextBlock(){

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                return new XDimension2D(1000.0, 1000.0);
            }

            @Override
            public void drawU(UGraphic ug) {
                timeHeader.drawTimeHeader(ug, 200.0);
                ChronologyDiagram.this.drawTasksRect(ug);
                ChronologyDiagram.this.drawTasksTitle(ug, 0.0, 0.0);
            }
        };
    }

    private TimeHeaderParameters thParam() {
        return new TimeHeaderParameters(null, 1.0, this.min, this.max, this.getIHtmlColorSet(), this.locale, null, null, null, this, false);
    }

    @Override
    public final Style getStyle(SName param) {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.ganttDiagram, param).getMergedStyle(this.getCurrentStyleBuilder());
    }

    @Override
    public final Style getStyle(SName param1, SName param2) {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.ganttDiagram, param1, param2).getMergedStyle(this.getCurrentStyleBuilder());
    }

    private void drawTasksRect(UGraphic ug) {
        for (Task task : this.tasks.values()) {
            TaskDraw draw = this.draws.get(task);
            UTranslate move = UTranslate.dy(draw.getY(ug.getStringBounder()).getCurrentValue());
            draw.drawU(ug.apply(move));
        }
    }

    private void drawTasksTitle(UGraphic ug, double colTitles, double colBars) {
        for (Task task : this.tasks.values()) {
            TaskDraw draw = this.draws.get(task);
            UTranslate move = UTranslate.dy(draw.getY(ug.getStringBounder()).getCurrentValue());
            draw.drawTitle(ug.apply(move), this.labelStrategy, colTitles, colBars);
        }
    }

    private void initTaskAndResourceDraws(TimeScale timeScale, double headerHeight, StringBounder stringBounder) {
        Real y = this.origin;
        y = y.addFixed(headerHeight);
        for (Task task : this.tasks.values()) {
            String disp = task.getCode().getDisplay();
            TaskDrawDiamond draw = new TaskDrawDiamond(timeScale, y, disp, task.getStart(), task, this, task.getStyleBuilder());
            double height = draw.getFullHeightTask(stringBounder);
            y = y.addAtLeast(height);
            this.draws.put(task, draw);
        }
    }

    private void initMinMax() {
        if (this.tasks.size() == 0) {
            throw new IllegalStateException();
        }
        for (Task task : this.tasks.values()) {
            if (this.min == null || this.max == null) {
                this.min = task.getStart();
                this.max = task.getEnd();
                continue;
            }
            if (this.min.compareTo(task.getStart()) > 0) {
                this.min = task.getStart();
            }
            if (this.max.compareTo(task.getEnd()) >= 0) continue;
            this.max = task.getEnd();
        }
        this.min = this.min.roundDayDown();
        this.max = this.max.roundDayUp();
        this.timeScale = new TimeScaleChronology(1000.0);
        this.timeScale.setMin(this.min.getMillis());
        this.timeScale.setMax(this.max.getMillis());
    }

    public Task getOrCreateTask(TaskCode code, boolean linkedToPrevious) {
        Task result = this.tasks.get(Objects.requireNonNull(code));
        if (result == null) {
            result = new TaskChronology(this.getSkinParam().getCurrentStyleBuilder(), code);
            if (this.currentGroup != null) {
                this.currentGroup.addTask(result);
            }
            this.tasks.put(code, result);
        }
        return result;
    }

    @Override
    public LoadPlanable getDefaultPlan() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TaskDraw getTaskDraw(Task task) {
        return null;
    }

    @Override
    public HColorSet getIHtmlColorSet() {
        return this.colorSet;
    }
}

